/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.actions;

import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.ui.actions.OpenEditorActionGroup;
import org.eclipse.dltk.mod.ui.actions.OpenViewActionGroup;
import org.eclipse.dltk.mod.ui.actions.SearchActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;

public class NavigateActionGroup
extends ActionGroup {
    private OpenEditorActionGroup fOpenEditorActionGroup;
    private OpenViewActionGroup fOpenViewActionGroup;
    SearchActionGroup fSearchActionGroup;

    public NavigateActionGroup(IViewPart part) {
        IEditorPart editorPart;
        this.fOpenEditorActionGroup = new OpenEditorActionGroup(part);
        this.fOpenViewActionGroup = new OpenViewActionGroup(part);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && page.getActiveEditor() != null && (editorPart = page.getActiveEditor()) instanceof ScriptEditor) {
            this.fSearchActionGroup = new SearchActionGroup(part, ((ScriptEditor)editorPart).getLanguageToolkit());
        }
    }

    public IAction getOpenAction() {
        return this.fOpenEditorActionGroup.getOpenAction();
    }

    public void dispose() {
        super.dispose();
        this.fOpenEditorActionGroup.dispose();
        this.fOpenViewActionGroup.dispose();
        if (this.fSearchActionGroup != null) {
            this.fSearchActionGroup.dispose();
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.fOpenEditorActionGroup.fillActionBars(actionBars);
        this.fOpenViewActionGroup.fillActionBars(actionBars);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.fOpenEditorActionGroup.fillContextMenu(menu);
        this.fOpenViewActionGroup.fillContextMenu(menu);
        if (this.fSearchActionGroup != null) {
            this.fSearchActionGroup.fillContextMenu(menu);
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.fOpenEditorActionGroup.setContext(context);
        this.fOpenViewActionGroup.setContext(context);
        if (this.fSearchActionGroup != null) {
            this.fSearchActionGroup.setContext(context);
        }
    }

    public void updateActionBars() {
        super.updateActionBars();
        this.fOpenEditorActionGroup.updateActionBars();
        this.fOpenViewActionGroup.updateActionBars();
    }
}

