/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui.launchConf;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vjet.eclipse.internal.debug.ui.launchConf.ScriptSelectionDialog;

public class IncludeTab
extends AbstractLaunchConfigurationTab {
    public static final String TAB_ID = "rhino.include.tab";
    private TreeViewer viewer = null;
    private Button addfolder = null;
    private Button remove = null;
    private Button addexternalfolder = null;
    private Button addscript = null;
    private Button defaults = null;
    private Button up = null;
    private Button down = null;
    private Button subdirs = null;
    private Vector includes = new Vector();
    private ILaunchConfiguration backingconfig = null;
    private ViewerFilter vfilter = new ContainerFilter();
    public static final int FOLDER = 0;
    public static final int EXT_FOLDER = 1;
    public static final int SCRIPT = 2;
    private static final String JS_EXTENSION = "*.js";

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (int)2, (int)1, (int)768);
        SWTFactory.createWrapLabel((Composite)comp, (String)"include path", (int)2);
        Tree tree = new Tree(comp, 67586);
        tree.setLayout((Layout)new GridLayout(1, true));
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TreeViewer(tree);
        this.viewer.setLabelProvider((IBaseLabelProvider)new Labels());
        this.viewer.setContentProvider((IContentProvider)new Contents());
        this.viewer.setInput((Object)this.includes);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IncludeTab.this.updateButtons((IStructuredSelection)event.getSelection());
            }
        });
        Composite lhs = SWTFactory.createComposite((Composite)comp, (Font)comp.getFont(), (int)1, (int)1, (int)1040, (int)0, (int)0);
        this.up = SWTFactory.createPushButton((Composite)lhs, (String)"Up", null);
        this.up.setEnabled(false);
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeTab.this.up(((IStructuredSelection)IncludeTab.this.viewer.getSelection()).getFirstElement());
            }
        });
        this.down = SWTFactory.createPushButton((Composite)lhs, (String)"Down", null);
        this.down.setEnabled(false);
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeTab.this.down(((IStructuredSelection)IncludeTab.this.viewer.getSelection()).getFirstElement());
            }
        });
        this.remove = SWTFactory.createPushButton((Composite)lhs, (String)"Remove", null);
        this.remove.setEnabled(false);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeTab.this.remove((IStructuredSelection)IncludeTab.this.viewer.getSelection());
            }
        });
        this.addscript = SWTFactory.createPushButton((Composite)lhs, (String)"Add Script", null);
        this.addscript.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeTab.this.addScript();
            }
        });
        this.addexternalfolder = SWTFactory.createPushButton((Composite)lhs, (String)"Add External JS", null);
        this.addexternalfolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeTab.this.addExtScript();
            }
        });
        SWTFactory.createHorizontalSpacer((Composite)lhs, (int)1);
        this.defaults = SWTFactory.createPushButton((Composite)lhs, (String)"Default", null);
        this.defaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludeTab.this.defaults();
            }
        });
        this.setControl((Control)comp);
    }

    void updateButtons(IStructuredSelection selection) {
        int size = selection.size();
        if (size == 1) {
            Object element = selection.getFirstElement();
            int idx = this.includes.indexOf(element);
            this.up.setEnabled(idx > 0);
            this.down.setEnabled(idx < this.includes.size() - 1);
        }
        this.remove.setEnabled(size > 0);
    }

    void addScript() {
        IFile script;
        IncludeEntry entry;
        ScriptSelectionDialog dialog = new ScriptSelectionDialog(this.getShell(), true, (IContainer)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0 && !this.includes.contains(entry = new IncludeEntry(2, (script = (IFile)dialog.getFirstResult()).getLocation().toFile().getAbsolutePath()))) {
            this.includes.add(entry);
            this.viewer.refresh();
            this.updateLaunchConfigurationDialog();
        }
    }

    void addExtScript() {
        String path;
        String[] names;
        FileDialog dialog = new FileDialog(this.getShell(), 4098);
        dialog.setFilterExtensions(new String[]{JS_EXTENSION});
        dialog.setFilterIndex(0);
        dialog.setText("Select Scripts To Add");
        if (dialog.open() != null && (names = dialog.getFileNames()) != null && names.length > 0 && (path = dialog.getFilterPath()) != null) {
            boolean added = false;
            int i = 0;
            while (i < names.length) {
                File script = new File(path, names[i]);
                if (script.exists()) {
                    this.includes.add(new IncludeEntry(2, new Path(script.getAbsolutePath()).toString()));
                    added = true;
                }
                ++i;
            }
            if (added) {
                this.viewer.refresh();
                this.updateLaunchConfigurationDialog();
            }
        }
    }

    void up(Object element) {
        int idx = this.includes.indexOf(element);
        if (idx < 0) {
            return;
        }
        this.includes.remove(idx);
        this.includes.insertElementAt(element, idx - 1);
        this.viewer.refresh();
        this.updateLaunchConfigurationDialog();
    }

    void down(Object element) {
        int idx = this.includes.indexOf(element);
        if (idx < 0) {
            return;
        }
        this.includes.remove(idx);
        this.includes.insertElementAt(element, idx + 1);
        this.viewer.refresh();
        this.updateLaunchConfigurationDialog();
    }

    void remove(IStructuredSelection selection) {
        this.includes.removeAll(selection.toList());
        this.viewer.refresh();
        this.updateLaunchConfigurationDialog();
    }

    void defaults() {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.backingconfig = configuration;
        this.includes.clear();
        try {
            List list = configuration.getAttribute("includepath", null);
            if (list != null) {
                String value = null;
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    try {
                        value = (String)iter.next();
                        int kind = Integer.parseInt(value.substring(0, 1));
                        String path = value.substring(1);
                        this.includes.add(new IncludeEntry(kind, path));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                this.viewer.refresh();
            }
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.includes.isEmpty()) {
            configuration.removeAttribute("includepath");
        } else {
            ArrayList<String> list = new ArrayList<String>(this.includes.size());
            Iterator i = this.includes.iterator();
            while (i.hasNext()) {
                list.add(((IncludeEntry)i.next()).string());
            }
            configuration.setAttribute("includepath", list);
        }
    }

    public String getName() {
        return "includes";
    }

    public Image getImage() {
        return null;
    }

    public String getId() {
        return TAB_ID;
    }

    class ContainerFilter
    extends ViewerFilter {
        ContainerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof IContainer && ((IContainer)element).isAccessible();
        }
    }

    class Contents
    implements ITreeContentProvider {
        Contents() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Vector)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class IncludeEntry {
        public static final int LOCAL_SCRIPT = 1;
        public static final int EXT_SCRIPT = 2;
        int kind = -1;
        private String path = null;

        public IncludeEntry(int kind, String path) {
            this.kind = kind;
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        String string() {
            return String.valueOf(this.kind) + this.path;
        }
    }

    class Labels
    extends LabelProvider {
        Labels() {
        }

        public Image getImage(Object element) {
            IncludeEntry entry = (IncludeEntry)element;
            switch (entry.kind) {
                case 0: 
                case 1: {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
            }
            return null;
        }

        public String getText(Object element) {
            IncludeEntry entry = (IncludeEntry)element;
            return entry.getPath();
        }
    }
}

