/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui.html;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.dltk.mod.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.vjet.eclipse.internal.debug.ui.html.HtmlArgumentsTab;
import org.eclipse.vjet.eclipse.internal.debug.ui.html.HtmlLaunchUtils;

public class HtmlLocationBlock
extends AbstractLaunchConfigurationTab {
    private HtmlArgumentsTab htmlArgumentsTab;
    protected Text htmlName;
    protected Button searchButton;
    protected static final String EMPTY_STRING = "";

    public HtmlLocationBlock(HtmlArgumentsTab htmlArgumentsTab) {
        this.htmlArgumentsTab = htmlArgumentsTab;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("Html File:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.setControl((Control)parent);
        this.htmlName = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.htmlName.setLayoutData((Object)gd);
        this.htmlName.setFont(font);
        this.htmlName.setText("${resource_loc}");
        this.htmlName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                HtmlLocationBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.searchButton = this.createPushButton((Composite)group, " Search  ", null);
        this.searchButton.setLayoutData((Object)new GridData(128));
        this.htmlName.setText("dummy");
        this.searchButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HtmlLocationBlock.this.handleSearchButtonSelected();
            }
        });
    }

    protected void handleSearchButtonSelected() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(DLTKLaunchConfigurationsMessages.mainTab_searchButton_title);
        dialog.setMessage(DLTKLaunchConfigurationsMessages.mainTab_searchButton_message);
        dialog.setInput((Object)this.getProject());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    String extensionName = ((IFile)element).getFileExtension();
                    return "html".equalsIgnoreCase(extensionName) || "htm".equalsIgnoreCase(extensionName);
                }
                return true;
            }
        });
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getProjectRelativePath().toPortableString();
            this.htmlName.setText(arg);
        }
    }

    private IProject getProject() {
        return this.htmlArgumentsTab.getProject();
    }

    public String getName() {
        return "Html File";
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String file = this.getAttributeValueFrom(this.htmlName);
        if (file != null) {
            if (!file.endsWith(".htm") && !file.endsWith(".html")) {
                configuration.setAttribute("org.eclipse.jdt.launching.RESOURCE_LOC", EMPTY_STRING);
            } else {
                configuration.setAttribute("org.eclipse.jdt.launching.RESOURCE_LOC", this.getAttributeValueFrom(this.htmlName));
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.jdt.launching.RESOURCE_LOC", HtmlLaunchUtils.getSelectedResource());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.htmlName.setText(configuration.getAttribute("org.eclipse.jdt.launching.RESOURCE_LOC", EMPTY_STRING));
        }
        catch (CoreException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    public String getResourceLocation() {
        return this.htmlName.getText().trim();
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }
}

