/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.utils;

import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

public final class RDataUtil {
    public static String getDnsLabelFromRData(String rData) {
        if (rData == null || rData.trim().isEmpty()) {
            throw new IllegalArgumentException("rData cannot be null, empty, or blank");
        }
        if (rData.contains("._label")) {
            return rData.substring(0, rData.indexOf("._label"));
        }
        Name nameInRData = null;
        try {
            nameInRData = new Name(rData.trim());
        }
        catch (TextParseException tpe) {
            throw new IllegalArgumentException("rData must be valid domain name");
        }
        if (nameInRData.labels() < 2) {
            throw new IllegalArgumentException("rData does not have enough labels to return dns label for a service type");
        }
        String transportProtocolLabel = nameInRData.getLabelString(1);
        if (transportProtocolLabel.equals("_tcp") || transportProtocolLabel.equals("_udp")) {
            return nameInRData.getLabelString(0) + "." + transportProtocolLabel;
        }
        throw new IllegalArgumentException("Could not extract DNS Label from rData");
    }

    public static String getServiceTypeNameFromRData(String rData) {
        String serviceTypeName;
        if (rData == null || rData.trim().isEmpty()) {
            throw new IllegalArgumentException("rData cannot be null, empty, or blank");
        }
        if (rData.contains("._name") && !(serviceTypeName = rData.substring(0, rData.indexOf("._name")).trim()).isEmpty()) {
            return serviceTypeName;
        }
        throw new IllegalArgumentException("Could not extract Service Type name from rData");
    }

    public static String getServiceTypeRData(String rData) {
        if (rData == null || rData.trim().isEmpty()) {
            throw new IllegalArgumentException("rData cannot be null, empty, or blank");
        }
        String[] splitted = rData.split("\\.");
        if (splitted.length < 3) {
            throw new IllegalArgumentException("Invalid RData for a service type PTR: " + rData);
        }
        return splitted[0].replaceFirst("_", "");
    }

    private RDataUtil() {
        throw new AssertionError((Object)String.format("No instances of %s for you!", this.getClass().getCanonicalName()));
    }
}

