/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.domain;

import java.util.Set;
import org.eclipse.iot.tiaki.domain.DiscoveryRecord;
import org.xbill.DNS.TXTRecord;

public final class TextRecord
extends DiscoveryRecord {
    public static final TextRecord build(Set<TextRecord> txtsRec) {
        StringBuilder flattened = new StringBuilder();
        String owner = null;
        long max = Long.MIN_VALUE;
        for (TextRecord txt : txtsRec) {
            flattened.append(txt.getRData());
            if (txt.getTtl() > max) {
                max = txt.getTtl();
            }
            if (owner != null) continue;
            owner = txt.getOwner();
        }
        return new TextRecord(owner, flattened.toString(), max);
    }

    public static final TextRecord build(TXTRecord txtRec) {
        return new TextRecord(txtRec.rdataToString(), txtRec.getTTL());
    }

    private TextRecord(String txtData, long ttl) {
        super(txtData, ttl);
    }

    private TextRecord(String owner, String txtData, long ttl) {
        super(owner, txtData, ttl);
    }

    @Override
    public String getServiceType() {
        throw new UnsupportedOperationException("Not supported by TextRecord");
    }

    @Override
    public String getServiceZone(String dnsLabel) {
        throw new UnsupportedOperationException("Not supported by TextRecord");
    }

    @Override
    public String getServiceName(String dnsLabel) {
        throw new UnsupportedOperationException("Not supported by TextRecord");
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public String toDisplay() {
        return String.format("%d TXT %s", this.ttl, this.rData);
    }
}

