/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.domain;

import java.util.Objects;
import org.eclipse.iot.tiaki.domain.DiscoveryRecord;
import org.eclipse.iot.tiaki.utils.DnsUtil;
import org.xbill.DNS.SRVRecord;

public final class ServiceRecord
extends DiscoveryRecord {
    private final String host;
    private final String proto;
    private final int port;
    private final int priority;
    private final int weight;

    public static ServiceRecord build(SRVRecord srvRecord) {
        String proto = "N/A";
        String owner = srvRecord.getName().toString();
        if (owner.contains("_tcp")) {
            proto = "_tcp".replace("_", "").toUpperCase();
        } else if (owner.contains("_udp")) {
            proto = "_udp".replace("_", "").toUpperCase();
        }
        return new ServiceRecord(srvRecord.getName().toString(), srvRecord.getTarget().toString(), proto, srvRecord.getPort(), srvRecord.getPriority(), srvRecord.getWeight(), srvRecord.getTTL());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public long getTtl() {
        return this.ttl;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.port, this.priority, this.weight, this.ttl);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceRecord that = (ServiceRecord)obj;
        return this.compareTo(that) == 0;
    }

    @Override
    public String toString() {
        return String.format("%d \"%s\" %s %s:%d", this.ttl, DnsUtil.extractDnsSdDescription(this.owner), this.host.endsWith(".") ? this.host.substring(0, this.host.length() - 1) : this.host, this.proto, this.port);
    }

    @Override
    public int compareTo(DiscoveryRecord other) {
        if (other instanceof ServiceRecord) {
            ServiceRecord real = (ServiceRecord)other;
            if (this.priority < real.priority) {
                return -1;
            }
            if (this.priority > real.priority) {
                return 1;
            }
            if (this.weight > real.weight) {
                return -1;
            }
            if (this.weight < real.weight) {
                return 1;
            }
            if (!this.host.equals(real.host)) {
                return this.host.compareTo(real.host);
            }
            if (this.port > real.port) {
                return 1;
            }
            if (this.port < real.port) {
                return -1;
            }
            if (this.ttl < real.ttl) {
                return -1;
            }
            if (this.ttl > real.ttl) {
                return 1;
            }
        } else {
            return this.compareTo(other);
        }
        return 0;
    }

    private ServiceRecord(String host, String proto, int port, int priority, int weight, long ttl) {
        super(String.format("%s %s:%d %d %d %d", host, proto, port, priority, weight, ttl), ttl);
        this.host = host;
        this.proto = proto;
        this.port = port;
        this.priority = priority;
        this.weight = weight;
    }

    private ServiceRecord(String owner, String host, String proto, int port, int priority, int weight, long ttl) {
        super(owner, String.format("\"%s\" %s %s:%d %d %d %d", DnsUtil.extractDnsSdDescription(owner), host, proto, port, priority, weight, ttl), ttl);
        this.host = host;
        this.proto = proto;
        this.port = port;
        this.priority = priority;
        this.weight = weight;
    }

    @Override
    public String getServiceType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getServiceZone(String dnsLabel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getServiceName(String dnsLabel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String toDisplay() {
        return String.format("%d SRV %d %d %s:%d", this.ttl, this.priority, this.weight, this.host.endsWith(".") ? this.host.substring(0, this.host.length() - 1) : this.host, this.port);
    }
}

