/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.domain;

import java.util.Objects;

public class CompoundLabel {
    private static final String SEPARATOR = ":";
    private final String type;
    private final String subType;
    private final String proto;

    public static final boolean isCompound(String label) {
        if (label == null || label.isEmpty()) {
            throw new IllegalArgumentException("Input label cannot be NULL or EMPTY");
        }
        if (label.length() > 1) {
            return label.contains(SEPARATOR);
        }
        return false;
    }

    public static final boolean isValidCompound(String label) {
        if (label == null || label.isEmpty()) {
            throw new IllegalArgumentException("Input label cannot be NULL or EMPTY");
        }
        if (label.length() > 1 && label.contains(SEPARATOR)) {
            int nrTokens = label.split(SEPARATOR).length;
            return nrTokens > label.length() - label.replace(SEPARATOR, "").length() && !label.split(SEPARATOR)[0].isEmpty() && !label.split(SEPARATOR)[nrTokens - 1].isEmpty();
        }
        return false;
    }

    public static final String[] labelComponents(String label) {
        String[] parts = new String[]{"", "", ""};
        if (CompoundLabel.isValidCompound(label) && label.length() > 1) {
            String[] splitted = label.split(SEPARATOR);
            parts[0] = splitted[0];
            if (splitted.length > 1) {
                if (!splitted[1].isEmpty() && (splitted[1].equalsIgnoreCase("_tcp".replaceAll("_", "")) || splitted[1].equalsIgnoreCase("_udp".replaceAll("_", "")))) {
                    parts[2] = splitted[1].toLowerCase();
                    return parts;
                }
                parts[1] = splitted[1];
            }
            if (splitted.length > 2) {
                parts[2] = splitted[2].toLowerCase();
            }
            return parts;
        }
        throw new IllegalArgumentException("malformed 'Compound Label' supposed to be '<label[<:sublabel:proto>|<:proto>]>'");
    }

    public CompoundLabel buildByLabel(String label) {
        String[] parts = CompoundLabel.labelComponents(label);
        return new CompoundLabel(parts[0], parts[1], parts[2]);
    }

    public CompoundLabel(String type) {
        this(type, "");
    }

    public CompoundLabel(String type, String subType) {
        this(type, subType, "");
    }

    public CompoundLabel(String type, String subType, String proto) {
        this.type = type;
        this.subType = subType;
        this.proto = proto;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getProto() {
        return this.proto;
    }

    public boolean hasSubType() {
        return this.subType != null && !this.subType.isEmpty();
    }

    public boolean hasProtocol() {
        return this.proto != null && !this.proto.isEmpty();
    }

    public String prefixString() {
        if (this.type.isEmpty()) {
            throw new IllegalStateException("Type is empty: unable to build a prefix string");
        }
        if (this.proto.isEmpty()) {
            throw new IllegalStateException("Protocol is empty: unable to build a prefix string");
        }
        StringBuilder prefix = new StringBuilder();
        prefix.append("_");
        if (this.subType != null && !this.subType.isEmpty()) {
            prefix.append(this.subType);
            prefix.append(".");
            prefix.append("_sub");
            prefix.append(".");
            prefix.append("_");
        }
        prefix.append(this.type);
        prefix.append(".");
        prefix.append("_");
        prefix.append(this.proto.contains("_") ? this.proto.subSequence(1, this.proto.length()) : this.proto);
        prefix.append(".");
        return prefix.toString().toLowerCase();
    }

    public String prefixString(String protocol) {
        if (protocol == null || protocol.isEmpty()) {
            throw new IllegalArgumentException("Protocol is NULL or EMPTY: unable to build a prefix string");
        }
        if (this.type.isEmpty()) {
            throw new IllegalStateException("Type is empty: unable to build a prefix string");
        }
        StringBuilder prefix = new StringBuilder();
        prefix.append("_");
        if (this.subType != null && !this.subType.isEmpty()) {
            prefix.append(this.subType);
            prefix.append(".");
            prefix.append("_sub");
            prefix.append(".");
            prefix.append("_");
        }
        prefix.append(this.type);
        prefix.append(".");
        prefix.append("_");
        prefix.append(protocol.contains("_") ? protocol.subSequence(1, protocol.length()) : protocol);
        prefix.append(".");
        return prefix.toString().toLowerCase();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.type);
        hash = 89 * hash + Objects.hashCode(this.subType);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundLabel other = (CompoundLabel)obj;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        return Objects.equals(this.subType, other.subType);
    }

    public String toString() {
        return "ServiceType {type=" + this.type + ", subType=" + this.subType + '}';
    }
}

