/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.cli.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.iot.tiaki.cli.common.ExitCodes;
import org.eclipse.iot.tiaki.commons.StatusCode;

public final class ExitCodeMapper {
    private static Map<StatusCode, ExitCodes> exitCodeMap = null;

    public static ExitCodes map(StatusCode code) {
        if (code == null) {
            return ExitCodes.GENERIC_ERROR;
        }
        ExitCodes exitCode = exitCodeMap.get((Object)code);
        if (exitCode == null) {
            return ExitCodes.GENERIC_ERROR;
        }
        return exitCode;
    }

    private ExitCodeMapper() {
        throw new AssertionError((Object)String.format("Class %s not instantiable", this.getClass().getName()));
    }

    static {
        exitCodeMap = new HashMap<StatusCode, ExitCodes>();
        exitCodeMap.put(StatusCode.CONFIGURATION_ERROR, ExitCodes.LIB_CONFIGURATION_ERROR);
        exitCodeMap.put(StatusCode.NETWORK_ERROR, ExitCodes.NETWORK_ERROR);
        exitCodeMap.put(StatusCode.RESOURCE_LOOKUP_ERROR, ExitCodes.RESOURCE_LOOKUP_ERROR);
        exitCodeMap.put(StatusCode.RESOURCE_INSECURE_ERROR, ExitCodes.RESOURCE_INSECURE_ERROR);
        exitCodeMap.put(StatusCode.DNSSEC_STATUS_ERROR, ExitCodes.DNSSEC_STATUS_ERROR);
        exitCodeMap.put(StatusCode.RESOURCE_UNEXPECTED, ExitCodes.RESOURCE_UNEXPECTED);
        exitCodeMap.put(StatusCode.ILLEGAL_FQDN, ExitCodes.INVALID_FQDN);
        exitCodeMap.put(StatusCode.SERVER_ERROR, ExitCodes.DNS_SERVER_ERROR);
        exitCodeMap.put(StatusCode.RESOLUTION_NAME_ERROR, ExitCodes.RESOLUTION_NAME_ERROR);
        exitCodeMap.put(StatusCode.RESOLUTION_RR_TYPE_ERROR, ExitCodes.RESOLUTION_RR_TYPE_ERROR);
    }
}

