/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.cli.parser;

import java.util.Arrays;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.eclipse.iot.tiaki.cli.CommandOptionParser;
import org.eclipse.iot.tiaki.cli.exception.ParsingException;

public class DefaultOptionParser
implements CommandOptionParser {
    private static final String JOPTSIMPLE_UNRECOGNIZED_OPTION_EXCEPTION = "joptsimple.UnrecognizedOptionException";
    private static final String LONG_OPTION_ERROR = "unrecognized option '--%s'";
    private static final String SHORT_OPTION_ERROR = "invalid option -- '%s'";
    private OptionParser parser = new OptionParser();

    public DefaultOptionParser() {
        this.initParserOptions();
    }

    @Override
    public OptionSet parse(String[] args) throws ParsingException {
        try {
            return this.parser.parse(args);
        }
        catch (OptionException e) {
            throw new ParsingException(this.extractUsefulMessage(e));
        }
        catch (Exception e) {
            throw new ParsingException(e);
        }
    }

    private String extractUsefulMessage(OptionException ex) {
        String className = ex.getClass().getName();
        if (className.equals(JOPTSIMPLE_UNRECOGNIZED_OPTION_EXCEPTION)) {
            String exceptionMessage = ex.getMessage();
            String option = exceptionMessage.substring(0, exceptionMessage.indexOf(" "));
            if (option.length() > 1) {
                return String.format(LONG_OPTION_ERROR, option);
            }
            return String.format(SHORT_OPTION_ERROR, option);
        }
        return ex.getMessage();
    }

    private void initParserOptions() {
        this.parser.acceptsAll(Arrays.asList("i", "list-instances"), "list service instances");
        this.parser.acceptsAll(Arrays.asList("l", "list-services"), "list services");
        this.parser.acceptsAll(Arrays.asList("t", "text-record"), "get text record").withRequiredArg();
        this.parser.acceptsAll(Arrays.asList("x", "tlsa"), "get tlsa records").withOptionalArg();
        this.parser.acceptsAll(Arrays.asList("dnssec-status", "c"), "Check DNSSEC status of resolver").withOptionalArg().ofType(String.class);
        this.parser.acceptsAll(Arrays.asList("d", "domain"), "domain name to query [required]").requiredIf("list-instances", "list-services", "text-record", "tlsa").withRequiredArg().ofType(String.class);
        this.parser.acceptsAll(Arrays.asList("n", "servers"), "DNS Server").withRequiredArg().ofType(String.class);
        this.parser.acceptsAll(Arrays.asList("s", "supplement"), "service").requiredIf("list-instances", new String[0]).withRequiredArg().ofType(String.class);
        this.parser.acceptsAll(Arrays.asList("e", "insecure"), "Do not perform DNSSEC validation of <domain>");
        this.parser.acceptsAll(Arrays.asList("v", "verbose"), "print verbose messages");
        this.parser.acceptsAll(Arrays.asList("h", "help"), "print the help message").forHelp();
        this.parser.acceptsAll(Arrays.asList("u", "trust-anchor"), "specify the file containing trust anchor keys").withRequiredArg();
    }
}

