/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.cli.command;

import java.util.Set;
import joptsimple.OptionSet;
import org.eclipse.iot.tiaki.cli.ConsoleWriter;
import org.eclipse.iot.tiaki.cli.command.DnsSdAbstractCommand;
import org.eclipse.iot.tiaki.cli.common.ExitCodes;
import org.eclipse.iot.tiaki.cli.exception.ExecutionException;
import org.eclipse.iot.tiaki.cli.exception.OptionsNotValidException;
import org.eclipse.iot.tiaki.cli.util.DisplayUtil;
import org.eclipse.iot.tiaki.cli.util.OptionUtil;
import org.eclipse.iot.tiaki.commons.StatusCode;
import org.eclipse.iot.tiaki.domain.Fqdn;
import org.eclipse.iot.tiaki.domain.TextRecord;
import org.eclipse.iot.tiaki.exceptions.DnsServiceException;
import org.eclipse.iot.tiaki.exceptions.LookupException;

public class ListTextRecordCommand
extends DnsSdAbstractCommand {
    private Fqdn domain;
    private String textRecord;

    @Override
    public void initialize(OptionSet optionSet) throws ExecutionException, OptionsNotValidException {
        super.initialize(optionSet);
        try {
            this.domain = new Fqdn(OptionUtil.getOptionValue(optionSet, "domain", true));
        }
        catch (IllegalArgumentException iae) {
            throw new ExecutionException(DisplayUtil.map(StatusCode.ILLEGAL_FQDN), ExitCodes.INVALID_FQDN.getExitCode());
        }
        this.textRecord = optionSet.valueOf("text-record").toString();
    }

    @Override
    public void doExecute(ConsoleWriter consoleWriter) throws DnsServiceException {
        Set<TextRecord> textRecords = null;
        try {
            textRecords = this.dnsSd.listTextRecords(this.domain, this.textRecord, !this.insecureMode);
        }
        catch (LookupException le) {
            throw new DnsServiceException(le.dnsError(), String.format(DisplayUtil.map(le.dnsError()), this.domain.fqdn()), true);
        }
        for (TextRecord textRecord : textRecords) {
            consoleWriter.log(textRecord.toString());
        }
    }
}

