/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.cli.command;

import joptsimple.OptionSet;
import org.eclipse.iot.tiaki.cli.ConsoleWriter;
import org.eclipse.iot.tiaki.cli.command.DnsSdAbstractCommand;
import org.eclipse.iot.tiaki.cli.common.ExitCodes;
import org.eclipse.iot.tiaki.cli.exception.ExecutionException;
import org.eclipse.iot.tiaki.cli.exception.OptionsNotValidException;
import org.eclipse.iot.tiaki.cli.util.DisplayUtil;
import org.eclipse.iot.tiaki.commons.StatusCode;
import org.eclipse.iot.tiaki.domain.Fqdn;
import org.eclipse.iot.tiaki.exceptions.DnsServiceException;
import org.eclipse.iot.tiaki.exceptions.LookupException;

public class CheckDnsSecCommand
extends DnsSdAbstractCommand {
    private Fqdn domain;

    @Override
    public void initialize(OptionSet optionSet) throws ExecutionException, OptionsNotValidException {
        super.initialize(optionSet);
        String domainStr = null;
        if (optionSet.hasArgument("dnssec-status")) {
            domainStr = optionSet.valueOf("dnssec-status").toString();
        }
        if (domainStr == null) {
            domainStr = "verisigninc.com";
        }
        try {
            this.domain = new Fqdn(domainStr);
        }
        catch (IllegalArgumentException iae) {
            throw new ExecutionException(DisplayUtil.map(StatusCode.ILLEGAL_FQDN), ExitCodes.INVALID_FQDN.getExitCode());
        }
    }

    @Override
    public void doExecute(ConsoleWriter consoleWriter) throws DnsServiceException {
        try {
            this.dnsSd.isDnsSecValid(this.domain);
            consoleWriter.log(String.format("DNSSEC Status Check for domain successful", this.domain.domain()));
        }
        catch (LookupException e) {
            throw new DnsServiceException(e.dnsError(), String.format(DisplayUtil.map(e.dnsError()), this.domain.fqdn()), true);
        }
    }
}

