/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml.dtd;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.XMLWriter;
import de.pdark.decentxml.dtd.DocTypeElement;
import de.pdark.decentxml.dtd.DocTypeNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DocTypeAttributeList
extends BasicNode
implements DocTypeNode {
    private DocTypeElement element;
    private String elementName;
    private List<Node> nodes = new ArrayList<Node>();

    public DocTypeAttributeList(Token token, String elementName) {
        super(token);
        this.elementName = elementName;
    }

    public DocTypeAttributeList(XMLTokenizer.Type type, String elementName) {
        super(type, null);
        this.elementName = elementName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElement(DocTypeElement element) {
        this.element = element;
    }

    public DocTypeElement getElement() {
        return this.element;
    }

    public String getValue() {
        return this.toXML();
    }

    public DocTypeAttributeList toXML(XMLWriter writer) throws IOException {
        Node n;
        writer.write(this, "<!ATTLIST");
        if (!Character.isWhitespace(this.elementName.charAt(0))) {
            writer.write(this, " ");
        }
        writer.write(this, this.elementName);
        boolean needsWhitespace = true;
        if (Character.isWhitespace(this.elementName.charAt(this.elementName.length() - 1))) {
            needsWhitespace = false;
        }
        if (needsWhitespace && !this.nodes.isEmpty() && (n = this.nodes.get(0)).getType() == XMLTokenizer.Type.DTD_WHITESPACE) {
            needsWhitespace = false;
        }
        if (needsWhitespace) {
            writer.write(this, " ");
        }
        for (Node n2 : this.nodes) {
            n2.toXML(writer);
        }
        writer.write(this, ">");
        return this;
    }

    public DocTypeAttributeList addNode(Node node) {
        this.nodes.add(node);
        return this;
    }
}

