/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.command;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import org.eclipse.actf.util.command.IArgumentResolver;

public class DefaultArgumentResolver
implements IArgumentResolver {
    public Object resolve(String string, Class clazz) throws Exception {
        Constable constable = null;
        if (string != null) {
            if (clazz.isArray()) {
                constable = this.resolveArray(string, clazz.getComponentType());
            } else if (clazz.equals(String.class)) {
                constable = string;
            } else if (clazz.equals(Class.class)) {
                try {
                    constable = Class.forName(string);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Illegal class name for switch:" + string + " - " + exception);
                }
            } else if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
                constable = Short.valueOf(string);
            } else if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
                constable = Integer.valueOf(string);
            } else if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
                constable = Long.valueOf(string);
            } else if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
                constable = Float.valueOf(string);
            } else if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
                constable = Double.valueOf(string);
            } else if (clazz.equals(Character.TYPE) || clazz.equals(Character.class)) {
                constable = new Character(string.charAt(0));
            }
        }
        return constable;
    }

    protected Object resolveArray(String string, Class clazz) throws Exception {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Default impl of argument resolver does not support multi-dimensional arrays");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Object object = Array.newInstance(clazz, stringTokenizer.countTokens());
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Array.set(object, n++, this.resolve(stringTokenizer.nextToken(), clazz));
        }
        return object;
    }
}

