/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.blind.html.IBlindProblem;
import org.eclipse.actf.visualization.engines.blind.html.util.Id2LineViaActfId;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetSourceInfo;
import org.eclipse.actf.visualization.eval.problem.ProblemItemImpl;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlindProblem
extends ProblemItemImpl
implements IBlindProblem {
    private static final String ID = "id";
    private List<Node> nodeList = null;
    private int nodeId = -1;
    private boolean isMulti = false;
    private ArrayList<HighlightTargetId> idsList = new ArrayList();

    public BlindProblem(int n) {
        this(n, "");
    }

    public BlindProblem(int n, String string) {
        super("B_" + Integer.toString(n));
        this.subType = n;
        this.nodeList = new Vector<Node>();
        this.setTargetString(string);
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: {
                this.targetStringForHPB = string;
            }
        }
    }

    public Node getTargetNodeInResultDoc() {
        if (this.nodeList.size() > 0) {
            return this.nodeList.get(0);
        }
        return null;
    }

    public void setNode(Node node) {
        this.nodeList.add(0, node);
    }

    public void addNode(Node node) {
        this.nodeList.add(node);
    }

    public void setNode(Node node, int n) {
        this.nodeList.add(0, node);
        this.nodeId = n;
    }

    public String toString() {
        return "node=" + this.nodeId + ":" + this.getDescription();
    }

    public List<Node> getNodeList() {
        return this.nodeList;
    }

    public boolean setNodeId(int n) {
        if (this.nodeId == -1) {
            this.nodeId = n;
            return true;
        }
        return false;
    }

    public void addNodeIds(HighlightTargetId highlightTargetId) {
        this.isMulti = true;
        this.idsList.add(highlightTargetId);
    }

    public void prepareHighlight() {
        if (this.isMulti) {
            HighlightTargetId[] highlightTargetIdArray = new HighlightTargetId[this.idsList.size()];
            this.idsList.toArray(highlightTargetIdArray);
            this.setHighlightTargetIds(highlightTargetIdArray);
        } else if (this.nodeId > -1) {
            this.setHighlightTargetIds(new HighlightTargetId(this.nodeId, this.nodeId));
        }
    }

    private int getElementId(Element element) {
        int n = -1;
        String string = element.getAttribute(ID);
        if (string.length() > 0 && string.startsWith(ID)) {
            string = string.substring(string.indexOf(ID) + 2);
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public void setLineNumber(Id2LineViaActfId id2LineViaActfId) {
        switch (this.subType) {
            case 15: {
                try {
                    Html2ViewMapData html2ViewMapData;
                    int n;
                    Node node = this.getTargetNodeInResultDoc().getParentNode().getParentNode();
                    if (node == null || node.getNodeType() != 1 || (n = this.getElementId((Element)node)) <= -1 || (html2ViewMapData = id2LineViaActfId.getViewMapData(n)) == null) break;
                    this.setHighlightTargetSourceInfo(new HighlightTargetSourceInfo(html2ViewMapData, html2ViewMapData));
                }
                catch (Exception exception) {}
                break;
            }
            case 2: 
            case 6: 
            case 31: {
                int n;
                Node node = this.getTargetNodeInResultDoc();
                if (node.getNodeType() != 1 || (n = this.getElementId((Element)node)) <= -1) break;
                Html2ViewMapData html2ViewMapData = id2LineViaActfId.getViewMapData(n);
                this.setHighlightTargetSourceInfo(new HighlightTargetSourceInfo(html2ViewMapData, html2ViewMapData));
                break;
            }
            default: {
                if (this.isMulti) {
                    ArrayList<HighlightTargetSourceInfo> arrayList = new ArrayList<HighlightTargetSourceInfo>();
                    HighlightTargetId[] highlightTargetIdArray = new HighlightTargetId[this.idsList.size()];
                    this.idsList.toArray(highlightTargetIdArray);
                    int n = 0;
                    while (n < highlightTargetIdArray.length) {
                        Html2ViewMapData html2ViewMapData = id2LineViaActfId.getViewMapData(highlightTargetIdArray[n].getStartId());
                        Html2ViewMapData html2ViewMapData2 = id2LineViaActfId.getViewMapData(highlightTargetIdArray[n].getEndId());
                        if (html2ViewMapData == null) {
                            html2ViewMapData = html2ViewMapData2;
                        }
                        if (html2ViewMapData2 == null) {
                            html2ViewMapData2 = html2ViewMapData;
                        }
                        if (html2ViewMapData != null) {
                            arrayList.add(new HighlightTargetSourceInfo(html2ViewMapData, html2ViewMapData2));
                        }
                        ++n;
                    }
                    HighlightTargetSourceInfo[] highlightTargetSourceInfoArray = new HighlightTargetSourceInfo[arrayList.size()];
                    arrayList.toArray(highlightTargetSourceInfoArray);
                    this.setHighlightTargetSourceInfo(highlightTargetSourceInfoArray);
                    break;
                }
                Html2ViewMapData html2ViewMapData = id2LineViaActfId.getViewMapData(this.nodeId);
                if (html2ViewMapData == null) break;
                this.setHighlightTargetSourceInfo(new HighlightTargetSourceInfo(html2ViewMapData, html2ViewMapData));
            }
        }
    }
}

