/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import com.ibm.icu.text.MessageFormat;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.model.flash.bridge.IWaXcoding;
import org.eclipse.actf.model.flash.bridge.WaXcodingFactory;
import org.eclipse.actf.model.flash.proxy.internal.INTERNET_PER_CONN_OPTION_LIST;
import org.eclipse.actf.model.flash.proxy.internal.WSTR;
import org.eclipse.actf.model.flash.proxy.internal.WinInet;
import org.eclipse.actf.model.internal.flash.proxy.ProxyPlugin;
import org.eclipse.actf.model.internal.flash.proxy.logs.ProxyLogHandler;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class ProxyManager {
    public static boolean initLogger = false;
    public static boolean forceProxy = false;
    private static String noProxy = "";
    private INTERNET_PER_CONN_OPTION_LIST savedList = new INTERNET_PER_CONN_OPTION_LIST(4);
    private int savedAddress;
    private int hSession;
    private boolean needRestore = false;
    private int currentPort = 0;
    private static String PROTCOL_HTTP;
    private static String PROTCOL_HTTPS;
    private static String PROTCOL_FTP;
    private static String PROTCOL_GOPHER;

    static {
        String[] stringArray = Platform.getApplicationArgs();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            if ("-initLogger".equals(stringArray[n])) {
                initLogger = true;
            } else if ("-forceProxy".equals(stringArray[n])) {
                forceProxy = true;
            } else if ("-noProxy".equals(stringArray[n]) && n < stringArray.length - 1 && (string = stringArray[n + 1]).startsWith("|") && string.endsWith("|")) {
                noProxy = string;
            }
            ++n;
        }
        if (Platform.inDebugMode()) {
            System.out.println("initLogger = " + initLogger);
            System.out.println("forceProxy = " + forceProxy);
            System.out.println("noProxy = " + noProxy);
        }
        PROTCOL_HTTP = "http";
        PROTCOL_HTTPS = "https";
        PROTCOL_FTP = "ftp";
        PROTCOL_GOPHER = "gopher";
    }

    public ProxyManager() {
        this.savedList.perConnOptions[0].dwOption = 1;
        this.savedList.perConnOptions[1].dwOption = 2;
        this.savedList.perConnOptions[2].dwOption = 3;
        this.savedList.perConnOptions[3].dwOption = 4;
        this.savedAddress = MemoryUtil.GlobalAlloc((int)20);
        this.savedList.getData(this.savedAddress);
        int[] nArray = new int[]{20};
        WinInet.InternetQueryOptionW(0, 75, this.savedAddress, nArray);
        this.savedList.setData(this.savedAddress);
        WSTR wSTR = new WSTR("Agent");
        this.hSession = WinInet.InternetOpenW(wSTR.getAddress(), 1, 0, 0, 0);
        wSTR.dispose();
    }

    public void startProxy(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4;
        IWaXcoding iWaXcoding = this.getIWaXcoding();
        iWaXcoding.setPort(n);
        iWaXcoding.setSWFTranscodingMinimumVersion(n2);
        iWaXcoding.setTimeout(n3);
        iWaXcoding.setExternalProxyFlag(false);
        iWaXcoding.setSWFBootloaderFlag(bl);
        iWaXcoding.setSWFTranscodingFlag(bl2);
        String string = this.getDefaultProxy(PROTCOL_HTTP);
        if (string != null && -1 != (n4 = string.indexOf(58))) {
            try {
                String string2 = string.substring(0, n4);
                String string3 = string.substring(n4 + 1);
                int n5 = Integer.parseInt(string3);
                iWaXcoding.setExternalProxyFlag(true);
                iWaXcoding.setExternalProxy(string2, n5);
                if (Platform.inDebugMode()) {
                    System.out.println("Using external proxy " + string2 + ":" + n5);
                }
            }
            catch (Exception exception) {}
        }
        ProxyLogHandler.configure();
        iWaXcoding.start(initLogger);
        if (!initLogger) {
            ProxyLogHandler.resetLogLevel();
        }
        this.currentPort = iWaXcoding.getPort();
    }

    public void stopProxy() {
        if (this.currentPort != 0) {
            this.getIWaXcoding().stop();
            this.currentPort = 0;
        }
    }

    public void setInternetOptions(boolean bl) {
        if (this.savedAddress != 0) {
            if (this.currentPort == 0) {
                this.invokeSetOption(this.hSession, this.savedAddress);
                this.invokeSetOption(0, this.savedAddress);
                this.needRestore = false;
            } else {
                INTERNET_PER_CONN_OPTION_LIST iNTERNET_PER_CONN_OPTION_LIST = new INTERNET_PER_CONN_OPTION_LIST(2);
                iNTERNET_PER_CONN_OPTION_LIST.perConnOptions[0].dwOption = 1;
                iNTERNET_PER_CONN_OPTION_LIST.perConnOptions[0].dwValue = 5;
                iNTERNET_PER_CONN_OPTION_LIST.perConnOptions[1].dwOption = 4;
                iNTERNET_PER_CONN_OPTION_LIST.perConnOptions[1].strValue.setString(this.getAutoConfigURL(bl || forceProxy));
                int n = MemoryUtil.GlobalAlloc((int)20);
                iNTERNET_PER_CONN_OPTION_LIST.getData(n);
                this.invokeSetOption(this.hSession, n);
                this.invokeSetOption(0, bl ? n : this.savedAddress);
                this.needRestore = bl;
                MemoryUtil.GlobalFree((int)n);
                iNTERNET_PER_CONN_OPTION_LIST.dispose();
            }
        }
    }

    public void dispose() {
        ProxyLogHandler.removeHandler();
        this.stopProxy();
        if (this.hSession != 0) {
            WinInet.InternetCloseHandle(this.hSession);
        }
        if (this.savedAddress != 0) {
            if (this.needRestore) {
                WinInet.InternetSetOptionW(0, 75, this.savedAddress, 20);
            }
            MemoryUtil.GlobalFree((int)this.savedAddress);
            this.savedList.dispose();
        }
    }

    private void invokeSetOption(int n, int n2) {
        WinInet.InternetSetOptionW(n, 75, n2, 20);
        WinInet.InternetSetOptionW(n, 39, 0, 0);
        WinInet.InternetSetOptionW(n, 37, 0, 0);
    }

    private String getDefaultProxy(String string) {
        String string2;
        if ((this.savedList.perConnOptions[0].dwValue & 2) != 0 && (string2 = this.savedList.perConnOptions[1].strValue.getString()) != null) {
            String string3;
            if (-1 == string2.indexOf(61)) {
                return string2;
            }
            Matcher matcher = Pattern.compile(String.valueOf(string) + "=(.+)").matcher(string2);
            if (matcher.find() && (string3 = matcher.group(1)) != null) {
                int n = string3.indexOf(59);
                return -1 == n ? string3 : string3.substring(0, n);
            }
        }
        return null;
    }

    private IWaXcoding getIWaXcoding() {
        return WaXcodingFactory.getWaXcoding();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getAutoConfigURL(boolean bl) {
        String string = ProxyManager.readPluginFile("templates/proxy.pac");
        if (string == null) return null;
        String string2 = ProxyManager.getProxyString("localhost:" + this.currentPort);
        string = string.replaceAll("\\$NOPROXY_EXTS\\$", bl ? "" : noProxy).replaceAll("\\$HTTP_PROXY\\$", string2).replaceAll("\\$HTTP_DIRECT\\$", ProxyManager.getProxyString(this.getDefaultProxy(PROTCOL_HTTP))).replaceAll("\\$HTTPS_DIRECT\\$", ProxyManager.getProxyString(this.getDefaultProxy(PROTCOL_HTTPS))).replaceAll("\\$FTP_DIRECT\\$", ProxyManager.getProxyString(this.getDefaultProxy(PROTCOL_FTP))).replaceAll("\\$GOPHER_DIRECT\\$", ProxyManager.getProxyString(this.getDefaultProxy(PROTCOL_GOPHER)));
        OutputStream outputStream = null;
        IPath iPath = ProxyPlugin.getDefault().getStateLocation().append("proxy.pac");
        outputStream = new FileOutputStream(iPath.toFile());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "utf-8");
        outputStreamWriter.write(string);
        outputStreamWriter.close();
        String string3 = "file://" + iPath.toString();
        if (outputStream == null) return string3;
        try {
            outputStream.close();
            return string3;
        }
        catch (IOException iOException) {}
        return string3;
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                if (outputStream == null) return null;
            }
            catch (Throwable throwable) {
                if (outputStream == null) throw throwable;
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                outputStream.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    private static String getProxyString(String string) {
        return string != null ? MessageFormat.format((String)"PROXY {0}; DIRECT", (Object[])new Object[]{string}) : "DIRECT";
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readPluginFile(String string) {
        int n;
        InputStream inputStream = null;
        URL uRL = FileLocator.resolve((URL)ProxyPlugin.getDefault().getBundle().getEntry(string));
        inputStream = uRL.openStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[4096];
        while (-1 != (n = inputStreamReader.read(cArray))) {
            stringBuffer.append(cArray, 0, n);
        }
        String string2 = stringBuffer.toString();
        if (inputStream == null) return string2;
        try {
            inputStream.close();
            return string2;
        }
        catch (IOException iOException) {}
        return string2;
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                if (inputStream == null) return null;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }
}

