/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.flash;

import org.eclipse.actf.model.flash.IASBridge;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.model.internal.flash.ASBridgeImplV8;
import org.eclipse.actf.model.internal.flash.ASBridgeImplV9;
import org.eclipse.actf.model.internal.flash.FlashStatusUtil;
import org.eclipse.actf.util.win32.FlashMSAAObject;
import org.eclipse.actf.util.win32.FlashMSAAObjectFactory;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IUnknown;

public class FlashPlayer
implements IFlashPlayer {
    private IDispatch idispFlash;
    private FlashMSAAObject accessible;
    private int swfVersion = -1;
    private IASBridge asBrigde = null;
    private final boolean _isVisible;
    private boolean _isReady = false;

    FlashPlayer(IDispatch iDispatch) {
        this.idispFlash = iDispatch;
        try {
            this.accessible = FlashMSAAObjectFactory.getFlashMSAAObjectFromElement((IUnknown)this.idispFlash);
        }
        catch (Exception exception) {
            this._isReady = true;
        }
        String string = this.getWMode();
        this._isVisible = string == null || !"Opaque".equalsIgnoreCase(string) && !"Transparent".equalsIgnoreCase(string);
    }

    private boolean initAsBridge() {
        if (this.asBrigde != null) {
            return true;
        }
        switch (this.getSWFVersion()) {
            case 8: {
                this.asBrigde = new ASBridgeImplV8(this);
                return true;
            }
            case 9: {
                this.asBrigde = new ASBridgeImplV9(this);
                return true;
            }
        }
        this.asBrigde = new ASBridgeImplV8(this);
        if (this.asBrigde.getRootNode() != null) {
            return true;
        }
        this.asBrigde = new ASBridgeImplV9(this);
        if (this.asBrigde.getRootNode() != null) {
            return true;
        }
        this.asBrigde = null;
        return false;
    }

    public FlashMSAAObject getAccessible() {
        return this.accessible;
    }

    public boolean isReady() {
        if (this._isReady) {
            return true;
        }
        try {
            Object object = this.idispFlash.get("readyState");
            if (COMPLETED_READY_STATE.equals(object)) {
                this._isReady = true;
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public IASNode getRootNode() {
        if (this.initAsBridge()) {
            return this.asBrigde.getRootNode();
        }
        return null;
    }

    public IASNode getNodeFromPath(String string) {
        if (this.initAsBridge()) {
            return this.asBrigde.getNodeFromPath(string);
        }
        return null;
    }

    public IASNode getNodeAtDepthWithPath(String string, int n) {
        if (this.initAsBridge()) {
            return this.asBrigde.getNodeAtDepthWithPath(string, n);
        }
        return null;
    }

    public IASNode[] translateWithPath(String string) {
        if (this.initAsBridge()) {
            return this.asBrigde.translateWithPath(string);
        }
        return new IASNode[0];
    }

    public boolean hasChild(IASNode iASNode, boolean bl, boolean bl2) {
        if (this.initAsBridge()) {
            return this.asBrigde.hasChild(iASNode, bl, bl2);
        }
        return false;
    }

    public IASNode[] getChildren(IASNode iASNode, boolean bl, boolean bl2) {
        if (this.initAsBridge()) {
            return this.asBrigde.getChildren(iASNode, bl, bl2);
        }
        return new IASNode[0];
    }

    public IASNode[] searchVideo() {
        if (this.initAsBridge()) {
            return this.asBrigde.searchVideo();
        }
        return new IASNode[0];
    }

    public IASNode[] searchSound() {
        if (this.initAsBridge()) {
            return this.asBrigde.searchSound();
        }
        return new IASNode[0];
    }

    public boolean setMarker(Number number, Number number2, Number number3, Number number4) {
        if (this.initAsBridge()) {
            return this.asBrigde.setMarker(number, number2, number3, number4);
        }
        return false;
    }

    public boolean setMarker(IASNode iASNode) {
        if (this.initAsBridge()) {
            return this.asBrigde.setMarker(iASNode);
        }
        return false;
    }

    public boolean unsetMarker() {
        if (this.initAsBridge()) {
            return this.asBrigde.unsetMarker();
        }
        return false;
    }

    public boolean clearAllMarkers() {
        if (this.initAsBridge()) {
            return this.asBrigde.clearAllMarkers();
        }
        return false;
    }

    public boolean setFocus(String string) {
        if (this.initAsBridge()) {
            return this.asBrigde.setFocus(string);
        }
        return false;
    }

    public Object getProperty(String string, String string2) {
        if (this.initAsBridge()) {
            return this.asBrigde.getProperty(string, string2);
        }
        return null;
    }

    public void setProperty(String string, String string2, Object object) {
        if (this.initAsBridge()) {
            this.asBrigde.setProperty(string, string2, object);
        }
    }

    public boolean updateTarget() {
        if (this.initAsBridge()) {
            return this.asBrigde.updateTarget();
        }
        return false;
    }

    public void repairFlash() {
        if (this.initAsBridge()) {
            this.asBrigde.repairFlash();
        }
    }

    public Object callMethod(IASNode iASNode, String string) {
        if (this.initAsBridge()) {
            return this.asBrigde.callMethod(iASNode, string);
        }
        return null;
    }

    public Object callMethod(IASNode iASNode, String string, Object[] objectArray) {
        if (this.initAsBridge()) {
            return this.asBrigde.callMethod(iASNode, string, objectArray);
        }
        return null;
    }

    public String getStatus() {
        return FlashStatusUtil.getStatus(this);
    }

    public String getWMode() {
        try {
            Object object = this.idispFlash.get("WMode");
            return (String)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    String getVariable(String string) {
        try {
            Object object = this.idispFlash.invoke1("GetVariable", (Object)string);
            return (String)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setPlayerProperty(String string, String string2) {
        try {
            this.idispFlash.invoke("SetAttribute", new Object[]{string, string2});
        }
        catch (Exception exception) {
            return;
        }
    }

    public String getPlayerProperty(String string) {
        try {
            Object object = this.idispFlash.get(string);
            return (String)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getWindow() {
        FlashMSAAObject flashMSAAObject = FlashMSAAObjectFactory.getFlashMSAAObjectFromElement((IUnknown)this.idispFlash);
        return flashMSAAObject.getWindow();
    }

    public IDispatch getDispatch() {
        return this.idispFlash;
    }

    public String getPlayerVersion() {
        IASNode iASNode;
        String string = this.getVariable("$version");
        if (string == null && (iASNode = this.getNodeFromPath("$version")) != null) {
            string = iASNode.getValue();
        }
        return string;
    }

    public String getContentURL() {
        String string = this.getVariable("_url");
        if (string != null) {
            return string;
        }
        return "";
    }

    public int getSWFVersion() {
        if (this.swfVersion == -1) {
            try {
                Object object = this.idispFlash.invoke0("getSwfVersion");
                if (object instanceof Number) {
                    this.swfVersion = ((Number)object).intValue();
                }
            }
            catch (Exception exception) {}
        }
        return this.swfVersion;
    }
}

