/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.problem;

import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.internal.engines.lowvision.Messages;
import org.eclipse.actf.visualization.internal.engines.lowvision.PageElement;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionRecommendation;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.UseAllowedColorRecommendation;

public class ProhibitedForegroundColorProblem
extends LowVisionProblem {
    private int foregroundColor = -1;
    private int backgroundColor = -1;

    public ProhibitedForegroundColorProblem(PageComponent pageComponent, LowVisionType lowVisionType, double d) throws LowVisionProblemException {
        super(8, lowVisionType, Messages.ProhibitedForegroundColorProblem_The_foreground_color_is_not_allowed_by_the_design_guideline__1, pageComponent, d);
        this.setRecommendations();
    }

    public ProhibitedForegroundColorProblem(PageElement pageElement, LowVisionType lowVisionType, double d) throws LowVisionProblemException {
        super(8, lowVisionType, Messages.ProhibitedForegroundColorProblem_The_foreground_color_is_not_allowed_by_the_design_guideline__1, pageElement, d);
        this.foregroundColor = pageElement.getForegroundColor();
        this.backgroundColor = pageElement.getBackgroundColor();
        this.setRecommendations();
    }

    protected void setRecommendations() throws LowVisionProblemException {
        this.numRecommendations = 1;
        this.recommendations = new LowVisionRecommendation[this.numRecommendations];
        this.recommendations[0] = new UseAllowedColorRecommendation(this);
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }
}

