/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.ui.internal;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BlindVisualizationBrowser {
    private static final String WEBBROWSER_CONTROL_NAME = "Shell.Explorer";
    private static final String NAVIGATE_METHOD_NAME = "Navigate";
    private static final String URL_PARAM_NAME = "URL";
    private static final Variant[] ARG_CLEAR_HIGHLIGHT = new Variant[]{new Variant("clearHighlight();")};
    private OleAutomation oleAutomationIE;
    private OleAutomation ieWindowAutomation = null;
    private int id_exec_script;
    private int id_navigate;
    private int[] id_url_param;

    public BlindVisualizationBrowser(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        OleFrame oleFrame = new OleFrame(composite, 0);
        OleControlSite oleControlSite = new OleControlSite((Composite)oleFrame, 0, WEBBROWSER_CONTROL_NAME);
        this.oleAutomationIE = new OleAutomation((OleClientSite)oleControlSite);
        oleControlSite.doVerb(-5);
        int[] nArray = this.oleAutomationIE.getIDsOfNames(new String[]{NAVIGATE_METHOD_NAME, URL_PARAM_NAME});
        this.id_navigate = nArray[0];
        this.id_url_param = new int[1];
        this.id_url_param[0] = nArray[1];
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        oleFrame.setLayoutData((Object)gridData);
    }

    protected void setBrowserSilent() {
        int[] nArray = this.oleAutomationIE.getIDsOfNames(new String[]{"Silent"});
        int n = nArray[0];
        Variant variant = new Variant(1);
        this.oleAutomationIE.setProperty(n, variant);
    }

    protected void disposeOleBrowser() {
        if (this.oleAutomationIE != null) {
            this.oleAutomationIE.dispose();
        }
    }

    protected void navigate(String string) {
        Variant[] variantArray = new Variant[]{new Variant(string)};
        this.oleAutomationIE.invoke(this.id_navigate, variantArray, this.id_url_param);
    }

    private boolean initWindowAutomation() {
        if (this.ieWindowAutomation == null) {
            try {
                int[] nArray = this.oleAutomationIE.getIDsOfNames(new String[]{"Document"});
                int n = nArray[0];
                Variant variant = this.oleAutomationIE.getProperty(n);
                OleAutomation oleAutomation = variant.getAutomation();
                nArray = oleAutomation.getIDsOfNames(new String[]{"parentWindow"});
                n = nArray[0];
                variant = oleAutomation.getProperty(n);
                this.ieWindowAutomation = variant.getAutomation();
                nArray = this.ieWindowAutomation.getIDsOfNames(new String[]{"execScript"});
                this.id_exec_script = nArray[0];
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    protected void execScript(String string) {
        if (this.initWindowAutomation()) {
            Variant[] variantArray = new Variant[]{new Variant(string)};
            if (this.ieWindowAutomation.invoke(this.id_exec_script, variantArray) == null) {
                this.ieWindowAutomation = null;
                if (this.initWindowAutomation()) {
                    this.ieWindowAutomation.invoke(this.id_exec_script, variantArray);
                }
            }
        }
    }

    protected void clearHighlight() {
        if (this.initWindowAutomation()) {
            this.ieWindowAutomation.invoke(this.id_exec_script, ARG_CLEAR_HIGHLIGHT);
        }
    }
}

