/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks.jar;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.chain.plugin.TeaBuildPluginElement;
import org.eclipse.tea.library.build.config.BuildDirectories;
import org.eclipse.tea.library.build.jar.JarManager;
import org.eclipse.tea.library.build.jar.ZipConfig;
import org.eclipse.tea.library.build.model.BundleBuild;
import org.eclipse.tea.library.build.model.BundleData;
import org.eclipse.tea.library.build.model.PluginBuild;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.util.FileUtils;
import org.eclipse.tea.library.build.util.TeaBuildUtil;

public class TaskRunJarExport {
    private final String JobFamily = this.getClass().getName();
    private final boolean composite;
    private static TemporaryJarCache cache;
    private static final String PLUGINS_DIRECTORY = "plugins";

    public TaskRunJarExport() {
        this(false);
    }

    public TaskRunJarExport(boolean composite) {
        this.composite = composite;
    }

    public static void initCache(File dir) {
        cache = new TemporaryJarCache(dir);
    }

    public static void cleanCache(TaskingLog log) {
        if (cache != null) {
            cache.clear(log);
        }
        cache = null;
    }

    protected Collection<PluginBuild> getPlugins(WorkspaceBuild wb) {
        return wb.getSourcePlugIns();
    }

    /*
     * WARNING - void declaration
     */
    @Execute
    public void run(final TaskingLog log, WorkspaceBuild wb, final JarManager jarManager, BuildDirectories dirs, TaskProgressTracker tracker, ZipConfig config) throws Exception {
        void var10_11;
        final File distDirectory = new File(dirs.getOutputDirectory(), PLUGINS_DIRECTORY);
        if (!this.composite) {
            FileUtils.deleteDirectory(distDirectory);
        }
        FileUtils.mkdirs(distDirectory);
        log.info("jar destination directory: " + distDirectory);
        ArrayList<1> startedJobs = new ArrayList<1>();
        ArrayList<PluginBuild> plugins = new ArrayList<PluginBuild>(this.getPlugins(wb));
        log.info("Number of plugins: " + plugins.size());
        boolean bl = false;
        while (var10_11 < plugins.size()) {
            if (tracker.isCanceled()) break;
            if ((long)TaskRunJarExport.getNumberOfJobs(this.JobFamily) >= config.zipParallelThreads) {
                Thread.sleep(10L);
                continue;
            }
            final PluginBuild pb = (PluginBuild)plugins.get((int)var10_11);
            Job job = new Job("Export " + pb.getPluginName()){

                public boolean belongsTo(Object family) {
                    return family.equals(TaskRunJarExport.this.JobFamily);
                }

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        log.info("execJarCommands: " + pb.getPluginName());
                        MultiStatus status = TeaBuildUtil.getStatus(new TeaBuildPluginElement(pb));
                        if (status.getSeverity() > 2) {
                            IStatus[] iStatusArray = status.getChildren();
                            int n = iStatusArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IStatus s = iStatusArray[n2];
                                if (s.getSeverity() > 2) {
                                    log.debug(s.getMessage());
                                }
                                ++n2;
                            }
                            throw new RuntimeException(String.valueOf(pb.getPluginName()) + " has errors");
                        }
                        TaskRunJarExport.execJarCached(jarManager, distDirectory, pb);
                    }
                    catch (Exception e) {
                        log.info(String.valueOf(pb.getPluginName()) + " " + e.toString());
                        return new Status(4, ((Object)((Object)this)).getClass().getName(), "unexpected exception during jar export", (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            startedJobs.add(job);
            tracker.worked(1);
            ++var10_11;
        }
        Job.getJobManager().join((Object)this.JobFamily, null);
        if (tracker.isCanceled()) {
            throw new RuntimeException("cancelled");
        }
        for (Job job : startedJobs) {
            if (job.getResult().isOK()) continue;
            Throwable cause = job.getResult().getException();
            throw new RuntimeException("Job failed:" + job.getName(), cause);
        }
    }

    protected static void execJarCached(JarManager jarManager, File distDirectory, BundleBuild<?> bb) throws Exception {
        if (cache != null) {
            cache.execJarCommands(jarManager, bb, distDirectory);
        } else {
            jarManager.execJarCommands(bb, distDirectory);
        }
    }

    private static int getNumberOfJobs(String jobFamily) {
        IJobManager manager = Job.getJobManager();
        Job[] jobs = manager.find((Object)jobFamily);
        return jobs.length;
    }

    public String toString() {
        return "Export All Jars";
    }

    public static String getPluginJarDirectory() {
        return PLUGINS_DIRECTORY;
    }

    static class TemporaryJarCache {
        private final File dir;
        private long missCnt = 0L;
        private long hitCnt = 0L;
        private long skipCnt = 0L;

        TemporaryJarCache(File dir) {
            this.dir = dir;
            if (!dir.isDirectory()) {
                FileUtils.mkdirs(dir);
            }
        }

        private File getCached(JarManager jm, BundleBuild<?> build) throws Exception {
            String jarFileName = build.getJarFileName(jm.getBundleVersion((BundleData)build.getData()));
            File cached = new File(this.dir, jarFileName);
            if (cached.exists()) {
                ++this.hitCnt;
                return cached;
            }
            ++this.missCnt;
            return jm.execJarCommands(build, this.dir);
        }

        File execJarCommands(JarManager jm, BundleBuild<?> build, File destDir) throws Exception {
            File cached = this.getCached(jm, build);
            File destFile = new File(destDir, cached.getName());
            if (!destFile.exists() || cached.length() != destFile.length()) {
                FileUtils.hardLinkOrCopy(cached, destFile);
            } else {
                ++this.skipCnt;
            }
            return destFile;
        }

        void clear(TaskingLog log) {
            log.info("clearing JAR cache: miss=" + this.missCnt + ", hit=" + this.hitCnt + ", skip=" + this.skipCnt);
            FileUtils.deleteDirectory(this.dir);
        }
    }
}

