/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.jar;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.jar.BaseZipExec;
import org.eclipse.tea.library.build.jar.ZipExecPart;
import org.eclipse.tea.library.build.util.FileUtils;

public class InternalZipExec
extends BaseZipExec {
    private final byte[] BUFFER = new byte[10240];
    private final TaskingLog log;

    public InternalZipExec(TaskingLog log) {
        this.log = log;
    }

    @Override
    protected void doCreateZip() {
        try {
            FileOutputStream fos = new FileOutputStream(this.zipFile);
            try (ZipOutputStream zos = new ZipOutputStream(fos);){
                TreeMap<ZipEntry, File> entries = new TreeMap<ZipEntry, File>((a, b) -> a.getName().compareTo(b.getName()));
                for (ZipExecPart part : this.parts) {
                    this.addZip(part, entries);
                }
                this.write(zos, entries);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot create " + this.zipFile, e);
        }
    }

    private void addZip(ZipExecPart part, Map<ZipEntry, File> entries) {
        for (String relPath : part.relativePaths) {
            if (".".equals(relPath)) {
                this.addEntry(part, entries, part.sourceDirectory, null);
                continue;
            }
            File source = new File(part.sourceDirectory, relPath);
            this.addEntry(part, entries, source, relPath);
        }
    }

    private void addEntry(ZipExecPart part, Map<ZipEntry, File> entries, File source, String entryName) {
        if (!source.exists()) {
            this.log.warn("ZIP input " + source + " does not exist");
            return;
        }
        if (source.isDirectory()) {
            int lastIndex;
            if (entryName != null && entryName.charAt(lastIndex = entryName.length() - 1) == '/') {
                entryName = entryName.substring(0, lastIndex);
            }
            Object[] children = source.list();
            Arrays.sort(children);
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object childName = objectArray[n2];
                if (!part.excludeGit || !".gitignore".equals(childName)) {
                    File child = new File(source, (String)childName);
                    if (entryName == null) {
                        this.addEntry(part, entries, child, (String)childName);
                    } else {
                        this.addEntry(part, entries, child, String.valueOf(entryName) + '/' + (String)childName);
                    }
                }
                ++n2;
            }
            return;
        }
        ZipEntry ze = new ZipEntry(entryName);
        try {
            BasicFileAttributes attr = Files.readAttributes(source.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (!this.isJar) {
                ze.setLastModifiedTime(attr.lastModifiedTime());
                ze.setLastAccessTime(attr.lastAccessTime());
                ze.setCreationTime(attr.creationTime());
            } else {
                ze.setLastModifiedTime(FileTime.fromMillis(0L));
                ze.setLastAccessTime(FileTime.fromMillis(0L));
                ze.setCreationTime(FileTime.fromMillis(0L));
            }
        }
        catch (Exception e) {
            System.out.println("cannot apply source file timestamps");
        }
        entries.put(ze, source);
    }

    private void write(ZipOutputStream zos, Map<ZipEntry, File> entries) {
        entries.keySet().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).forEach(e -> {
            List segments = Splitter.on((char)'/').splitToList((CharSequence)e.getName());
            if (segments.size() > 1) {
                String rel = null;
                int i = 0;
                while (i < segments.size() - 1) {
                    String seg = (String)segments.get(i);
                    rel = rel == null ? String.valueOf(seg) + "/" : String.valueOf(rel) + seg + "/";
                    ZipEntry de = new ZipEntry(rel);
                    if (!this.isJar) {
                        de.setTime(System.currentTimeMillis());
                    } else {
                        de.setLastModifiedTime(FileTime.fromMillis(0L));
                        de.setLastAccessTime(FileTime.fromMillis(0L));
                        de.setCreationTime(FileTime.fromMillis(0L));
                    }
                    entries.put(de, null);
                    ++i;
                }
            }
        });
        for (Map.Entry<ZipEntry, File> ze : entries.entrySet()) {
            try {
                zos.putNextEntry(ze.getKey());
                if (!ze.getKey().isDirectory()) {
                    try (FileInputStream fis = new FileInputStream(ze.getValue());){
                        int count;
                        while ((count = fis.read(this.BUFFER)) >= 0) {
                            zos.write(this.BUFFER, 0, count);
                        }
                    }
                }
                zos.closeEntry();
            }
            catch (Exception e2) {
                throw new IllegalStateException("cannot add " + ze.getValue(), e2);
            }
        }
    }

    @Override
    public void unzip(File zipFile, File destDir) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile file = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File realFile = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    FileUtils.mkdirs(realFile);
                    continue;
                }
                FileUtils.mkdirs(realFile.getParentFile());
                Throwable throwable2 = null;
                Object var10_13 = null;
                try {
                    InputStream is = file.getInputStream(entry);
                    try {
                        try (FileOutputStream os = new FileOutputStream(realFile);){
                            int i;
                            while ((i = is.read(this.BUFFER)) != -1) {
                                os.write(this.BUFFER, 0, i);
                            }
                        }
                        if (is == null) continue;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        if (is != null) {
                            is.close();
                        }
                        throw throwable2;
                    }
                    is.close();
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }
}

