/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.Random;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.math.BinomialDistributionUtil;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.StochasticPoissonSIRDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.impl.SIRImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;

public class StochasticPoissonSIRDiseaseModelImpl
extends SIRImpl
implements StochasticPoissonSIRDiseaseModel {
    private Random rand = new Random();

    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SIRLabelValue currentSIR = (SIRLabelValue)currentState;
            double transmissionRate = this.getAdjustedTransmissionRate(timeDelta);
            if (!this.isFrequencyDependent()) {
                transmissionRate *= this.getTransmissionRateScaleFactor(diseaseLabel);
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSIR.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double numberOfInfectedToRecovered = this.getAdjustedRecoveryRate(timeDelta) * currentSIR.getI();
            double numberOfRecoveredToSusceptible = this.getAdjustedImmunityLossRate(timeDelta) * currentSIR.getR();
            int S = (int)currentSIR.getS();
            double prob = 0.0;
            prob = this.getNonLinearityCoefficient() != 1.0 && effectiveInfectious >= 0.0 ? transmissionRate * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient()) : transmissionRate * effectiveInfectious;
            double rndVar = this.rand.nextDouble();
            int pickN = 0;
            pickN = new BinomialDistributionUtil(1L).fastPickFromBinomialDist(prob, S);
            double numberOfSusceptibleToInfected = pickN;
            double deltaS = numberOfRecoveredToSusceptible - numberOfSusceptibleToInfected;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToRecovered;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            SIRLabelValueImpl ret = (SIRLabelValueImpl)deltaValue;
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setIncidence(numberOfInfectedToRecovered);
            ret.setR(deltaR);
            ret.setDiseaseDeaths(0.0);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.STOCHASTIC_POISSON_SIR_DISEASE_MODEL;
    }
}

