/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;

public class SEIRLabelValueImpl
extends SIRLabelValueImpl
implements SEIRLabelValue {
    protected static final double E_EDEFAULT = 0.0;
    protected double e = 0.0;

    public SEIRLabelValueImpl() {
    }

    public SEIRLabelValueImpl(double s, double e, double i, double incidence, double r, double diseaseDeaths) {
        super(s, i, incidence, r, diseaseDeaths);
        this.setE(e);
    }

    public SEIRLabelValueImpl(double s, double e, double i, double r, double diseaseDeaths) {
        super(s, i, 0.0, r, diseaseDeaths);
        this.setE(e);
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.SEIR_LABEL_VALUE;
    }

    @Override
    public double getE() {
        return this.e;
    }

    @Override
    public void setE(double newE) {
        this.e = newE;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getE();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setE((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setE(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.e != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (e: ");
        result.append(this.e);
        result.append(')');
        return result.toString();
    }

    @Override
    public IntegrationLabelValue set(IntegrationLabelValue value) {
        SEIRLabelValue v = (SEIRLabelValue)value;
        super.set(value);
        this.setE(v.getE());
        return this;
    }

    @Override
    public IntegrationLabelValue add(IntegrationLabelValue value) {
        SEIRLabelValue v = (SEIRLabelValue)value;
        super.add(value);
        this.setE(this.getE() + v.getE());
        return this;
    }

    @Override
    public IntegrationLabelValue sub(IntegrationLabelValue value) {
        SEIRLabelValue v = (SEIRLabelValue)value;
        super.sub(value);
        this.setE(this.getE() - v.getE());
        return this;
    }

    @Override
    public IntegrationLabelValue scale(double scaleFactor) {
        super.scale(scaleFactor);
        this.setE(scaleFactor * this.getE());
        return this;
    }

    @Override
    public IntegrationLabelValue add(double addition) {
        super.add(addition);
        this.setE(this.getE() + addition);
        return this;
    }

    @Override
    public IntegrationLabelValue abs() {
        super.abs();
        this.setE(Math.abs(this.getE()));
        return this;
    }

    @Override
    public boolean avoidNegative(IntegrationLabelValue value) {
        SEIRLabelValue v = (SEIRLabelValue)value;
        boolean adjusted = super.avoidNegative(value);
        if (this.getE() + v.getE() < 0.0) {
            this.setE(-v.getE());
        }
        return adjusted;
    }

    @Override
    public double computeDeltaAdjustment(IntegrationLabelValue value) {
        SEIRLabelValue v = (SEIRLabelValue)value;
        double factor = super.computeDeltaAdjustment(value);
        if (this.getE() + v.getE() < 0.0) {
            factor = Math.min(factor, -v.getE() / this.getE());
        }
        return factor;
    }

    @Override
    public IntegrationLabelValue divide(IntegrationLabelValue value) {
        SEIRLabelValue v = (SEIRLabelValue)value;
        super.divide(value);
        this.setE(this.getE() / v.getE());
        return this;
    }

    @Override
    public double max() {
        double max = super.max();
        max = Math.max(max, this.getE());
        return max;
    }

    @Override
    public IntegrationLabelValue copy() {
        SEIRLabelValue ilv = StandardFactory.eINSTANCE.createSEIRLabelValue();
        ilv.set(this);
        return ilv;
    }

    @Override
    public void eSetDouble(int featureId, double newValue) {
        switch (featureId) {
            case 8: {
                this.setE(newValue);
                return;
            }
        }
        super.eSetDouble(featureId, newValue);
    }

    @Override
    public double eGetDouble(int featureId) {
        switch (featureId) {
            case 8: {
                return this.getE();
            }
        }
        return super.eGetDouble(featureId);
    }

    @Override
    public void reset() {
        super.reset();
        this.setE(0.0);
    }

    @Override
    public boolean sameValue(LabelValue otherLabelValue) {
        SEIRLabelValue v = (SEIRLabelValue)otherLabelValue;
        if (!super.sameValue(otherLabelValue)) {
            return false;
        }
        return this.getE() == v.getE();
    }

    @Override
    public double getPopulationCount() {
        return super.getPopulationCount() + this.getE();
    }
}

