/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleTextChangeListener;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.FragmentHostHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageFriend;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.ui.refactoring.BundleManifestChange;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class CreateHeaderChangeOperation
implements IWorkspaceRunnable {
    private IPluginModelBase fBase;
    private String fHeaderKey;
    private String fOldValue;
    private String fNewValue;
    private TextFileChange fChange;

    public CreateHeaderChangeOperation(IPluginModelBase base, String headerKey, String oldValue, String newValue) {
        this.fBase = base;
        this.fHeaderKey = headerKey;
        this.fOldValue = oldValue;
        this.fNewValue = newValue;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        try {
            IResource res = this.fBase.getUnderlyingResource();
            if (res == null) {
                return;
            }
            IProject proj = res.getProject();
            IFile file = PDEProject.getManifest((IProject)proj);
            if (file.exists()) {
                this.fChange = this.updateBundleHeader(file, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    public TextFileChange getChange() {
        return this.fChange;
    }

    protected TextFileChange updateBundleHeader(IFile manifest, IProgressMonitor monitor) throws CoreException {
        block21: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            try {
                BundleTextChangeListener listener;
                Bundle bundle = BundleManifestChange.getBundle(manifest, (IProgressMonitor)subMonitor.split(1));
                if (bundle == null || (listener = this.createListener((IBundle)bundle)) == null) break block21;
                IManifestHeader mHeader = bundle.getManifestHeader(this.fHeaderKey);
                if (mHeader instanceof BundleSymbolicNameHeader) {
                    ((BundleSymbolicNameHeader)mHeader).setId(this.fNewValue);
                } else if (mHeader instanceof RequireBundleHeader) {
                    RequireBundleObject[] bundles;
                    RequireBundleHeader header = (RequireBundleHeader)mHeader;
                    RequireBundleObject[] requireBundleObjectArray = bundles = header.getRequiredBundles();
                    int n = bundles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RequireBundleObject requiredBundle = requireBundleObjectArray[n2];
                        if (requiredBundle.getId().equals(this.fOldValue)) {
                            requiredBundle.setId(this.fNewValue);
                        }
                        ++n2;
                    }
                } else if (mHeader instanceof FragmentHostHeader) {
                    ((FragmentHostHeader)mHeader).setHostId(this.fNewValue);
                } else if (mHeader instanceof ExportPackageHeader) {
                    ExportPackageObject[] packages;
                    ExportPackageObject[] exportPackageObjectArray = packages = ((ExportPackageHeader)mHeader).getPackages();
                    int n = packages.length;
                    int n3 = 0;
                    while (n3 < n) {
                        PackageFriend[] friends;
                        ExportPackageObject pkg = exportPackageObjectArray[n3];
                        PackageFriend[] packageFriendArray = friends = pkg.getFriends();
                        int n4 = friends.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            PackageFriend friend = packageFriendArray[n5];
                            if (friend.getName().equals(this.fOldValue)) {
                                pkg.removeFriend(friend);
                                pkg.addFriend(new PackageFriend((PackageObject)pkg, this.fNewValue));
                            }
                            ++n5;
                        }
                        ++n3;
                    }
                }
                TextFileChange textFileChange = this.getTextChange(listener, manifest);
                return textFileChange;
            }
            catch (MalformedTreeException malformedTreeException) {
            }
            catch (CoreException coreException) {
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                FileBuffers.getTextFileBufferManager().disconnect(manifest.getFullPath(), LocationKind.NORMALIZE, (IProgressMonitor)subMonitor.split(1));
            }
        }
        return null;
    }

    private BundleTextChangeListener createListener(IBundle bundle) {
        if (bundle != null) {
            BundleTextChangeListener listener = new BundleTextChangeListener(((BundleModel)bundle.getModel()).getDocument());
            bundle.getModel().addModelChangedListener((IModelChangedListener)listener);
            return listener;
        }
        return null;
    }

    private TextFileChange getTextChange(BundleTextChangeListener listener, IFile manifest) {
        TextEdit[] edits = listener.getTextOperations();
        if (edits.length == 0) {
            return null;
        }
        MultiTextEdit edit = new MultiTextEdit();
        edit.addChildren(edits);
        TextFileChange change = new TextFileChange("", manifest);
        change.setEdit((TextEdit)edit);
        PDEModelUtility.setChangeTextType(change, manifest);
        return change;
    }
}

