/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import java.util.TreeSet;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.ui.views.geographic.map.StemPolygon;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class StemPolygonsList
extends TreeSet<StemPolygon> {
    private static final long serialVersionUID = 1L;
    private transient Rectangle bounds = null;

    public StemPolygonsList() {
    }

    public StemPolygonsList(LatLong latLongData, Identifiable identifiable) {
        for (LatLong.Segment latLongSegment : latLongData.getSegments()) {
            this.add(new StemPolygon(latLongSegment, identifiable));
        }
    }

    private void updateBounds(StemPolygon polygon) {
        if (polygon.getIdentifiable() instanceof Edge) {
            return;
        }
        this.bounds = this.bounds != null ? this.bounds.union(polygon.getBounds()) : polygon.getBounds();
    }

    public final Rectangle getBounds() {
        for (StemPolygon polygon : this) {
            this.updateBounds(polygon);
        }
        return this.bounds;
    }

    public StemPolygon getContainingRegionPolygon(Point latLongPosition) {
        StemPolygon retValue = null;
        double minArea = Double.MAX_VALUE;
        for (StemPolygon polygon : this) {
            if (!polygon.containsPoint(latLongPosition) || !(polygon.getIdentifiable() instanceof Region) || !(polygon.area < minArea)) continue;
            retValue = polygon;
            minArea = polygon.area;
        }
        return retValue;
    }
}

