/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.explorer;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.experiment.Experiment;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.predicate.IdentifiablePredicateExpression;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.trigger.Trigger;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.Utility;
import org.eclipse.stem.ui.views.explorer.IdentifiableInstanceTreeNode;
import org.eclipse.stem.ui.views.explorer.IdentifiableTreeNode;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class IdentifiableContentProvider
implements ITreeContentProvider,
IResourceChangeListener,
IResourceDeltaVisitor,
BundleListener {
    public static Viewer viewer;

    public IdentifiableContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
        Activator.getDefault().getBundle().getBundleContext().addBundleListener((BundleListener)this);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] retValue = null;
        if (parentElement instanceof IdentifiableTreeNode) {
            ArrayList<Identifiable> temp = new ArrayList<Identifiable>();
            IdentifiableTreeNode itn = (IdentifiableTreeNode)parentElement;
            IFolder folder = itn.getProject().getFolder(itn.getFolderName());
            if (folder.exists()) {
                try {
                    IResource[] iResourceArray = folder.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile ifile;
                        IResource identifiableFile = iResourceArray[n2];
                        if (identifiableFile instanceof IFile && (ifile = (IFile)identifiableFile).getName().length() > 0 && ifile.getName().charAt(0) != '.' && !ifile.getName().endsWith("~")) {
                            try {
                                Identifiable identifiable = Utility.getIdentifiable((IFile)identifiableFile);
                                if (identifiable != null) {
                                    temp.add(identifiable);
                                }
                            }
                            catch (Throwable t) {
                                Activator.logInformation("Error loading file " + ifile.getName() + " for display", t);
                            }
                        }
                        ++n2;
                    }
                }
                catch (CoreException ce) {
                    Activator.logError("", ce);
                }
            }
            retValue = temp.toArray();
        } else {
            retValue = new Object[]{};
        }
        return retValue;
    }

    public Object getParent(Object element) {
        IdentifiableTreeNode retValue = null;
        if (element instanceof IdentifiableInstanceTreeNode) {
            retValue = ((IdentifiableInstanceTreeNode)element).getParent();
        }
        return retValue;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IdentifiableContentProvider.viewer = viewer;
        ((StructuredViewer)viewer).setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                return element.hashCode();
            }

            public boolean equals(Object a, Object b) {
                Object aRep = a;
                Object bRep = b;
                while (aRep instanceof DelegatingWrapperItemProvider) {
                    aRep = ((DelegatingWrapperItemProvider)aRep).getValue();
                }
                while (bRep instanceof DelegatingWrapperItemProvider) {
                    bRep = ((DelegatingWrapperItemProvider)bRep).getValue();
                }
                if (aRep instanceof Identifiable && bRep instanceof Identifiable) {
                    URI aURI = ((Identifiable)aRep).getURI();
                    URI bURI = ((Identifiable)bRep).getURI();
                    if (aURI != null && bURI != null) {
                        return aURI.toString().equals(bURI.toString());
                    }
                }
                return aRep.equals(bRep);
            }
        });
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2 || event.getType() == 4) {
            IProject p = (IProject)event.getResource();
            org.eclipse.stem.core.Utility.unloadResourcesInProject((IProject)p);
            return;
        }
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            Activator.logError("", e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        final IResource source = delta.getResource();
        IPath path = delta.getFullPath();
        URI uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)false);
        for (Resource r : org.eclipse.stem.core.Utility.resourceSet.getResources()) {
            if (!r.getURI().equals(uri)) continue;
            r.setModified(true);
            break;
        }
        switch (source.getType()) {
            case 2: {
                final IFolder f = (IFolder)source;
                new UIJob("Update Folder"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (viewer != null && !viewer.getControl().isDisposed()) {
                            IdentifiableContentProvider.this.refreshViewer((CommonViewer)viewer, f);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                break;
            }
            case 8: {
                new UIJob("Update Root"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (viewer != null && !viewer.getControl().isDisposed()) {
                            IdentifiableContentProvider.this.refreshViewer((CommonViewer)viewer, source);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                break;
            }
            case 4: {
                final IProject project = (IProject)source;
                new UIJob("Update Project"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (viewer != null && !viewer.getControl().isDisposed()) {
                            IdentifiableContentProvider.this.refreshViewer((CommonViewer)viewer, project);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                break;
            }
            case 1: {
                final IFile file = (IFile)source;
                this.markIndirectFiles(delta);
                new UIJob("Update File"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (viewer != null && !viewer.getControl().isDisposed()) {
                            IdentifiableContentProvider.this.refreshViewer((CommonViewer)viewer, file);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                return false;
            }
        }
        return true;
    }

    private void refreshViewer(CommonViewer v, Object elm) {
        TreePath[] expPaths = v.getExpandedTreePaths();
        v.refresh(elm);
        ArrayList<TreeItem> allItems = new ArrayList<TreeItem>();
        this.getAllItems(v.getControl(), allItems);
        ArrayList<TreePath> newPathsToExpand = new ArrayList<TreePath>();
        TreePath[] treePathArray = expPaths;
        int n = expPaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath tp = treePathArray[n2];
            Object lastSeg = tp.getLastSegment();
            while (lastSeg instanceof DelegatingWrapperItemProvider) {
                lastSeg = ((DelegatingWrapperItemProvider)lastSeg).getValue();
            }
            if (lastSeg instanceof Identifiable) {
                boolean foundNewPath = false;
                for (TreeItem ti : allItems) {
                    Object data = ti.getData();
                    while (data instanceof DelegatingWrapperItemProvider) {
                        data = ((DelegatingWrapperItemProvider)data).getValue();
                    }
                    if (!(data instanceof Identifiable) || !((Identifiable)data).getURI().equals(((Identifiable)lastSeg).getURI()) || data.equals(lastSeg)) continue;
                    Object[] segments = new Object[tp.getSegmentCount()];
                    int i = 0;
                    i = 0;
                    while (i < tp.getSegmentCount() - 1) {
                        segments[i] = tp.getSegment(i);
                        ++i;
                    }
                    segments[i] = ti.getData();
                    TreePath newPath = new TreePath(segments);
                    newPathsToExpand.add(newPath);
                    foundNewPath = true;
                }
                if (!foundNewPath) {
                    Object[] segments = new Object[tp.getSegmentCount()];
                    int i = 0;
                    i = 0;
                    while (i < tp.getSegmentCount()) {
                        segments[i] = tp.getSegment(i);
                        ++i;
                    }
                    TreePath newPath = new TreePath(segments);
                    newPathsToExpand.add(newPath);
                }
            }
            ++n2;
        }
        v.setExpandedTreePaths(expPaths);
        for (TreePath tp : newPathsToExpand) {
            v.expandToLevel((Object)tp, 1);
        }
    }

    private void getAllItems(Object o, ArrayList<TreeItem> items) {
        TreeItem t;
        int n;
        int n2;
        TreeItem[] treeItemArray;
        if (o instanceof Tree) {
            treeItemArray = ((Tree)o).getItems();
            n2 = treeItemArray.length;
            n = 0;
            while (n < n2) {
                t = treeItemArray[n];
                items.add(t);
                TreeItem[] treeItemArray2 = t.getItems();
                int n3 = treeItemArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem t2 = treeItemArray2[n4];
                    this.getAllItems(t2, items);
                    ++n4;
                }
                ++n;
            }
        }
        if (o instanceof TreeItem) {
            treeItemArray = ((TreeItem)o).getItems();
            n2 = treeItemArray.length;
            n = 0;
            while (n < n2) {
                t = treeItemArray[n];
                items.add(t);
                this.getAllItems(t, items);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markIndirectFiles(IResourceDelta delta) {
        URI uri = URI.createPlatformResourceURI((String)delta.getResource().getFullPath().toString(), (boolean)false);
        String project = this.getProject(uri);
        String type = this.getType(uri);
        MyRunnable runnable = new MyRunnable();
        Display.getDefault().syncExec((Runnable)runnable);
        IEditorReference[] editorReferences = runnable.getReferences();
        BasicEList resSnap = new BasicEList();
        ResourceSet resourceSet = org.eclipse.stem.core.Utility.resourceSet;
        synchronized (resourceSet) {
            for (Resource r : org.eclipse.stem.core.Utility.resourceSet.getResources()) {
                resSnap.add((Object)r);
            }
            for (Resource r : resSnap) {
                EObject first;
                URI u;
                EList content;
                String p_project = this.getProject(r.getURI());
                if (!project.equals(p_project) || (content = r.getContents()) == null || content.size() == 0 || (u = ((Identifiable)(first = (EObject)content.get(0))).getURI()) == null) continue;
                if (u.equals(uri)) {
                    r.setModified(true);
                    r.unload();
                    continue;
                }
                String proj = this.getProject(u);
                if (proj == null || !proj.equals(project)) continue;
                boolean modified = false;
                if (type.equals("models")) {
                    if (!(first instanceof Model) && !(first instanceof Scenario) && !(first instanceof Experiment)) continue;
                    if (first instanceof Model) {
                        modified = this.checkModel((Model)first, uri);
                    } else if (first instanceof Scenario) {
                        modified = this.checkScenario((Scenario)first, uri);
                    } else if (first instanceof Experiment) {
                        modified = this.checkExperiment((Experiment)first, uri);
                    }
                    if (modified) {
                        r.setModified(true);
                    }
                } else if (type.equals("decorators")) {
                    if (!(first instanceof Model) && !(first instanceof Scenario)) continue;
                    if (first instanceof Model) {
                        modified = this.checkModelDecorators((Model)first, uri);
                    } else if (first instanceof Scenario) {
                        modified = this.checkScenarioDecorators((Scenario)first, uri);
                    }
                } else if (type.equals("graphs")) {
                    if (!(first instanceof Model) && !(first instanceof Scenario)) continue;
                    modified = first instanceof Model ? this.checkModelGraphs((Model)first, uri) : this.checkScenarioGraphs((Scenario)first, uri);
                } else if (type.equals("predicates")) {
                    if (!(first instanceof Scenario) && !(first instanceof Trigger)) continue;
                    modified = first instanceof Scenario ? this.checkScenarioPredicate((Scenario)first, uri) : this.checkTriggerPredicate((Trigger)first, uri);
                } else if (type.equals("modifiers")) {
                    if (!(first instanceof Scenario) && !(first instanceof Trigger)) continue;
                    modified = first instanceof Scenario ? this.checkScenarioModifier((Scenario)first, uri) : this.checkTriggerModifier((Trigger)first, uri);
                } else if (type.equals("triggers")) {
                    if (!(first instanceof Scenario)) continue;
                    modified = this.checkScenarioTriggers((Scenario)first, uri);
                }
                if (!modified) continue;
                r.setModified(true);
            }
            this.checkEditors(editorReferences, uri);
        }
    }

    private void checkEditors(IEditorReference[] editorReferences, URI uri) {
    }

    private boolean checkModel(Model model, URI modifiedURI) {
        if (model == null || modifiedURI == null) {
            CorePlugin.logError((String)"Null model", (Throwable)new Exception());
        }
        if (model.getURI().lastSegment().equals(modifiedURI.lastSegment())) {
            return true;
        }
        for (Model m : model.getModels()) {
            boolean modified = this.checkModel(m, modifiedURI);
            if (!modified) continue;
            return true;
        }
        return false;
    }

    private boolean checkScenario(Scenario scenario, URI modifiedURI) {
        Model m = scenario.getModel();
        if (m == null) {
            return false;
        }
        return this.checkModel(m, modifiedURI);
    }

    private boolean checkExperiment(Experiment experiment, URI modifiedURI) {
        Scenario scenario = experiment.getScenario();
        if (scenario == null) {
            return false;
        }
        return this.checkScenario(scenario, modifiedURI);
    }

    private boolean checkModelDecorators(Model model, URI modifiedURI) {
        if (model == null || modifiedURI == null) {
            CorePlugin.logError((String)"Null model or decorator", (Throwable)new Exception());
        }
        for (Decorator d : model.getNodeDecorators()) {
            if (!d.getURI().lastSegment().equals(modifiedURI.lastSegment())) continue;
            return true;
        }
        for (Model m : model.getModels()) {
            boolean modified = this.checkModelDecorators(m, modifiedURI);
            if (!modified) continue;
            return true;
        }
        return false;
    }

    private boolean checkScenarioDecorators(Scenario scenario, URI modifiedURI) {
        Model m = scenario.getModel();
        if (m == null) {
            return false;
        }
        boolean modified = this.checkModelDecorators(m, modifiedURI);
        if (modified) {
            return true;
        }
        for (Decorator d : scenario.getScenarioDecorators()) {
            if (d.eIsProxy() || !d.getURI().lastSegment().equals(modifiedURI.lastSegment())) continue;
            return true;
        }
        return false;
    }

    private boolean checkModelGraphs(Model model, URI modifiedURI) {
        if (model == null || modifiedURI == null) {
            CorePlugin.logError((String)"Null model or uri", (Throwable)new Exception());
        }
        for (Graph g : model.getGraphs()) {
            if (!g.getURI().lastSegment().equals(modifiedURI.lastSegment())) continue;
            return true;
        }
        for (Model m : model.getModels()) {
            boolean modified = this.checkModelGraphs(m, modifiedURI);
            if (!modified) continue;
            return true;
        }
        return false;
    }

    private boolean checkScenarioGraphs(Scenario scenario, URI modifiedURI) {
        if (scenario == null || modifiedURI == null) {
            CorePlugin.logError((String)"Null model or uri", (Throwable)new Exception());
        }
        Model m = scenario.getModel();
        return this.checkModelGraphs(m, modifiedURI);
    }

    private boolean checkScenarioPredicate(Scenario scenario, URI modifiedURI) {
        if (scenario == null || modifiedURI == null) {
            CorePlugin.logError((String)"Null model or uri", (Throwable)new Exception());
        }
        for (Decorator d : scenario.getScenarioDecorators()) {
            Trigger tg;
            IdentifiablePredicateExpression ipe;
            if (!(d instanceof Trigger) || (ipe = (IdentifiablePredicateExpression)(tg = (Trigger)d).getPredicate()) == null || !ipe.getURI().equals(modifiedURI)) continue;
            return true;
        }
        return false;
    }

    private boolean checkTriggerPredicate(Trigger trigger, URI modifiedURI) {
        IdentifiablePredicateExpression ipe;
        if (trigger == null || modifiedURI == null) {
            CorePlugin.logError((String)"Null model or uri", (Throwable)new Exception());
        }
        return (ipe = (IdentifiablePredicateExpression)trigger.getPredicate()) != null && ipe.getURI().equals(modifiedURI);
    }

    private boolean checkScenarioModifier(Scenario scenario, URI modifiedURI) {
        if (scenario == null || modifiedURI == null) {
            CorePlugin.logError((String)"Null model or uri", (Throwable)new Exception());
        }
        for (Decorator d : scenario.getScenarioDecorators()) {
            if (!(d instanceof Trigger)) continue;
            Trigger tg = (Trigger)d;
            for (Decorator dec : tg.getActions()) {
                if (!dec.getURI().equals(modifiedURI)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkScenarioTriggers(Scenario scenario, URI modifiedURI) {
        if (scenario == null || modifiedURI == null) {
            CorePlugin.logError((String)"Null model or uri", (Throwable)new Exception());
        }
        for (Decorator d : scenario.getScenarioDecorators()) {
            Trigger tg;
            if (!(d instanceof Trigger) || !(tg = (Trigger)d).getURI().equals(modifiedURI)) continue;
            return true;
        }
        return false;
    }

    private boolean checkTriggerModifier(Trigger trigger, URI modifiedURI) {
        if (trigger == null || modifiedURI == null) {
            CorePlugin.logError((String)"Null model or uri", (Throwable)new Exception());
        }
        for (Decorator dec : trigger.getActions()) {
            if (dec == null || dec.getURI() == null || !dec.getURI().equals(modifiedURI)) continue;
            return true;
        }
        return false;
    }

    private String getProject(URI uri) {
        if (uri.toString().startsWith("platform:/resource")) {
            String s1 = uri.toString().substring(19);
            int is = s1.indexOf("/");
            String project = s1.substring(0, is);
            return project;
        }
        if (uri.toString().startsWith("file:/")) {
            String uri2;
            int i2;
            String sURI = uri.toString();
            int ind = sURI.indexOf("/models/");
            if (ind == -1) {
                ind = sURI.indexOf("/decorators/");
            }
            if (ind == -1) {
                ind = sURI.indexOf("/experiments/");
            }
            if (ind == -1) {
                ind = sURI.indexOf("/graphs/");
            }
            if (ind == -1) {
                ind = sURI.indexOf("/loggers/");
            }
            if (ind == -1) {
                ind = sURI.indexOf("/modifiers/");
            }
            if (ind == -1) {
                ind = sURI.indexOf("/predicates/");
            }
            if (ind == -1) {
                ind = sURI.indexOf("/sequencers/");
            }
            if (ind == -1) {
                ind = sURI.indexOf("/scenarios/");
            }
            if (ind == -1) {
                ind = sURI.indexOf("/triggers/");
            }
            if (ind == -1) {
                ind = sURI.indexOf("/solvers/");
            }
            if (ind >= 0 && (i2 = (uri2 = sURI.substring(0, ind)).lastIndexOf("/")) > -1) {
                return uri2.substring(i2 + 1);
            }
        }
        return null;
    }

    private String getType(URI uri) {
        int is;
        if (!uri.toString().startsWith("platform:/resource")) {
            return null;
        }
        String s1 = uri.toString().substring(19);
        String _project = s1.substring((is = s1.indexOf("/")) + 1);
        int is2 = _project.indexOf("/");
        if (is2 == -1) {
            return "";
        }
        String type = _project.substring(0, is2);
        return type;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 1 || event.getType() == 16) {
            org.eclipse.stem.core.Utility.unloadAllResources();
        }
    }

    public static Viewer getViewer() {
        return viewer;
    }

    private static class MyRunnable
    implements Runnable {
        public IEditorReference[] references;

        private MyRunnable() {
        }

        @Override
        public void run() {
            this.references = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        }

        public IEditorReference[] getReferences() {
            return this.references;
        }
    }
}

