/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.lang.reflect.Constructor;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.support.hierarchical.DefaultParallelExecutionConfigurationStrategy;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.ParallelExecutionConfiguration;
import org.junit.platform.engine.support.hierarchical.ParallelExecutionConfigurationStrategy;
import org.junit.platform.engine.support.hierarchical.ResourceLock;

@API(status=API.Status.EXPERIMENTAL, since="1.3")
public class ForkJoinPoolHierarchicalTestExecutorService
implements HierarchicalTestExecutorService {
    private final ForkJoinPool forkJoinPool;
    private final int parallelism;

    public ForkJoinPoolHierarchicalTestExecutorService(ConfigurationParameters configurationParameters) {
        this(ForkJoinPoolHierarchicalTestExecutorService.createConfiguration(configurationParameters));
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.7")
    public ForkJoinPoolHierarchicalTestExecutorService(ParallelExecutionConfiguration configuration) {
        this.forkJoinPool = this.createForkJoinPool(configuration);
        this.parallelism = this.forkJoinPool.getParallelism();
        LoggerFactory.getLogger(this.getClass()).config(() -> "Using ForkJoinPool with parallelism of " + this.parallelism);
    }

    private static ParallelExecutionConfiguration createConfiguration(ConfigurationParameters configurationParameters) {
        ParallelExecutionConfigurationStrategy strategy = DefaultParallelExecutionConfigurationStrategy.getStrategy(configurationParameters);
        return strategy.createConfiguration(configurationParameters);
    }

    private ForkJoinPool createForkJoinPool(ParallelExecutionConfiguration configuration) {
        WorkerThreadFactory threadFactory = new WorkerThreadFactory();
        return (ForkJoinPool)Try.call(() -> {
            Constructor constructor = ForkJoinPool.class.getDeclaredConstructor(Integer.TYPE, ForkJoinPool.ForkJoinWorkerThreadFactory.class, Thread.UncaughtExceptionHandler.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Predicate.class, Long.TYPE, TimeUnit.class);
            return (ForkJoinPool)constructor.newInstance(new Object[]{configuration.getParallelism(), threadFactory, null, false, configuration.getCorePoolSize(), configuration.getMaxPoolSize(), configuration.getMinimumRunnable(), null, configuration.getKeepAliveSeconds(), TimeUnit.SECONDS});
        }).orElseTry(() -> new ForkJoinPool(configuration.getParallelism(), threadFactory, null, false)).getOrThrow(cause -> new JUnitException("Failed to create ForkJoinPool", (Throwable)cause));
    }

    @Override
    public Future<Void> submit(HierarchicalTestExecutorService.TestTask testTask) {
        ExclusiveTask exclusiveTask = new ExclusiveTask(testTask);
        if (!this.isAlreadyRunningInForkJoinPool()) {
            return this.forkJoinPool.submit(exclusiveTask);
        }
        if (testTask.getExecutionMode() == Node.ExecutionMode.CONCURRENT && ForkJoinTask.getSurplusQueuedTaskCount() < this.parallelism) {
            return exclusiveTask.fork();
        }
        exclusiveTask.compute();
        return CompletableFuture.completedFuture(null);
    }

    private boolean isAlreadyRunningInForkJoinPool() {
        return ForkJoinTask.getPool() == this.forkJoinPool;
    }

    @Override
    public void invokeAll(List<? extends HierarchicalTestExecutorService.TestTask> tasks) {
        if (tasks.size() == 1) {
            new ExclusiveTask(tasks.get(0)).compute();
            return;
        }
        LinkedList<ExclusiveTask> nonConcurrentTasks = new LinkedList<ExclusiveTask>();
        LinkedList<ExclusiveTask> concurrentTasksInReverseOrder = new LinkedList<ExclusiveTask>();
        this.forkConcurrentTasks(tasks, nonConcurrentTasks, concurrentTasksInReverseOrder);
        this.executeNonConcurrentTasks(nonConcurrentTasks);
        this.joinConcurrentTasksInReverseOrderToEnableWorkStealing(concurrentTasksInReverseOrder);
    }

    private void forkConcurrentTasks(List<? extends HierarchicalTestExecutorService.TestTask> tasks, Deque<ExclusiveTask> nonConcurrentTasks, Deque<ExclusiveTask> concurrentTasksInReverseOrder) {
        for (HierarchicalTestExecutorService.TestTask testTask : tasks) {
            ExclusiveTask exclusiveTask = new ExclusiveTask(testTask);
            if (testTask.getExecutionMode() == Node.ExecutionMode.CONCURRENT) {
                exclusiveTask.fork();
                concurrentTasksInReverseOrder.addFirst(exclusiveTask);
                continue;
            }
            nonConcurrentTasks.add(exclusiveTask);
        }
    }

    private void executeNonConcurrentTasks(Deque<ExclusiveTask> nonConcurrentTasks) {
        for (ExclusiveTask task : nonConcurrentTasks) {
            task.compute();
        }
    }

    private void joinConcurrentTasksInReverseOrderToEnableWorkStealing(Deque<ExclusiveTask> concurrentTasksInReverseOrder) {
        for (ExclusiveTask forkedTask : concurrentTasksInReverseOrder) {
            forkedTask.join();
        }
    }

    @Override
    public void close() {
        this.forkJoinPool.shutdownNow();
    }

    static class ExclusiveTask
    extends RecursiveAction {
        private final HierarchicalTestExecutorService.TestTask testTask;

        ExclusiveTask(HierarchicalTestExecutorService.TestTask testTask) {
            this.testTask = testTask;
        }

        @Override
        public void compute() {
            try (ResourceLock lock = this.testTask.getResourceLock().acquire();){
                this.testTask.execute();
            }
            catch (InterruptedException e) {
                ExceptionUtils.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    static class WorkerThread
    extends ForkJoinWorkerThread {
        WorkerThread(ForkJoinPool pool, ClassLoader contextClassLoader) {
            super(pool);
            this.setContextClassLoader(contextClassLoader);
        }
    }

    static class WorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        WorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new WorkerThread(pool, this.contextClassLoader);
        }
    }
}

