/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.touchpoint.eclipse.query.OSGiBundleQuery;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IUBundleContainer
extends AbstractBundleContainer {
    public static final String TYPE = "InstallableUnit";
    private static final String FEATURE_ID_SUFFIX = ".feature.group";
    public static final int INCLUDE_REQUIRED = 1;
    public static final int INCLUDE_ALL_ENVIRONMENTS = 2;
    public static final int INCLUDE_SOURCE = 4;
    public static final int INCLUDE_CONFIGURE_PHASE = 8;
    private String[] fIds;
    private Version[] fVersions;
    private IInstallableUnit[] fUnits;
    private URI[] fRepos;
    private final int fFlags;
    private P2TargetUtils fSynchronizer;
    private ITargetDefinition fTarget;

    IUBundleContainer(String[] ids, String[] versions, URI[] repositories, int resolutionFlags) {
        this.fIds = ids;
        this.fFlags = resolutionFlags;
        this.fVersions = new Version[versions.length];
        int i = 0;
        while (i < versions.length) {
            this.fVersions[i] = Version.create((String)versions[i]);
            ++i;
        }
        this.fRepos = repositories == null || repositories.length == 0 ? null : repositories;
    }

    IUBundleContainer(IInstallableUnit[] units, URI[] repositories, int resolutionFlags) {
        this.fIds = new String[units.length];
        this.fFlags = resolutionFlags;
        this.fVersions = new Version[units.length];
        int i = 0;
        while (i < units.length) {
            this.fIds[i] = units[i].getId();
            this.fVersions[i] = units[i].getVersion();
            ++i;
        }
        this.fRepos = repositories == null || repositories.length == 0 ? null : repositories;
    }

    @Override
    public String getLocation(boolean resolve) throws CoreException {
        return P2TargetUtils.BUNDLE_POOL.toOSString();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected TargetFeature[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        this.fTarget = definition;
        if (!this.isResolved()) {
            this.fSynchronizer.synchronize(definition, monitor);
        }
        return this.fFeatures;
    }

    public ITargetDefinition getTarget() {
        return this.isResolved() ? this.fTarget : null;
    }

    TargetFeature[] cacheFeatures(ITargetDefinition target) throws CoreException {
        HashSet<NameVersionDescriptor> features = new HashSet<NameVersionDescriptor>();
        IQueryResult queryResult = this.fSynchronizer.getProfile().query(QueryUtil.createIUAnyQuery(), null);
        if (queryResult.isEmpty()) {
            return new TargetFeature[0];
        }
        for (IInstallableUnit unit : queryResult) {
            String id = unit.getId();
            if (!id.endsWith(FEATURE_ID_SUFFIX)) continue;
            id = id.substring(0, id.length() - FEATURE_ID_SUFFIX.length());
            String version = unit.getVersion().toString();
            features.add(new NameVersionDescriptor(id, version, "feature"));
        }
        if (features.isEmpty()) {
            return new TargetFeature[0];
        }
        TargetFeature[] allFeatures = ((TargetDefinition)target).resolveFeatures(this.getLocation(false), (IProgressMonitor)new NullProgressMonitor());
        ArrayList<TargetFeature> result = new ArrayList<TargetFeature>();
        TargetFeature[] targetFeatureArray = allFeatures;
        int n = allFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            TargetFeature allFeature = targetFeatureArray[n2];
            NameVersionDescriptor candidate = new NameVersionDescriptor(allFeature.getId(), allFeature.getVersion(), "feature");
            if (features.contains(candidate)) {
                result.add(allFeature);
            }
            ++n2;
        }
        this.fFeatures = result.toArray(new TargetFeature[result.size()]);
        return this.fFeatures;
    }

    @Override
    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        this.fTarget = definition;
        if (!this.isResolved()) {
            this.fSynchronizer.synchronize(definition, monitor);
        }
        return this.fBundles;
    }

    IInstallableUnit[] cacheIUs(ITargetDefinition target) throws CoreException {
        IProfile profile = this.fSynchronizer.getProfile();
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
        MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, Messages.IUBundleContainer_ProblemsLoadingRepositories, null);
        int i = 0;
        while (i < this.fIds.length) {
            IQuery query = QueryUtil.createIUQuery((String)this.fIds[i], (Version)this.fVersions[i]);
            IQueryResult queryResult = profile.query(query, null);
            if (queryResult.isEmpty()) {
                status.add((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.IUBundleContainer_1, (Object)(String.valueOf(this.fIds[i]) + " " + this.fVersions[i]))));
            } else {
                result.add((IInstallableUnit)queryResult.iterator().next());
            }
            ++i;
        }
        if (!status.isOK()) {
            this.fResolutionStatus = status;
            throw new CoreException((IStatus)status);
        }
        this.fUnits = result.toArray(new IInstallableUnit[result.size()]);
        return this.fUnits;
    }

    TargetBundle[] cacheBundles(ITargetDefinition target) throws CoreException {
        boolean onlyStrict = !this.fSynchronizer.getIncludeAllRequired();
        IProfile metadata = this.fSynchronizer.getProfile();
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)metadata, new HashMap(), true, false, true, onlyStrict, false);
        IQueryable slice = slicer.slice(this.fUnits, (IProgressMonitor)new NullProgressMonitor());
        if (slicer.getStatus().getSeverity() == 4) {
            throw new CoreException((IStatus)slicer.getStatus());
        }
        IFileArtifactRepository artifacts = null;
        try {
            if (P2TargetUtils.fgTargetArtifactRepo.containsKey(target)) {
                artifacts = P2TargetUtils.fgTargetArtifactRepo.get(target);
            } else {
                artifacts = P2TargetUtils.getBundlePool();
                P2TargetUtils.fgTargetArtifactRepo.put(target, artifacts);
            }
        }
        catch (CoreException coreException) {
            if (PDECore.DEBUG_TARGET_PROFILE) {
                System.out.println("Bundle pool repository could not be loaded");
            }
            this.fBundles = null;
            return null;
        }
        Map<BundleInfo, TargetBundle> bundles = this.generateResolvedBundles((IQueryable<IInstallableUnit>)slice, (IQueryable<IInstallableUnit>)metadata, artifacts);
        if (bundles.isEmpty()) {
            if (PDECore.DEBUG_TARGET_PROFILE) {
                System.out.println("Profile does not contain any bundles or artifacts were missing");
            }
            if (slicer.getStatus().getSeverity() == 2) {
                throw new CoreException((IStatus)slicer.getStatus());
            }
            this.fBundles = null;
            return null;
        }
        this.fBundles = bundles.values().toArray(new TargetBundle[bundles.size()]);
        return this.fBundles;
    }

    void synchronizerChanged(ITargetDefinition target) {
        try {
            this.cacheIUs(target);
            this.cacheBundles(target);
            this.cacheFeatures(target);
        }
        catch (CoreException e) {
            this.fBundles = new TargetBundle[0];
            this.fFeatures = new TargetFeature[0];
            this.fResolutionStatus = e.getStatus();
        }
    }

    public synchronized boolean update(Set<String> toUpdate, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IQueryable<IInstallableUnit> source = P2TargetUtils.getQueryableMetadata(this.fRepos, (IProgressMonitor)progress.split(30));
        boolean updated = false;
        SubMonitor loopProgress = progress.split(70).setWorkRemaining(this.fIds.length);
        int i = 0;
        while (i < this.fIds.length) {
            if (toUpdate.isEmpty() || toUpdate.contains(this.fIds[i])) {
                IQuery query = QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)this.fIds[i]));
                IQueryResult queryResult = source.query(query, (IProgressMonitor)loopProgress.split(1));
                Iterator it = queryResult.iterator();
                if (!it.hasNext()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.IUBundleContainer_1, (Object)this.fIds[i])));
                }
                IInstallableUnit iu = (IInstallableUnit)it.next();
                if (!iu.getVersion().equals(this.fVersions[i])) {
                    updated = true;
                    if (!this.fVersions[i].equals(Version.emptyVersion)) {
                        this.fVersions[i] = iu.getVersion();
                    }
                }
            }
            ++i;
        }
        if (updated && this.fTarget instanceof TargetDefinition) {
            ((TargetDefinition)this.fTarget).incrementSequenceNumber();
        }
        if (!updated) {
            this.clearResolutionStatus();
        }
        return updated;
    }

    private Map<BundleInfo, TargetBundle> generateResolvedBundles(IQueryable<IInstallableUnit> source, IQueryable<IInstallableUnit> metadata, IFileArtifactRepository artifacts) throws CoreException {
        OSGiBundleQuery query = new OSGiBundleQuery();
        IQueryResult queryResult = source.query((IQuery)query, null);
        LinkedHashMap<BundleInfo, TargetBundle> bundles = new LinkedHashMap<BundleInfo, TargetBundle>();
        for (IInstallableUnit unit : queryResult) {
            IQuery sourceQuery;
            IQueryResult result;
            this.generateBundle(unit, artifacts, bundles);
            if (!this.getIncludeSource() || (result = metadata.query(sourceQuery = QueryUtil.createIUQuery((String)(String.valueOf(unit.getId()) + ".source"), (Version)unit.getVersion()), null)).isEmpty()) continue;
            this.generateBundle((IInstallableUnit)result.iterator().next(), artifacts, bundles);
        }
        return bundles;
    }

    private void generateBundle(IInstallableUnit unit, IFileArtifactRepository repo, Map<BundleInfo, TargetBundle> bundles) throws CoreException {
        Collection artifacts = unit.getArtifacts();
        for (IArtifactKey artifactKey : artifacts) {
            File file = null;
            Map<IFileArtifactRepository, File> mapRepoFile = P2TargetUtils.fgArtifactKeyRepoFile.get(artifactKey);
            if (mapRepoFile != null) {
                file = mapRepoFile.get(repo);
            }
            if (file == null && (file = repo.getArtifactFile(artifactKey)) != null) {
                ConcurrentHashMap<IFileArtifactRepository, File> repoFile = new ConcurrentHashMap<IFileArtifactRepository, File>();
                repoFile.put(repo, file);
                P2TargetUtils.fgArtifactKeyRepoFile.putIfAbsent(artifactKey, repoFile);
            }
            if (file == null) continue;
            TargetBundle bundle = new TargetBundle(file);
            bundles.put(bundle.getBundleInfo(), bundle);
        }
    }

    public int hashCode() {
        int hash = Boolean.valueOf(this.getIncludeAllRequired()).hashCode();
        hash = 31 * hash + Boolean.valueOf(this.getIncludeAllEnvironments()).hashCode();
        hash = 31 * hash + Boolean.valueOf(this.getIncludeSource()).hashCode();
        hash = 31 * hash + Boolean.valueOf(this.getIncludeConfigurePhase()).hashCode();
        hash = 31 * hash + Arrays.hashCode(this.fIds);
        hash = 31 * hash + Arrays.hashCode(this.fRepos);
        hash = 31 * hash + Arrays.hashCode(this.fVersions);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IUBundleContainer)) {
            return false;
        }
        IUBundleContainer other = (IUBundleContainer)obj;
        if (this.getIncludeAllRequired() != other.getIncludeAllRequired()) {
            return false;
        }
        if (this.getIncludeAllEnvironments() != other.getIncludeAllEnvironments()) {
            return false;
        }
        if (this.getIncludeSource() != other.getIncludeSource()) {
            return false;
        }
        if (this.getIncludeConfigurePhase() != other.getIncludeConfigurePhase()) {
            return false;
        }
        if (!Arrays.equals(this.fIds, other.fIds)) {
            return false;
        }
        if (!Arrays.equals(this.fRepos, other.fRepos)) {
            return false;
        }
        return Arrays.equals(this.fVersions, other.fVersions);
    }

    public URI[] getRepositories() {
        return this.fRepos;
    }

    public synchronized void removeInstallableUnit(IInstallableUnit unit) {
        ArrayList<String> newIds = new ArrayList<String>(this.fIds.length);
        ArrayList<Version> newVersions = new ArrayList<Version>(this.fIds.length);
        int i = 0;
        while (i < this.fIds.length) {
            if (!this.fIds[i].equals(unit.getId()) || !this.fVersions[i].equals(unit.getVersion())) {
                newIds.add(this.fIds[i]);
                newVersions.add(this.fVersions[i]);
            }
            ++i;
        }
        this.fIds = newIds.toArray(new String[newIds.size()]);
        this.fVersions = newVersions.toArray(new Version[newVersions.size()]);
        this.clearResolutionStatus();
    }

    public boolean getIncludeAllRequired() {
        if (this.fSynchronizer == null) {
            return (this.fFlags & 1) == 1;
        }
        return this.fSynchronizer.getIncludeAllRequired();
    }

    public boolean getIncludeAllEnvironments() {
        if (this.fSynchronizer == null) {
            return (this.fFlags & 2) == 2;
        }
        return this.fSynchronizer.getIncludeAllEnvironments();
    }

    public boolean getIncludeSource() {
        if (this.fSynchronizer == null) {
            return (this.fFlags & 4) == 4;
        }
        return this.fSynchronizer.getIncludeSource();
    }

    public boolean getIncludeConfigurePhase() {
        if (this.fSynchronizer == null) {
            return (this.fFlags & 8) == 8;
        }
        return this.fSynchronizer.getIncludeConfigurePhase();
    }

    public IInstallableUnit[] getInstallableUnits() throws CoreException {
        if (this.fUnits == null) {
            return new IInstallableUnit[0];
        }
        return this.fUnits;
    }

    String[] getIds() {
        return this.fIds;
    }

    Version[] getVersions() {
        return this.fVersions;
    }

    P2TargetUtils getSynchronizer(ITargetDefinition definition) {
        if (this.fSynchronizer != null) {
            return this.fSynchronizer;
        }
        if (definition == null) {
            return null;
        }
        this.fSynchronizer = P2TargetUtils.getSynchronizer(definition);
        return this.fSynchronizer;
    }

    void setSynchronizer(P2TargetUtils value) {
        this.fSynchronizer = value;
    }

    @Override
    protected void associateWithTarget(ITargetDefinition target) {
        super.associateWithTarget(target);
        this.fSynchronizer = this.getSynchronizer(target);
        this.fSynchronizer.setIncludeAllRequired((this.fFlags & 1) == 1);
        this.fSynchronizer.setIncludeAllEnvironments((this.fFlags & 2) == 2);
        this.fSynchronizer.setIncludeSource((this.fFlags & 4) == 4);
        this.fSynchronizer.setIncludeConfigurePhase((this.fFlags & 8) == 8);
    }

    @Override
    public String serialize() {
        Document document;
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = docBuilder.newDocument();
        }
        catch (Exception e) {
            PDECore.log(e);
            return null;
        }
        Element containerElement = document.createElement("location");
        containerElement.setAttribute("type", this.getType());
        containerElement.setAttribute("includeMode", this.getIncludeAllRequired() ? "planner" : "slicer");
        containerElement.setAttribute("includeAllPlatforms", Boolean.toString(this.getIncludeAllEnvironments()));
        containerElement.setAttribute("includeSource", Boolean.toString(this.getIncludeSource()));
        containerElement.setAttribute("includeConfigurePhase", Boolean.toString(this.getIncludeConfigurePhase()));
        Object[] repositories = this.getRepositories();
        if (repositories != null) {
            Arrays.sort(repositories);
            Object[] objectArray = repositories;
            int n = repositories.length;
            int n2 = 0;
            while (n2 < n) {
                Object repository = objectArray[n2];
                Element repo = document.createElement("repository");
                repo.setAttribute("location", ((URI)repository).toASCIIString());
                containerElement.appendChild(repo);
                ++n2;
            }
        }
        String[] ids = this.getIds();
        Version[] versions = this.getVersions();
        int[] nArray = this.getPredictableOrder(ids, versions);
        int n = nArray.length;
        int n3 = 0;
        while (n3 < n) {
            int i = nArray[n3];
            Element unit = document.createElement("unit");
            unit.setAttribute("id", ids[i]);
            unit.setAttribute("version", versions[i].toString());
            containerElement.appendChild(unit);
            ++n3;
        }
        try {
            document.appendChild(containerElement);
            StreamResult result = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(document), result);
            return result.getWriter().toString();
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    private int[] getPredictableOrder(String[] ids, Version[] versions) {
        Comparator idVersionCmp = (i1, i2) -> {
            String id1 = ids[i1];
            String id2 = ids[i2];
            Version ver1 = versions[i1];
            Version ver2 = versions[i2];
            int c = id1.compareTo(id2);
            if (c == 0) {
                return ver1.compareTo((Object)ver2);
            }
            return c;
        };
        return IntStream.range(0, ids.length).boxed().sorted(idVersionCmp).mapToInt(i -> i).toArray();
    }

    IInstallableUnit[] getRootIUs(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        IQueryable<IInstallableUnit> repos = P2TargetUtils.getQueryableMetadata(this.getRepositories(), monitor);
        MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, Messages.IUBundleContainer_ProblemsLoadingRepositories, null);
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
        int j = 0;
        while (j < this.fIds.length) {
            IQuery query = QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)this.fIds[j], (Version)this.fVersions[j]));
            IQueryResult queryResult = repos.query(query, null);
            if (queryResult.isEmpty()) {
                status.add((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.IUBundleContainer_1, (Object)(String.valueOf(this.fIds[j]) + " " + this.fVersions[j]))));
            } else {
                result.add((IInstallableUnit)queryResult.iterator().next());
            }
            ++j;
        }
        if (!status.isOK()) {
            this.fResolutionStatus = status;
            throw new CoreException((IStatus)status);
        }
        return result.toArray(new IInstallableUnit[0]);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.fSynchronizer)) {
            return adapter.cast(this.fSynchronizer);
        }
        return (T)super.getAdapter(adapter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append('[');
        int i = 0;
        while (i < this.fRepos.length) {
            sb.append(this.fRepos[i]);
            if (i > 0) {
                sb.append(',');
            }
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }
}

