/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.NumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.ui.adapters.color.STEMColor;
import org.eclipse.stem.ui.preferences.VisualizationPreferencePage;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.Messages;
import org.eclipse.stem.ui.reports.views.ReportControl;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class TimeSeriesCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    private RelativeValueHistoryProvider rvhp;
    private ReportControl control = null;
    protected final ColorDefinition[] colorDefault = new ColorDefinition[]{ColorDefinitionImpl.RED(), ColorDefinitionImpl.ORANGE(), ColorDefinitionImpl.YELLOW(), ColorDefinitionImpl.GREEN(), ColorDefinitionImpl.BLUE(), ColorDefinitionImpl.CYAN(), ColorDefinitionImpl.PINK()};
    final ColorDefinition TEXT_COLOR = ColorDefinitionImpl.create((int)0, (int)0, (int)0);
    final ColorDefinition FRAME_COLOR = ColorDefinitionImpl.create((int)150, (int)150, (int)150);
    final ColorDefinition BACKGROUND_COLOR = ColorDefinitionImpl.create((int)255, (int)255, (int)255);
    protected int seriesCount = 0;
    private double minLogScaleValue = 1.0;
    private static final int DEFAULT_AUTOAXIS_THRESHOLD = 5;
    private int maxTimeAxisValue = 5;
    private static final int MIN_TICKS = 5;
    private static final int MAX_TICKS = 10;
    private static final int TICK_TRIGGER = 2;
    Comparator<ItemPropertyDescriptor> comparator = new Comparator<ItemPropertyDescriptor>(){

        @Override
        public int compare(ItemPropertyDescriptor arg0, ItemPropertyDescriptor arg1) {
            return arg0.getDisplayName((Object)arg0).compareTo(arg1.getDisplayName((Object)arg1));
        }
    };
    protected TreeMap<ItemPropertyDescriptor, Boolean> propertiesToPlot = new TreeMap(this.comparator);
    private static final String[] HIDE_ON_STARTUP = new String[]{"IR", "IF", "Incidence", "Births", "Deaths", "Population Count", "Disease Deaths"};
    private static final Set<String> defaultHideSet = new HashSet<String>();
    protected final Map<String, DataSeries> dataSeriesMap = new HashMap<String, DataSeries>();
    private final List<Double> cycleNumbers = new ArrayList<Double>();
    Generator gr;
    Axis yAxisPrimary;
    Axis xAxisPrimary;
    Menu popUpMenu = null;
    final MenuManager contextMenuManager = new MenuManager();
    private LinearScaleAction linearTimeAction;
    private LogScaleAction logTimeAction;
    protected boolean useLinearTimeScale = true;
    private LegendViewAction viewLegend;
    private ClearAction clearAction;
    List<DisplayableProperty> displayableProperties;
    private LegendHideAction hideLegend;
    protected boolean showLegend = true;
    protected Legend legend = null;
    private static final String defaultKey = "";
    Image imgChart = null;

    public TimeSeriesCanvas(Composite parent) {
        super(parent, 0x20000800);
        int i = 0;
        while (i < HIDE_ON_STARTUP.length) {
            defaultHideSet.add(HIDE_ON_STARTUP[i]);
            ++i;
        }
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            Activator.logError("Problem initializing chart", pex);
            return;
        }
        this.control = (ReportControl)parent;
        this.rvhp = this.control.rvhp;
        this.cm = this.createSimpleLineChart(this.dataSeriesMap, this.cycleNumbers, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                Composite source = (Composite)pe.getSource();
                Rectangle d = source.getClientArea();
                if (TimeSeriesCanvas.this.imgChart != null) {
                    TimeSeriesCanvas.this.imgChart.dispose();
                }
                TimeSeriesCanvas.this.imgChart = new Image((Device)source.getDisplay(), d);
                TimeSeriesCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)TimeSeriesCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)d.x, (double)d.y, (double)d.width, (double)d.height);
                bounds.scale(72.0 / (double)TimeSeriesCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    TimeSeriesCanvas.this.gr.render(TimeSeriesCanvas.this.idr, TimeSeriesCanvas.this.gr.build(TimeSeriesCanvas.this.idr.getDisplayServer(), TimeSeriesCanvas.this.cm, bounds, null, null, null));
                    pe.gc.drawImage(TimeSeriesCanvas.this.imgChart, d.x, d.y);
                }
                catch (ChartException ce) {
                    Activator.logError("Problem rendering chart", ce);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public synchronized void draw() {
        if (this.rvhp != null) {
            double maxY = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            for (DataSeries d : this.dataSeriesMap.values()) {
                d.hide();
            }
            ArrayList<ItemPropertyDescriptor> itemList = new ArrayList<ItemPropertyDescriptor>();
            itemList.addAll(this.propertiesToPlot.keySet());
            Collections.sort(itemList, new Comparator<ItemPropertyDescriptor>(){

                @Override
                public int compare(ItemPropertyDescriptor o1, ItemPropertyDescriptor o2) {
                    return o1.getDisplayName((Object)o1).compareTo(o2.getDisplayName((Object)o2));
                }
            });
            ArrayList<ItemPropertyDescriptor> displayedPropertyList = new ArrayList<ItemPropertyDescriptor>();
            for (ItemPropertyDescriptor property : itemList) {
                DataSeries series;
                boolean visible = this.propertiesToPlot.get(property);
                displayedPropertyList.add(property);
                if (visible) {
                    if (!this.dataSeriesMap.containsKey(property.getDisplayName((Object)property)) || (series = this.dataSeriesMap.get(property.getDisplayName((Object)property))).isVisible()) continue;
                    series.show();
                    continue;
                }
                if (!this.dataSeriesMap.containsKey(property.getDisplayName((Object)property)) || !(series = this.dataSeriesMap.get(property.getDisplayName((Object)property))).isVisible()) continue;
                series.hide();
            }
            double denom = this.rvhp.getDenominator(null);
            if (denom <= 0.0) {
                denom = 1.0;
            }
            this.minLogScaleValue = 0.1 / denom;
            this.resetData();
            boolean setCycles = false;
            int maxPoints = 0;
            STEMTime[] time = this.rvhp.getAllHistoricTimeValues();
            this.cycleNumbers.clear();
            this.cycleNumbers.add(0.0);
            int i = 0;
            while (i < displayedPropertyList.size()) {
                ItemPropertyDescriptor property = (ItemPropertyDescriptor)displayedPropertyList.get(i);
                String propertyName = property.getDisplayName((Object)property);
                double[] doubleValues = this.rvhp.getHistoricInstances(property, time);
                if (doubleValues.length > 0) {
                    if (maxPoints < doubleValues.length) {
                        maxPoints = doubleValues.length;
                    }
                    if (!this.dataSeriesMap.containsKey(property.getDisplayName((Object)property))) {
                        if (this.dataSeriesMap.containsKey(defaultKey)) {
                            this.removeDataSeries(defaultKey);
                        }
                        DataSeries series = new DataSeries(propertyName, this.seriesCount);
                        this.dataSeriesMap.put(propertyName, series);
                    }
                    int earliestCycleNumber = this.rvhp.getEarliestCycleNumber();
                    DataSeries series = this.dataSeriesMap.get(property.getDisplayName((Object)property));
                    int cycleNumber = 0;
                    while (cycleNumber < doubleValues.length) {
                        double displayValue = doubleValues[cycleNumber];
                        if (displayValue <= this.minLogScaleValue && !this.useLinearTimeScale) {
                            displayValue = this.minLogScaleValue;
                        }
                        Double value = this.useLinearTimeScale ? Double.valueOf(displayValue) : Double.valueOf(Math.log(displayValue));
                        if (maxY < displayValue && series.isVisible()) {
                            maxY = displayValue;
                        }
                        if (minY > displayValue && series.isVisible()) {
                            minY = displayValue;
                        }
                        series.addValue(cycleNumber, value);
                        if (!setCycles) {
                            if (this.cycleNumbers.size() < series.relativeValues.size()) {
                                this.cycleNumbers.add(Double.valueOf(earliestCycleNumber + cycleNumber));
                            }
                            if (this.cycleNumbers.size() > 2 * this.maxTimeAxisValue) {
                                this.maxTimeAxisValue = this.cycleNumbers.size() + 1;
                                int stepX = this.maxTimeAxisValue / 5;
                                this.xAxisPrimary.getScale().setStep((double)stepX);
                            }
                        }
                        ++cycleNumber;
                    }
                    setCycles = true;
                } else {
                    this.resetData();
                }
                ++i;
            }
            if (this.useLinearTimeScale) {
                if (maxY == Double.MIN_VALUE) {
                    this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
                    this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
                    this.yAxisPrimary.getScale().setStep(0.25);
                    this.setYAxisNumberFormatFromMaxY(1.0);
                } else if (maxY - minY != 0.0) {
                    this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)maxY));
                    this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
                    this.yAxisPrimary.getScale().setStep(maxY / 5.0);
                    this.setYAxisNumberFormatFromMaxY(maxY);
                } else if (maxY == minY && maxY > 0.0) {
                    this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)maxY));
                    this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
                    this.yAxisPrimary.getScale().setStep(maxY / 5.0);
                    this.setYAxisNumberFormatFromMaxY(maxY);
                } else {
                    this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
                    this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
                    this.yAxisPrimary.getScale().setStep(0.25);
                    this.setYAxisNumberFormatFromMaxY(1.0);
                }
            } else {
                this.setYAxisLogNumberFormat();
            }
        } else {
            this.resetData();
        }
        for (DataSeries ds : this.dataSeriesMap.values()) {
            if (ds.relativeValues.size() >= this.cycleNumbers.size()) continue;
            ds.relativeValues.clear();
            int n = 0;
            while (n < this.cycleNumbers.size()) {
                ds.addValue(0, 0.0);
                ++n;
            }
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    private void setYAxisLogNumberFormat() {
        NumberFormatSpecifier jnfs = null;
        jnfs = NumberFormatSpecifierImpl.create();
        this.yAxisPrimary.setFormatSpecifier((FormatSpecifier)jnfs);
    }

    private void createContextMenu(Composite parent) {
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        this.contextMenuManager.add((IAction)this.linearTimeAction);
        this.contextMenuManager.add((IAction)this.logTimeAction);
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        this.contextMenuManager.add((IAction)this.viewLegend);
        this.contextMenuManager.add((IAction)this.hideLegend);
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.popUpMenu = this.contextMenuManager.createContextMenu((Control)parent);
        parent.setMenu(this.popUpMenu);
    }

    private void updateContextMenu(Composite parent) {
        this.popUpMenu.dispose();
        this.contextMenuManager.removeAll();
        if (this.linearTimeAction == null) {
            this.linearTimeAction = new LinearScaleAction();
        }
        if (this.logTimeAction == null) {
            this.logTimeAction = new LogScaleAction();
        }
        this.contextMenuManager.add((IAction)this.linearTimeAction);
        this.contextMenuManager.add((IAction)this.logTimeAction);
        this.contextMenuManager.update();
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        this.contextMenuManager.add((IAction)this.viewLegend);
        this.contextMenuManager.add((IAction)this.hideLegend);
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.clearAction = new ClearAction();
        this.contextMenuManager.add((IAction)this.clearAction);
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        if (this.displayableProperties == null) {
            this.displayableProperties = new ArrayList<DisplayableProperty>();
        } else {
            this.displayableProperties.clear();
        }
        if (this.rvhp != null) {
            this.contextMenuManager.update();
            Iterator<ItemPropertyDescriptor> iter = this.propertiesToPlot.keySet().iterator();
            while (iter != null && iter.hasNext()) {
                ItemPropertyDescriptor nextProp = iter.next();
                DisplayableProperty property = new DisplayableProperty(nextProp);
                this.displayableProperties.add(property);
                this.contextMenuManager.add((IAction)property);
            }
            this.contextMenuManager.updateAll(true);
        }
        this.contextMenuManager.update();
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        Menu popUpMenu = this.contextMenuManager.createContextMenu((Control)parent);
        parent.setMenu(popUpMenu);
    }

    public final Chart createSimpleLineChart(Map<String, DataSeries> dataSeriesMap, List<Double> cycleNumbers, String seriesIdentifier) {
        ChartWithAxes chartWithAxes = ChartWithAxesImpl.create();
        chartWithAxes.getBlock().setBackground((Fill)this.FRAME_COLOR);
        Plot p = chartWithAxes.getPlot();
        p.getClientArea().setBackground((Fill)this.BACKGROUND_COLOR);
        chartWithAxes.getTitle().setVisible(false);
        this.legend = chartWithAxes.getLegend();
        LineAttributes lia = this.legend.getOutline();
        this.legend.getText().getFont().setSize(8.0f);
        lia.setStyle(LineStyle.SOLID_LITERAL);
        this.legend.getInsets().set(10.0, 5.0, 0.0, 0.0);
        this.legend.getOutline().setVisible(false);
        this.legend.setAnchor(Anchor.NORTH_LITERAL);
        this.legend.setPosition(Position.BELOW_LITERAL);
        this.legend.getText().setColor(this.TEXT_COLOR);
        this.legend.getOutline().setColor(this.TEXT_COLOR);
        this.xAxisPrimary = chartWithAxes.getPrimaryBaseAxes()[0];
        this.xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxisPrimary.getTitle().setVisible(false);
        this.xAxisPrimary.getTitle().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getTitle().getCaption().setColor(this.TEXT_COLOR);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.TEXT_COLOR);
        this.xAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        this.xAxisPrimary.getScale().setTickBetweenCategories(false);
        Series seCategory = SeriesImpl.create();
        seCategory.getLabel().getCaption().setColor(this.TEXT_COLOR);
        seCategory.getLabel().getOutline().setColor(this.TEXT_COLOR);
        NumberDataSet orthoValuesX = NumberDataSetImpl.create(cycleNumbers);
        Series lsx = SeriesImpl.create();
        lsx.setDataSet((DataSet)orthoValuesX);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        sdX.setSorting(SortOption.ASCENDING_LITERAL);
        this.xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        this.xAxisPrimary.setCategoryAxis(false);
        sdX.getSeries().add((Object)lsx);
        this.yAxisPrimary = chartWithAxes.getPrimaryOrthogonalAxis(this.xAxisPrimary);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.xAxisPrimary.getScale().setStep(10.0);
        this.xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.setTimeLabel();
        this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.yAxisPrimary.getScale().setStep(0.25);
        this.yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.yAxisPrimary.getLabel().getCaption().setColor(this.TEXT_COLOR);
        this.yAxisPrimary.getTitle().getCaption().setColor(this.TEXT_COLOR);
        this.setYAxisNumberFormatFromMaxY(1.0);
        if (dataSeriesMap.size() == 0) {
            DataSeries series = new DataSeries(defaultKey, this.seriesCount);
            dataSeriesMap.put(defaultKey, series);
        }
        return chartWithAxes;
    }

    private void setYAxisNumberFormatFromMaxY(double maxY) {
        JavaNumberFormatSpecifier jnfs = null;
        jnfs = maxY < 0.001 ? JavaNumberFormatSpecifierImpl.create((String)"0.####E0") : JavaNumberFormatSpecifierImpl.create((String)"0.#####");
        this.yAxisPrimary.setFormatSpecifier((FormatSpecifier)jnfs);
    }

    void setTimeLabel() {
        ISimulation sim;
        String val = defaultKey;
        if (this.control != null && (sim = this.control.simulation) != null) {
            long timeDelta = sim.getScenario().getSequencer().getTimeDelta();
            if (timeDelta < STEMTime.Units.MINUTE.getMilliseconds()) {
                val = "secs";
                this.xAxisPrimary.getTitle().setVisible(true);
                this.xAxisPrimary.getTitle().getCaption().setValue(val);
                return;
            }
            if (timeDelta < STEMTime.Units.HOUR.getMilliseconds()) {
                val = "mins";
                this.xAxisPrimary.getTitle().setVisible(true);
                this.xAxisPrimary.getTitle().getCaption().setValue(val);
                return;
            }
            if (timeDelta < STEMTime.Units.DAY.getMilliseconds()) {
                val = "hrs";
                this.xAxisPrimary.getTitle().setVisible(true);
                this.xAxisPrimary.getTitle().getCaption().setValue(val);
                return;
            }
            if (timeDelta <= STEMTime.Units.WEEK.getMilliseconds()) {
                val = "days";
                this.xAxisPrimary.getTitle().setVisible(true);
                this.xAxisPrimary.getTitle().getCaption().setValue(val);
                return;
            }
            if (timeDelta < 4L * STEMTime.Units.WEEK.getMilliseconds()) {
                val = "weeks";
                this.xAxisPrimary.getTitle().setVisible(true);
                this.xAxisPrimary.getTitle().getCaption().setValue(val);
                return;
            }
            if (timeDelta < STEMTime.Units.YEAR.getMilliseconds()) {
                val = "months";
                this.xAxisPrimary.getTitle().setVisible(true);
                this.xAxisPrimary.getTitle().getCaption().setValue(val);
                return;
            }
            val = "years";
            this.xAxisPrimary.getTitle().setVisible(true);
            this.xAxisPrimary.getTitle().getCaption().setValue(val);
            return;
        }
    }

    public synchronized void setDataSourceAndRedraw(RelativeValueHistoryProviderAdapter rvhp, List<IItemPropertyDescriptor> propertiesToPlotList) {
        if (rvhp != this.rvhp) {
            this.rvhp = rvhp;
            for (IItemPropertyDescriptor ipd : propertiesToPlotList) {
                if (this.propertiesToPlot.containsKey(ipd)) continue;
                this.removeDataSeries();
                break;
            }
            this.propertiesToPlot = this.addProperties(propertiesToPlotList);
        }
        this.updateContextMenu((Composite)this);
        this.draw();
    }

    protected List<ItemPropertyDescriptor> filterPreferredProperties(List<ItemPropertyDescriptor> fullList) {
        ArrayList<ItemPropertyDescriptor> propertyList = new ArrayList<ItemPropertyDescriptor>();
        Set prefSet = VisualizationPreferencePage.getPreferenceSet();
        int i = 0;
        while (i < fullList.size()) {
            ItemPropertyDescriptor property = fullList.get(i);
            if (prefSet.contains(property.getDisplayName((Object)property))) {
                propertyList.add(property);
            }
            ++i;
        }
        if (propertyList.size() == 0) {
            propertyList.addAll(fullList);
        }
        return propertyList;
    }

    protected TreeMap<ItemPropertyDescriptor, Boolean> addProperties(List<IItemPropertyDescriptor> propertiesToPlotList) {
        int i = 0;
        while (i < propertiesToPlotList.size()) {
            ItemPropertyDescriptor property = (ItemPropertyDescriptor)propertiesToPlotList.get(i);
            if (!this.propertiesToPlot.containsKey(property)) {
                boolean visible = true;
                if (defaultHideSet.contains(property.getDisplayName((Object)property))) {
                    visible = false;
                }
                Boolean bObj = visible;
                this.propertiesToPlot.put(property, bObj);
            }
            ++i;
        }
        return this.propertiesToPlot;
    }

    public void dispose() {
        super.dispose();
    }

    protected void resetData() {
        this.clearData();
        if (this.dataSeriesMap.size() == 0) {
            DataSeries series = new DataSeries(defaultKey, this.seriesCount);
            this.dataSeriesMap.put(defaultKey, series);
        }
        this.cycleNumbers.add(0.0);
    }

    private void clearData() {
        Iterator<String> iter = this.dataSeriesMap.keySet().iterator();
        while (iter != null && iter.hasNext()) {
            String key = iter.next();
            DataSeries series = this.dataSeriesMap.get(key);
            series.relativeValues.clear();
            series.addValue(0, 0.0);
            this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.maxTimeAxisValue = 5;
            this.xAxisPrimary.getScale().setStep(1.0);
        }
        this.cycleNumbers.clear();
    }

    private void removeDataSeries() {
        if (this.displayableProperties != null) {
            this.displayableProperties.clear();
        }
        Iterator<ItemPropertyDescriptor> iter = this.propertiesToPlot.keySet().iterator();
        while (iter != null && iter.hasNext()) {
            ItemPropertyDescriptor propertyToRemove = iter.next();
            String key = propertyToRemove.getDisplayName((Object)propertyToRemove);
            DataSeries series = this.dataSeriesMap.get(key);
            if (series == null) continue;
            series.removeLineSeries(key);
            this.dataSeriesMap.remove(key);
            series = null;
        }
        this.propertiesToPlot.clear();
    }

    private void removeDataSeries(String key) {
        DataSeries series = this.dataSeriesMap.get(key);
        if (series != null) {
            series.removeLineSeries(key);
            this.dataSeriesMap.remove(key);
            series = null;
        }
    }

    void toggleAxisScale() {
        if (this.useLinearTimeScale) {
            this.logTimeAction.setChecked(true);
            this.linearTimeAction.setChecked(false);
            this.yAxisPrimary.getScale().setMin(null);
            this.yAxisPrimary.getScale().setMax(null);
            this.yAxisPrimary.getScale().unsetStep();
            this.yAxisPrimary.getScale().unsetStepNumber();
        } else {
            this.logTimeAction.setChecked(false);
            this.linearTimeAction.setChecked(true);
            this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
            this.yAxisPrimary.getScale().setStep(0.25);
        }
        this.useLinearTimeScale = !this.useLinearTimeScale;
        this.draw();
    }

    void toggleLegend() {
        if (this.showLegend) {
            this.viewLegend.setChecked(false);
            this.hideLegend.setChecked(true);
            this.legend.setVisible(false);
        } else {
            this.viewLegend.setChecked(true);
            this.hideLegend.setChecked(false);
            this.legend.setVisible(true);
        }
        this.showLegend = !this.showLegend;
        this.draw();
    }

    protected class ClearAction
    extends Action {
        public ClearAction() {
            super(Messages.getString("ContextMenu.Clear"), 1);
        }

        public String getText() {
            return Messages.getString("ContextMenu.Clear");
        }

        public void run() {
            for (ItemPropertyDescriptor ipd : TimeSeriesCanvas.this.propertiesToPlot.keySet()) {
                TimeSeriesCanvas.this.propertiesToPlot.put(ipd, false);
                for (DisplayableProperty dp : TimeSeriesCanvas.this.displayableProperties) {
                    if (!dp.getProperty().equals(ipd)) continue;
                    dp.setChecked(false);
                    break;
                }
                TimeSeriesCanvas.this.draw();
            }
        }
    }

    protected class DataSeries {
        public String propertyName = "";
        public List<Double> relativeValues = new ArrayList<Double>();
        public LineSeries lineSeries = null;
        private boolean visible = true;
        private SeriesDefinition sdY = null;
        private int seriesIndex = 0;

        public boolean isVisible() {
            return this.visible;
        }

        public DataSeries(String propertyName, int index) {
            this.propertyName = propertyName;
            this.seriesIndex = index;
            ++TimeSeriesCanvas.this.seriesCount;
            this.relativeValues = new ArrayList<Double>();
            this.relativeValues.add(0.0);
            this.addLineSeries(propertyName);
        }

        public void addValue(int cycle, Double val) {
            if (this.relativeValues == null) {
                this.relativeValues = new ArrayList<Double>();
            }
            if (cycle >= this.relativeValues.size()) {
                this.relativeValues.add(val);
            } else {
                this.relativeValues.set(cycle, val);
            }
        }

        public void addLineSeries(String propertyName) {
            NumberDataSet orthoValues = NumberDataSetImpl.create(this.relativeValues);
            if (this.lineSeries == null) {
                this.lineSeries = (ScatterSeries)ScatterSeriesImpl.create();
            }
            this.lineSeries.setDataSet((DataSet)orthoValues);
            this.lineSeries.getLineAttributes().setVisible(true);
            if (!this.lineSeries.getMarkers().isEmpty()) {
                Marker marker = (Marker)this.lineSeries.getMarkers().get(0);
                marker.setVisible(false);
            }
            this.sdY = SeriesDefinitionImpl.create();
            this.sdY.getSeries().add((Object)this.lineSeries);
            TimeSeriesCanvas.this.yAxisPrimary.getSeriesDefinitions().add((Object)this.sdY);
            TimeSeriesCanvas.this.setTimeLabel();
            this.setColorDefs(propertyName);
        }

        public void removeLineSeries(String propertyName) {
            this.seriesIndex = 0;
            if (this.lineSeries != null) {
                this.lineSeries.getLineAttributes().setVisible(false);
            }
            if (TimeSeriesCanvas.this.yAxisPrimary != null) {
                TimeSeriesCanvas.this.yAxisPrimary.getSeriesDefinitions().remove((Object)this.sdY);
            }
            if (this.sdY != null) {
                this.sdY.getSeries().remove((Object)this.lineSeries);
            }
            this.lineSeries = null;
            this.sdY = null;
        }

        public void hide() {
            this.lineSeries.setVisible(false);
            this.visible = false;
        }

        public void show() {
            this.lineSeries.setVisible(true);
            this.visible = true;
        }

        private void setColorDefs(String propertyName) {
            Object color;
            this.lineSeries.setSeriesIdentifier((Object)propertyName);
            this.lineSeries.setPaletteLineColor(false);
            Map colorMap = VisualizationPreferencePage.getColorMapping();
            boolean colorSet = false;
            if (colorMap != null && colorMap.size() >= 1 && propertyName != null && propertyName.length() >= 1) {
                if (colorMap.containsKey(propertyName)) {
                    STEMColor c = (STEMColor)colorMap.get(propertyName);
                    color = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                    this.lineSeries.getLineAttributes().setColor((ColorDefinition)color);
                    colorSet = true;
                } else {
                    for (String key : colorMap.keySet()) {
                        if (key.length() < 1 || !propertyName.substring(0, 1).equalsIgnoreCase(key.substring(0, 1))) continue;
                        STEMColor c = (STEMColor)colorMap.get(key);
                        ColorDefinition color2 = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                        this.lineSeries.getLineAttributes().setColor(color2);
                        colorSet = true;
                        break;
                    }
                }
            }
            if (!colorSet) {
                int colorIndex = this.seriesIndex % TimeSeriesCanvas.this.colorDefault.length;
                color = TimeSeriesCanvas.this.colorDefault[colorIndex];
                this.lineSeries.getLineAttributes().setColor((ColorDefinition)color);
            }
        }

        public int getDataSize() {
            return this.relativeValues.size();
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public List<Double> getRelativeValues() {
            return this.relativeValues;
        }

        public void setRelativeValues(List<Double> relativeValues) {
            this.relativeValues = relativeValues;
        }

        public LineSeries getLineSeries() {
            return this.lineSeries;
        }

        public void setLineSeries(LineSeries lineSeries) {
            this.lineSeries = lineSeries;
        }
    }

    protected class DisplayableProperty
    extends Action {
        ItemPropertyDescriptor property;

        public DisplayableProperty(ItemPropertyDescriptor property) {
            super(property.getDisplayName((Object)property), 2);
            this.property = null;
            this.property = property;
            if (TimeSeriesCanvas.this.propertiesToPlot.containsKey(property)) {
                this.setChecked(TimeSeriesCanvas.this.propertiesToPlot.get(property));
            } else {
                TimeSeriesCanvas.this.propertiesToPlot.put(property, true);
                this.setChecked(TimeSeriesCanvas.this.propertiesToPlot.get(property));
            }
        }

        public String getText() {
            return this.property.getDisplayName((Object)this.property);
        }

        public void run() {
            boolean state = TimeSeriesCanvas.this.propertiesToPlot.get(this.property) == false;
            TimeSeriesCanvas.this.propertiesToPlot.put(this.property, state);
            this.setChecked(state);
            TimeSeriesCanvas.this.draw();
        }

        public ItemPropertyDescriptor getProperty() {
            return this.property;
        }
    }

    class LegendHideAction
    extends Action {
        public LegendHideAction() {
            super(Messages.getString("ContextMenu.HideLegend"), 2);
            this.setChecked(!TimeSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.HideLegend");
        }

        public void run() {
            if (!TimeSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleLegend();
            }
        }
    }

    protected class LegendViewAction
    extends Action {
        public LegendViewAction() {
            super(Messages.getString("ContextMenu.ShowLegend"), 2);
            this.setChecked(TimeSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.ShowLegend");
        }

        public void run() {
            if (TimeSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleLegend();
            }
        }
    }

    protected class LinearScaleAction
    extends Action {
        public LinearScaleAction() {
            super(Messages.getString("ContextMenu.LinearTimeScale"), 2);
            this.setChecked(TimeSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LinearTimeScale");
        }

        public void run() {
            if (TimeSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleAxisScale();
            }
        }
    }

    class LogScaleAction
    extends Action {
        public LogScaleAction() {
            super(Messages.getString("ContextMenu.LogTimeScale"), 2);
            this.setChecked(!TimeSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LogTimeScale");
        }

        public void run() {
            if (!TimeSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleAxisScale();
            }
        }
    }
}

