/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.Messages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class PhaseSpaceCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    private RelativeValueHistoryProvider rvhp;
    private ItemPropertyDescriptor propertyToPlotX;
    private ItemPropertyDescriptor propertyToPlotY;
    private final List<Double> relativeValuesX = new ArrayList<Double>();
    private final List<Double> relativeValuesY = new ArrayList<Double>();
    private double minLogScaleValue = 1.0;
    Generator gr = Generator.instance();
    private Axis xAxisPrimary;
    private Axis yAxisPrimary;
    private static String defaultAxisLabel_Y = "Y Axis";
    private static String defaultAxisLabel_X = "X Axis";
    boolean useLinearScales = true;
    private LinearScalesAction linearScalesAction;
    private LogarithmicScalesAction logTimeScalesAction;
    private String xAxisLabel;
    private String yAxisLabel;
    Image imgChart = null;

    public PhaseSpaceCanvas(Composite parent) {
        super(parent, 0x20000800);
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            Activator.logError("Problem initializing chart", pex);
            return;
        }
        this.resetData();
        this.cm = this.createPhaseSpaceLineChart(this.relativeValuesX, this.relativeValuesY, Messages.getString("PH.title"));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                Composite source = (Composite)pe.getSource();
                Rectangle d = source.getClientArea();
                if (PhaseSpaceCanvas.this.imgChart != null) {
                    PhaseSpaceCanvas.this.imgChart.dispose();
                }
                PhaseSpaceCanvas.this.imgChart = new Image((Device)source.getDisplay(), d);
                PhaseSpaceCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)PhaseSpaceCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)d.x, (double)d.y, (double)d.width, (double)d.height);
                bounds.scale(72.0 / (double)PhaseSpaceCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    PhaseSpaceCanvas.this.gr.render(PhaseSpaceCanvas.this.idr, PhaseSpaceCanvas.this.gr.build(PhaseSpaceCanvas.this.idr.getDisplayServer(), PhaseSpaceCanvas.this.cm, bounds, null, null, null));
                    pe.gc.drawImage(PhaseSpaceCanvas.this.imgChart, d.x, d.y);
                }
                catch (ChartException ce) {
                    Activator.logError("Problem rendering chart", ce);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public void draw() {
        if (this.rvhp != null) {
            double denom = this.rvhp.getDenominator(null);
            if (denom <= 0.0) {
                denom = 1.0;
            }
            this.minLogScaleValue = 0.5 / denom;
            if (this.propertyToPlotX == null || this.propertyToPlotY == null) {
                return;
            }
            STEMTime[] time = this.rvhp.getAllHistoricTimeValues();
            double[] relativeValuesX = this.rvhp.getHistoricInstances(this.propertyToPlotX, time);
            double[] relativeValuesY = this.rvhp.getHistoricInstances(this.propertyToPlotY, time);
            if (relativeValuesX.length > 0 && relativeValuesY.length > 0) {
                this.clearData();
                int cycleNumber = 0;
                while (cycleNumber < relativeValuesX.length) {
                    Double valueX = null;
                    Double valueY = null;
                    double displayValueX = relativeValuesX[cycleNumber];
                    double displayValueY = relativeValuesY[cycleNumber];
                    if (displayValueX <= this.minLogScaleValue) {
                        displayValueX = this.minLogScaleValue;
                    }
                    if (displayValueY <= this.minLogScaleValue) {
                        displayValueY = this.minLogScaleValue;
                    }
                    if (this.useLinearScales) {
                        valueX = displayValueX;
                        valueY = displayValueY;
                    } else {
                        valueX = Math.log(displayValueX);
                        valueY = Math.log(displayValueY);
                    }
                    this.relativeValuesX.add(valueX);
                    this.relativeValuesY.add(valueY);
                    ++cycleNumber;
                }
            } else {
                this.resetData();
            }
            if (!this.isDisposed()) {
                this.redraw();
            }
        }
    }

    private void createContextMenu(Composite parent) {
        MenuManager contextMenuManager = new MenuManager();
        this.linearScalesAction = new LinearScalesAction();
        this.logTimeScalesAction = new LogarithmicScalesAction();
        contextMenuManager.add((IAction)this.linearScalesAction);
        contextMenuManager.add((IAction)this.logTimeScalesAction);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        Menu popUpMenu = contextMenuManager.createContextMenu((Control)parent);
        parent.setMenu(popUpMenu);
    }

    public final Chart createPhaseSpaceLineChart(List<Double> relativeValuesX, List<Double> relativeValuesY, String seriesIdentifier) {
        ChartWithAxes retValue = ChartWithAxesImpl.create();
        defaultAxisLabel_X = Messages.getString("XAXISDEF.title");
        defaultAxisLabel_Y = Messages.getString("YAXISDEF.title");
        retValue.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Plot p = retValue.getPlot();
        p.getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        retValue.getTitle().setVisible(false);
        Legend lg = retValue.getLegend();
        lg.setVisible(false);
        this.xAxisPrimary = retValue.getPrimaryBaseAxes()[0];
        this.xAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        this.xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxisPrimary.getTitle().getCaption().getFont().setSize(8.0f);
        this.xAxisLabel = defaultAxisLabel_X;
        if (this.propertyToPlotX != null) {
            this.xAxisLabel = this.propertyToPlotX.getDisplayName((Object)this.propertyToPlotX);
        }
        this.xAxisPrimary.getTitle().getCaption().setValue(this.xAxisLabel);
        this.xAxisPrimary.getTitle().setVisible(true);
        this.yAxisPrimary = retValue.getPrimaryOrthogonalAxis(this.xAxisPrimary);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.yAxisPrimary.getTitle().getCaption().getFont().setSize(8.0f);
        this.yAxisLabel = defaultAxisLabel_Y;
        if (this.propertyToPlotY != null) {
            this.yAxisLabel = this.propertyToPlotY.getDisplayName((Object)this.propertyToPlotY);
        }
        this.yAxisPrimary.getTitle().getCaption().setValue(this.yAxisLabel);
        this.yAxisPrimary.getTitle().setVisible(true);
        NumberDataSet orthoValuesX = NumberDataSetImpl.create(relativeValuesX);
        NumberDataSet orthoValuesY = NumberDataSetImpl.create(relativeValuesY);
        Series lsx = SeriesImpl.create();
        lsx.setDataSet((DataSet)orthoValuesX);
        ScatterSeries lsy = (ScatterSeries)ScatterSeriesImpl.create();
        lsy.setDataSet((DataSet)orthoValuesY);
        lsy.getLineAttributes().setVisible(true);
        lsy.setPaletteLineColor(false);
        lsy.getLineAttributes().setColor(ColorDefinitionImpl.BLUE());
        lsy.setSeriesIdentifier((Object)seriesIdentifier);
        if (!lsy.getMarkers().isEmpty()) {
            Marker marker = (Marker)lsy.getMarkers().get(0);
            marker.setVisible(false);
        }
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        sdX.setSorting(SortOption.ASCENDING_LITERAL);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.setSorting(SortOption.ASCENDING_LITERAL);
        sdY.getSeriesPalette().update(-2);
        this.xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        this.xAxisPrimary.setCategoryAxis(false);
        this.yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdX.getSeries().add((Object)lsx);
        sdY.getSeries().add((Object)lsy);
        this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.xAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.xAxisPrimary.getScale().setStep(0.25);
        this.xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.yAxisPrimary.getScale().setStep(0.25);
        this.yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        return retValue;
    }

    public void setDataSourceAndRedraw(RelativeValueHistoryProviderAdapter rvhp, ItemPropertyDescriptor propertyToPlotX, ItemPropertyDescriptor propertyToPlotY) {
        this.rvhp = rvhp;
        this.propertyToPlotX = propertyToPlotX;
        this.propertyToPlotY = propertyToPlotY;
        this.xAxisLabel = defaultAxisLabel_X;
        if (propertyToPlotX != null) {
            this.xAxisLabel = this.propertyToPlotX.getDisplayName((Object)propertyToPlotX);
            if (!this.useLinearScales) {
                this.xAxisLabel = "Log(" + this.xAxisLabel + ")";
            }
        }
        this.xAxisPrimary.getTitle().getCaption().setValue(this.xAxisLabel);
        this.xAxisPrimary.getTitle().setVisible(true);
        this.yAxisPrimary.getTitle().getCaption().getFont().setSize(8.0f);
        this.yAxisLabel = defaultAxisLabel_Y;
        if (propertyToPlotY != null) {
            this.yAxisLabel = this.propertyToPlotY.getDisplayName((Object)propertyToPlotY);
            if (!this.useLinearScales) {
                this.yAxisLabel = "Log(" + this.yAxisLabel + ")";
            }
        }
        this.yAxisPrimary.getTitle().getCaption().setValue(this.yAxisLabel);
        this.yAxisPrimary.getTitle().setVisible(true);
        this.draw();
    }

    public void setRelativeValueHistoryProvider(RelativeValueHistoryProvider rvhp) {
        this.rvhp = rvhp;
    }

    public final ItemPropertyDescriptor getPropertyToPlotX() {
        return this.propertyToPlotX;
    }

    public final ItemPropertyDescriptor getPropertyToPlotY() {
        return this.propertyToPlotY;
    }

    public final void setPropertyToPlotX(ItemPropertyDescriptor propertyToPlotX) {
        this.propertyToPlotX = propertyToPlotX;
    }

    public final void setPropertyToPlotY(ItemPropertyDescriptor propertyToPlotY) {
        this.propertyToPlotY = propertyToPlotY;
    }

    public void dispose() {
        super.dispose();
    }

    public void reset() {
        this.resetData();
        this.rvhp = null;
        this.redraw();
    }

    protected void resetData() {
        this.clearData();
        this.relativeValuesX.add(1.0);
        this.relativeValuesY.add(0.0);
    }

    private void clearData() {
        this.relativeValuesX.clear();
        this.relativeValuesY.clear();
    }

    void toggleScales() {
        if (this.useLinearScales) {
            this.logTimeScalesAction.setChecked(true);
            this.linearScalesAction.setChecked(false);
            this.xAxisPrimary.getScale().setMin(null);
            this.xAxisPrimary.getScale().setMax(null);
            this.xAxisPrimary.getScale().unsetStep();
            this.xAxisPrimary.getScale().unsetStepNumber();
            this.xAxisPrimary.getTitle().getCaption().setValue("Log(" + this.xAxisLabel + ")");
            this.yAxisPrimary.getScale().setMin(null);
            this.yAxisPrimary.getScale().setMax(null);
            this.yAxisPrimary.getScale().unsetStep();
            this.yAxisPrimary.getScale().unsetStepNumber();
            this.yAxisPrimary.getTitle().getCaption().setValue("Log(" + this.yAxisLabel + ")");
        } else {
            this.logTimeScalesAction.setChecked(false);
            this.linearScalesAction.setChecked(true);
            this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.xAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
            this.xAxisPrimary.getScale().setStep(0.25);
            this.xAxisPrimary.getTitle().getCaption().setValue(this.xAxisLabel);
            this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
            this.yAxisPrimary.getScale().setStep(0.25);
            this.yAxisPrimary.getTitle().getCaption().setValue(this.yAxisLabel);
        }
        this.useLinearScales = !this.useLinearScales;
        this.redraw();
    }

    protected class LinearScalesAction
    extends Action {
        public LinearScalesAction() {
            super(Messages.getString("ContextMenu.LinearScaling"), 2);
            this.setChecked(PhaseSpaceCanvas.this.useLinearScales);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LinearScaling");
        }

        public void run() {
            if (PhaseSpaceCanvas.this.useLinearScales) {
                this.setChecked(true);
            } else {
                PhaseSpaceCanvas.this.toggleScales();
            }
        }
    }

    class LogarithmicScalesAction
    extends Action {
        public LogarithmicScalesAction() {
            super(Messages.getString("ContextMenu.LogScaling"), 2);
            this.setChecked(!PhaseSpaceCanvas.this.useLinearScales);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LogScaling");
        }

        public void run() {
            if (!PhaseSpaceCanvas.this.useLinearScales) {
                this.setChecked(true);
            } else {
                PhaseSpaceCanvas.this.toggleScales();
            }
        }
    }
}

