/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.AggregateFileInitializationException;

public class AggregateReferenceFileLoader {
    private String dataFile = "";
    private static final String CSV_EXTENSION = ".csv";
    private static final String TXT_EXTENSION = ".txt";
    private List<Double> aggregateData = new ArrayList<Double>();
    private Set<String> idSet = new HashSet<String>();
    private File scenarioData = null;
    private static final String[] ignoreKeys = new String[]{"time", "iteration"};

    public AggregateReferenceFileLoader(String scenarioFile) throws AggregateFileInitializationException {
        this.dataFile = scenarioFile;
        this.scenarioData = new File(this.dataFile);
        if (this.dataFile != null && this.dataFile.length() >= 1) {
            if (!this.isDataFile(this.scenarioData)) {
                throw new AggregateFileInitializationException("Not a valid data file, must be .csv or .txt " + this.dataFile);
            }
            this.aggregateData = this.processFile();
        }
    }

    private boolean isDataFile(File file) {
        boolean retVal = true;
        String name = file.getName();
        if (name.indexOf(TXT_EXTENSION) < 0 && name.indexOf(CSV_EXTENSION) < 0) {
            retVal = false;
        }
        return retVal;
    }

    public List<Double> processFile() throws AggregateFileInitializationException {
        int maxTime = 0;
        HashMap<String, List> data = new HashMap<String, List>();
        BufferedReader reader = null;
        try {
            try {
                String record;
                ArrayList<String> headerElements = new ArrayList<String>();
                reader = new BufferedReader(new FileReader(this.scenarioData));
                String header = reader.readLine();
                if (header != null) {
                    StringTokenizer st = new StringTokenizer(header);
                    while (st.hasMoreTokens()) {
                        String val = st.nextToken(",");
                        headerElements.add(val.trim());
                    }
                }
                int numColumns = headerElements.size();
                int i = 0;
                while (i < numColumns) {
                    String key = (String)headerElements.get(i);
                    if (this.validate(key)) {
                        data.put(key, new ArrayList());
                    }
                    ++i;
                }
                while ((record = reader.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(record);
                    int tcount = 0;
                    while (st.hasMoreTokens()) {
                        String val = st.nextToken(",");
                        String key = (String)headerElements.get(tcount);
                        if (this.validate(key)) {
                            this.idSet.add(key);
                            List dataList = (List)data.get(key);
                            try {
                                Double dVal = Double.valueOf(val.trim());
                                dataList.add(dVal);
                                if (dataList.size() >= maxTime) {
                                    maxTime = dataList.size();
                                }
                                data.put(key, dataList);
                            }
                            catch (NumberFormatException nfe) {
                                data.remove(key);
                                this.idSet.remove(key);
                                Activator.logInformation("Not a valid number (" + val + ") ... Removing key " + key, null);
                            }
                        }
                        ++tcount;
                    }
                }
            }
            catch (IOException e) {
                Activator.logError(" IOException error!", e);
                throw new AggregateFileInitializationException(e);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        ArrayList<Double> aggregate = new ArrayList<Double>();
        int i = 0;
        while (i < maxTime) {
            aggregate.add(i, 0.0);
            ++i;
        }
        Iterator<String> iter = this.idSet.iterator();
        while (iter != null && iter.hasNext()) {
            String key = iter.next();
            List dataList = (List)data.get(key);
            int i2 = 0;
            while (i2 < maxTime) {
                double val = (Double)aggregate.get(i2);
                aggregate.set(i2, val += ((Double)dataList.get(i2)).doubleValue());
                ++i2;
            }
        }
        return aggregate;
    }

    public Map<String, List<String>> processIncidenceFile(String fileName) throws AggregateFileInitializationException {
        File file = new File(fileName);
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        BufferedReader reader = null;
        try {
            try {
                String record;
                ArrayList<String> headerElements = new ArrayList<String>();
                reader = new BufferedReader(new FileReader(file));
                String header = reader.readLine();
                if (header != null) {
                    StringTokenizer st = new StringTokenizer(header);
                    while (st.hasMoreTokens()) {
                        String val = st.nextToken(",");
                        headerElements.add(val.trim());
                    }
                }
                int numColumns = headerElements.size();
                int i = 0;
                while (i < numColumns) {
                    String key = (String)headerElements.get(i);
                    data.put(key, new ArrayList());
                    ++i;
                }
                while ((record = reader.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(record);
                    int tcount = 0;
                    while (st.hasMoreTokens()) {
                        String val = st.nextToken(",");
                        String key = (String)headerElements.get(tcount);
                        data.get(key).add(val.trim());
                        ++tcount;
                    }
                }
            }
            catch (IOException e) {
                Activator.logError(" IOException error!", e);
                throw new AggregateFileInitializationException(e);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return data;
    }

    private boolean validate(String key) {
        int i = 0;
        while (i < ignoreKeys.length) {
            String test = key.trim();
            if (test.equalsIgnoreCase(ignoreKeys[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static boolean EOF(String buffer) {
        return buffer == null || buffer.length() == 0;
    }

    public List<Double> getAggregateData() {
        return this.aggregateData;
    }

    public Set<String> getIdSet() {
        return this.idSet;
    }
}

