/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ResourceModelTraversalCalculator {
    public static final String PROP_TRAVERSAL_CALCULATOR = "org.eclipse.team.ui.resourceModelTraversalCalculator";
    private static ResourceModelTraversalCalculator instance;
    private final ISynchronizePageConfiguration configuration;

    public ResourceModelTraversalCalculator(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
    }

    public ResourceModelTraversalCalculator() {
        this.configuration = null;
    }

    public int getLayoutDepth(IResource resource, TreePath path) {
        if (this.isFlatPageLayout()) {
            return resource instanceof IWorkspaceRoot ? 2 : 0;
        }
        if (resource.getType() == 4) {
            return 2;
        }
        if (resource.getType() == 1) {
            return 0;
        }
        if (path != null && this.hasNonResource(path)) {
            return 2;
        }
        if (this.getLayout().equals("org.eclipse.team.ui.flay_layout")) {
            return 0;
        }
        if (this.getLayout().equals("org.eclipse.team.ui.compressed_layout")) {
            return 1;
        }
        return 2;
    }

    public String getLayout() {
        return TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.default_layout");
    }

    public Object[] filterChildren(IResourceDiffTree diffTree, IResource resource, Object parentOrPath, Object[] children) {
        TreePath tp;
        if (parentOrPath instanceof TreePath && this.hasNonResource(tp = (TreePath)parentOrPath)) {
            return this.getTreeChildren(diffTree, resource, children);
        }
        if (this.isFlatPageLayout()) {
            if (resource instanceof IWorkspaceRoot) {
                return diffTree.getAffectedResources();
            }
            return new Object[0];
        }
        if (this.getLayout().equals("org.eclipse.team.ui.flay_layout") && resource.getType() == 4) {
            return this.getFlatChildren(diffTree, resource);
        }
        if (this.getLayout().equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 4) {
            return this.getCompressedChildren(diffTree, (IProject)resource, children);
        }
        if (this.getLayout().equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 2) {
            return this.getCompressedChildren(diffTree, (IFolder)resource, children);
        }
        return this.getTreeChildren(diffTree, resource, children);
    }

    private boolean hasNonResource(TreePath parentPath) {
        int i = 0;
        while (i < parentPath.getSegmentCount()) {
            Object o = parentPath.getSegment(i);
            if (!(o instanceof IResource || o instanceof ModelProvider || o instanceof ChangeSet)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Object[] getCompressedChildren(IResourceDiffTree diffTree, IProject project, Object[] children) {
        IDiff[] diffs;
        HashSet<Object> result = new HashSet<Object>();
        IDiff[] iDiffArray = diffs = diffTree.getDiffs((IResource)project, 2);
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff diff = iDiffArray[n2];
            IResource resource = diffTree.getResource(diff);
            if (resource.getType() == 1) {
                IContainer parent = resource.getParent();
                if (parent.getType() == 2) {
                    result.add(parent);
                } else {
                    result.add(resource);
                }
            } else if (resource.getType() == 2) {
                result.add(resource);
            }
            ++n2;
        }
        return result.toArray();
    }

    private Object[] getCompressedChildren(IResourceDiffTree diffTree, IFolder folder, Object[] children) {
        IDiff[] diffs;
        HashSet<IResource> result = new HashSet<IResource>();
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            Object object = objectArray[n2];
            if (object instanceof IResource && (resource = (IResource)object).getType() == 1) {
                result.add(resource);
            }
            ++n2;
        }
        IDiff[] iDiffArray = diffs = diffTree.getDiffs((IResource)folder, 1);
        int n3 = diffs.length;
        n = 0;
        while (n < n3) {
            IDiff diff = iDiffArray[n];
            IResource resource = diffTree.getResource(diff);
            if (resource.getType() == 1) {
                result.add(resource);
            }
            ++n;
        }
        return result.toArray();
    }

    private Object[] getFlatChildren(IResourceDiffTree diffTree, IResource resource) {
        IDiff[] diffs = diffTree.getDiffs(resource, 2);
        ArrayList<IResource> result = new ArrayList<IResource>();
        IDiff[] iDiffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff diff = iDiffArray[n2];
            result.add(diffTree.getResource(diff));
            ++n2;
        }
        Object[] allChildren = result.toArray();
        return allChildren;
    }

    private Object[] getTreeChildren(IResourceDiffTree diffTree, IResource resource, Object[] children) {
        HashSet result = new HashSet();
        Collections.addAll(result, children);
        IResource[] setChildren = ResourceModelTraversalCalculator.getChildren(diffTree, resource);
        Collections.addAll(result, setChildren);
        Object[] allChildren = result.toArray(new Object[result.size()]);
        return allChildren;
    }

    public static IResource[] getChildren(IResourceDiffTree diffTree, IResource resource) {
        IPath[] childPaths;
        HashSet<IResource> result = new HashSet<IResource>();
        IPath[] iPathArray = childPaths = diffTree.getChildren(resource.getFullPath());
        int n = childPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            IDiff delta = diffTree.getDiff(path);
            Object child = delta == null ? (path.segmentCount() == 1 ? ((IWorkspaceRoot)resource).getProject(path.lastSegment()) : ((IContainer)resource).getFolder((IPath)new Path(path.lastSegment()))) : diffTree.getResource(delta);
            result.add((IResource)child);
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public ResourceTraversal[] getTraversals(DiffChangeSet dcs, TreePath tp) {
        IResource[] resources = this.getResource(dcs, tp);
        return new ResourceTraversal[]{new ResourceTraversal(resources, 0, 0)};
    }

    private IResource[] getResource(DiffChangeSet dcs, TreePath tp) {
        if (tp.getSegmentCount() == 1 && tp.getFirstSegment() == dcs) {
            return dcs.getResources();
        }
        HashSet<IResource> result = new HashSet<IResource>();
        Object o = tp.getLastSegment();
        if (o instanceof IResource) {
            IDiff[] diffs;
            IResource resource = (IResource)o;
            int depth = this.getLayoutDepth(resource, tp);
            IDiff[] iDiffArray = diffs = dcs.getDiffTree().getDiffs(resource, depth);
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                IDiff diff = iDiffArray[n2];
                IResource r = ResourceDiffTree.getResourceFor((IDiff)diff);
                if (r != null) {
                    result.add(r);
                }
                ++n2;
            }
        }
        return result.toArray(new IResource[result.size()]);
    }

    public ResourceTraversal[] getTraversals(IResource resource, TreePath tp) {
        return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{resource}, this.getLayoutDepth(resource, tp), 0)};
    }

    public boolean isResourcePath(TreePath path) {
        int i = 0;
        while (i < path.getSegmentCount()) {
            Object o = path.getSegment(i);
            if (!(o instanceof IResource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getLabel(Object elementOrPath) {
        if (elementOrPath instanceof TreePath && this.hasNonResource((TreePath)elementOrPath)) {
            return null;
        }
        Object element = this.internalGetElement(elementOrPath);
        Object parent = this.internalGetElementParent(elementOrPath);
        if (element instanceof IResource) {
            IPath parentPath;
            IPath path;
            IResource resource = (IResource)element;
            if (this.isFlatPageLayout() && !(path = resource.getFullPath()).isEmpty()) {
                return NLS.bind((String)TeamUIMessages.ResourceModelLabelProvider_0, (Object)resource.getName(), (Object)path.toString());
            }
            if (this.getLayout().equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 2 && (parent == null || parent instanceof IProject)) {
                return resource.getProjectRelativePath().toString();
            }
            if (this.getLayout().equals("org.eclipse.team.ui.flay_layout") && resource.getType() == 1 && (parent == null || parent instanceof IProject) && !(parentPath = resource.getProjectRelativePath().removeLastSegments(1)).isEmpty()) {
                return NLS.bind((String)TeamUIMessages.ResourceModelLabelProvider_0, (Object)resource.getName(), (Object)parentPath.toString());
            }
        }
        return null;
    }

    public boolean isCompressedFolder(Object elementOrPath) {
        if (elementOrPath instanceof TreePath && this.hasNonResource((TreePath)elementOrPath)) {
            return false;
        }
        Object element = this.internalGetElement(elementOrPath);
        Object parent = this.internalGetElementParent(elementOrPath);
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return this.getLayout().equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 2 && (parent == null || parent instanceof IProject);
        }
        return false;
    }

    private TreePath internalGetPath(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            return (TreePath)elementOrPath;
        }
        return null;
    }

    private Object internalGetElement(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)elementOrPath;
            return tp.getLastSegment();
        }
        return elementOrPath;
    }

    private Object internalGetElementParent(Object elementOrPath) {
        TreePath tp;
        if (elementOrPath instanceof TreePath && (tp = (TreePath)elementOrPath).getSegmentCount() > 1) {
            return tp.getSegment(tp.getSegmentCount() - 2);
        }
        return null;
    }

    public boolean hasChildren(ISynchronizationContext context, Object elementOrPath) {
        Object element = this.internalGetElement(elementOrPath);
        if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            if (context != null) {
                int depth = this.getLayoutDepth((IResource)container, this.internalGetPath(elementOrPath));
                if (depth == 0) {
                    return false;
                }
                IResourceDiffTree tree = context.getDiffTree();
                IResource[] members = tree.members((IResource)container);
                if (members.length > 0) {
                    if (depth == 2) {
                        return true;
                    }
                    IResource[] iResourceArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if (resource.getType() == 1) {
                            return true;
                        }
                        ++n2;
                    }
                }
            }
        }
        return false;
    }

    public TreePath getParentPath(ISynchronizationContext context, ModelProvider provider, Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            TreePath treePath = this.getProviderRootPath(context, provider);
            if (resource.getType() == 8) {
                return null;
            }
            if (resource.getType() == 4) {
                return treePath;
            }
            if (this.getLayout().equals("org.eclipse.team.ui.flay_layout")) {
                return treePath.createChildPath((Object)resource.getProject());
            }
            if (this.getLayout().equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 2) {
                return treePath.createChildPath((Object)resource.getProject());
            }
            if (this.getLayout().equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 1) {
                if (resource.getParent().getType() == 4) {
                    return treePath.createChildPath((Object)resource.getProject());
                }
                return treePath.createChildPath((Object)resource.getProject()).createChildPath((Object)resource.getParent());
            }
            IContainer parent = resource.getParent();
            IResource[] resourcePath = new IResource[parent.getFullPath().segmentCount()];
            int i = resourcePath.length - 1;
            while (i >= 0) {
                resourcePath[i] = parent;
                parent = parent.getParent();
                --i;
            }
            IResource[] iResourceArray = resourcePath;
            int n = resourcePath.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                treePath = treePath.createChildPath((Object)r);
                ++n2;
            }
            return treePath;
        }
        return null;
    }

    private TreePath getProviderRootPath(ISynchronizationContext context, ModelProvider provider) {
        if (context == null) {
            return TreePath.EMPTY.createChildPath((Object)provider);
        }
        return TreePath.EMPTY;
    }

    private boolean isFlatPageLayout() {
        if (this.configuration != null) {
            String p = (String)this.configuration.getProperty("org.eclipse.team.ui.pageLayout");
            return p != null && p.equals("org.eclipse.team.ui.flatLayout");
        }
        return false;
    }

    public static synchronized ResourceModelTraversalCalculator getDefault() {
        if (instance == null) {
            instance = new ResourceModelTraversalCalculator();
        }
        return instance;
    }

    public static synchronized ResourceModelTraversalCalculator getTraversalCalculator(ISynchronizePageConfiguration configuration) {
        if (configuration == null) {
            return ResourceModelTraversalCalculator.getDefault();
        }
        ResourceModelTraversalCalculator tc = (ResourceModelTraversalCalculator)configuration.getProperty(PROP_TRAVERSAL_CALCULATOR);
        if (tc == null) {
            tc = new ResourceModelTraversalCalculator(configuration);
            configuration.setProperty(PROP_TRAVERSAL_CALCULATOR, tc);
        }
        return tc;
    }
}

