/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.logger.Logger;
import org.eclipse.stem.ui.loggers.Activator;
import org.eclipse.stem.ui.wizards.LoggerPropertyComposite;
import org.eclipse.stem.ui.wizards.LoggerWizardMessages;
import org.eclipse.stem.ui.wizards.NewLoggerWizard;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LoggerDefinitionControl
extends Composite {
    private static Logger[] loggers = null;
    private final Combo combo;
    private final LoggerPropertyComposite loggerPropertyComposite;
    private NewLoggerWizard newLoggerWizard = null;

    public LoggerDefinitionControl(Composite parent, int style, ModifyListener projectValidator, IProject project, NewLoggerWizard nlw) {
        super(parent, style);
        this.newLoggerWizard = nlw;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label loggerLabel = new Label((Composite)this, 0);
        GridData gd_loggerLabel = new GridData(4, 0x1000000, true, false);
        gd_loggerLabel.widthHint = 100;
        loggerLabel.setLayoutData((Object)gd_loggerLabel);
        loggerLabel.setText(LoggerWizardMessages.getString("LDC_Type"));
        this.combo = new Combo((Composite)this, 8);
        this.combo.setTextLimit(30);
        GridData gd_combo = new GridData(4, 0x1000000, true, false);
        gd_combo.widthHint = 303;
        this.combo.setLayoutData((Object)gd_combo);
        this.combo.setToolTipText(LoggerWizardMessages.getString("LDC_TypeTT"));
        this.combo.setItems(this.getLoggerNames(this.getLoggers()));
        this.combo.select(0);
        this.combo.addModifyListener(projectValidator);
        this.loggerPropertyComposite = new LoggerPropertyComposite(this, 0, this.getLoggers(), projectValidator, project);
        GridData gd_diseaseModelPropertyControl = new GridData(4, 0x1000000, true, false, 2, 1);
        this.loggerPropertyComposite.setLayoutData(gd_diseaseModelPropertyControl);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerDefinitionControl.this.loggerPropertyComposite.displayLogger(LoggerDefinitionControl.this.getLoggers()[LoggerDefinitionControl.this.combo.getSelectionIndex()]);
                LoggerDefinitionControl.this.newLoggerWizard.newDublinCorePage.updateDublinCorePage(LoggerDefinitionControl.this.getSelectedLogger().getDublinCore());
            }
        });
    }

    private Logger[] getLoggers() {
        if (loggers == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] loggerConfigElements = registry.getConfigurationElementsFor("org.eclipse.stem.core.logger");
            ArrayList<Logger> temp = new ArrayList<Logger>();
            loggers = new Logger[loggerConfigElements.length];
            IConfigurationElement[] iConfigurationElementArray = loggerConfigElements;
            int n = loggerConfigElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                Logger logger = null;
                if (element.getName().equals("classdef")) {
                    try {
                        logger = (Logger)element.createExecutableExtension("class");
                        temp.add(logger);
                    }
                    catch (CoreException e) {
                        Activator.logError(LoggerWizardMessages.getString("LDC_CreateError"), e);
                    }
                }
                ++n2;
            }
            loggers = temp.toArray(new Logger[0]);
        }
        Logger[] loggerArray = loggers;
        int n = loggers.length;
        int n3 = 0;
        while (n3 < n) {
            DublinCore dublinCore;
            Logger logger = loggerArray[n3];
            if (loggers != null && (dublinCore = Activator.getPluginDublinCore(logger)) != null) {
                logger.setDublinCore(dublinCore);
            }
            ++n3;
        }
        return loggers;
    }

    private String[] getLoggerNames(Logger[] loggers) {
        String[] retValue = new String[loggers.length];
        int i = 0;
        while (i < loggers.length) {
            String name = loggers[i].getDublinCore().getTitle();
            if (name == null || name.equals("")) {
                name = loggers[i].getClass().getSimpleName();
            }
            retValue[i] = name;
            ++i;
        }
        return retValue;
    }

    Logger getSelectedLogger() {
        Logger retValue = (Logger)EcoreUtil.copy((EObject)this.getLoggers()[this.combo.getSelectionIndex()]);
        this.loggerPropertyComposite.populateLogger(retValue);
        return retValue;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return this.loggerPropertyComposite.validate();
    }

    public String getErrorMessage() {
        return this.loggerPropertyComposite.getErrorMessage();
    }
}

