/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.io.BufferedReader;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.stem.core.common.util.LogInitializationException;
import org.eclipse.stem.util.analysis.DataProcessor;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ProcessorControl
extends AnalysisControl {
    private static final String TIME_FORMAT = "yyyy-MM-dd";
    protected static Text sourceFolder;
    protected static Text targetFolder;
    protected static Text populationDataFile;
    protected static Spinner recoveryRate;
    protected static Spinner susceptibleRate;
    protected static Spinner immunityLossRate;
    protected static Spinner populationSizeStartYear;
    protected static Spinner populationSizeEndYear;
    protected Button processButton;
    protected static Label statusLabel;
    protected static Date startDate;
    protected static Date endDate;

    public ProcessorControl(Composite parent) {
        super(parent, 0);
        this.createContents();
    }

    void createContents() {
        final Shell shell = this.getShell();
        this.setLayout((Layout)new FormLayout());
        this.identifiableTitle = new Label((Composite)this, 0);
        this.identifiableTitle.setText(Messages.getString("PROCESSOR.TITLE"));
        Display display = this.getDisplay();
        this.identifiableTitle.setFont(this.getLargerFont(18, display));
        statusLabel = new Label((Composite)this, 2048);
        statusLabel.setText("");
        Label sourceFolderLabel = new Label((Composite)this, 2048);
        sourceFolderLabel.setText(Messages.getString("PROCESSOR.SOURCEFOLDER"));
        sourceFolder = new Text((Composite)this, 2048);
        sourceFolder.setText("");
        sourceFolder.setEditable(false);
        Button selectSourceFolderButton = new Button((Composite)this, 0);
        selectSourceFolderButton.setText(Messages.getString("PROCESSOR.SELECTSOURCEFOLDER"));
        selectSourceFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(shell, 4096);
                dd.setText(Messages.getString("PROCESSOR.SELECTSOURCEFOLDEDIALOGTITLE"));
                String dir = sourceFolder.getText();
                if (dir == null || dir.length() < 1) {
                    dir = ROOT_PATH;
                }
                dd.setFilterPath(dir);
                String selected = dd.open();
                if (selected != null) {
                    sourceFolder.setText(selected);
                }
                if (selected != null && selected.length() != 0) {
                    statusLabel.setText(Messages.getString("PROCESSOR.READINGDATA"));
                    populationSizeStartYear.setEnabled(false);
                    populationSizeEndYear.setEnabled(false);
                    ProcessorControl.this.initializeDates();
                    if (startDate != null && endDate != null) {
                        SimpleDateFormat format = new SimpleDateFormat(ProcessorControl.TIME_FORMAT);
                        statusLabel.setText("Processing data from " + format.format(startDate) + " to " + format.format(endDate));
                        if (targetFolder.getText() == null || targetFolder.getText().length() == 0) {
                            targetFolder.setText(selected);
                        }
                        Calendar startCal = Calendar.getInstance();
                        startCal.setTime(startDate);
                        Calendar endCal = Calendar.getInstance();
                        endCal.setTime(endDate);
                        populationSizeStartYear.setEnabled(true);
                        if (startCal.get(1) < endCal.get(1)) {
                            populationSizeEndYear.setEnabled(true);
                        }
                    } else {
                        statusLabel.setText(Messages.getString("PROCESSOR.FAILEDREADDATA"));
                        sourceFolder.setText("");
                    }
                }
                ProcessorControl.this.enableProcessButton();
            }
        });
        Label targetFolderLabel = new Label((Composite)this, 2048);
        targetFolderLabel.setText(Messages.getString("PROCESSOR.TARGETFOLDER"));
        targetFolder = new Text((Composite)this, 2048);
        targetFolder.setBounds(10, 10, 100, 20);
        targetFolder.setText("");
        targetFolder.setEditable(false);
        Button selectTargetFolderButton = new Button((Composite)this, 0);
        selectTargetFolderButton.setText(Messages.getString("PROCESSOR.SELECTTARGETFOLDER"));
        selectTargetFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(shell, 4096);
                dd.setText(Messages.getString("PROCESSOR.SELECTTARGETFOLDEDIALOGTITLE"));
                String dir = targetFolder.getText();
                if (dir == null || dir.length() < 1) {
                    dir = ROOT_PATH;
                }
                dd.setFilterPath(dir);
                String selected = dd.open();
                if (selected != null) {
                    targetFolder.setText(selected);
                }
                ProcessorControl.this.enableProcessButton();
            }
        });
        Label populationDataFileLabel = new Label((Composite)this, 2048);
        populationDataFileLabel.setText(Messages.getString("PROCESSOR.POPULATIONDATAFILE"));
        populationDataFile = new Text((Composite)this, 2048);
        populationDataFile.setBounds(10, 10, 100, 20);
        populationDataFile.setText("");
        populationDataFile.setEditable(false);
        Button selectPopulationDataFileButton = new Button((Composite)this, 0);
        selectPopulationDataFileButton.setText(Messages.getString("PROCESSOR.SELECTPOPULATIONDATAFILE"));
        selectPopulationDataFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(shell, 4096);
                fd.setText(Messages.getString("PROCESSOR.SELECTPOPULATIONDATAFILEDIALOGTITLE"));
                String beginSearch = populationDataFile.getText();
                if (beginSearch == null || beginSearch.length() < 1) {
                    beginSearch = ROOT_PATH;
                }
                fd.setFilterPath(beginSearch);
                String selected = fd.open();
                if (selected != null) {
                    populationDataFile.setText(selected);
                }
                ProcessorControl.this.enableProcessButton();
            }
        });
        Label parametersLabel = new Label((Composite)this, 2048);
        parametersLabel.setText(Messages.getString("PROCESSOR.PARAMETERS"));
        Composite spinnerComposite = new Composite((Composite)this, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        spinnerComposite.setLayout((Layout)gridLayout);
        Label recoveryRateLabel = new Label(spinnerComposite, 0);
        recoveryRateLabel.setText(Messages.getString("PROCESSOR.RECOVERYRATE"));
        recoveryRate = new Spinner(spinnerComposite, 0);
        recoveryRate.setDigits(2);
        recoveryRate.setMinimum(0);
        recoveryRate.setMaximum(100);
        recoveryRate.setIncrement(1);
        recoveryRate.setSelection(20);
        recoveryRate.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessorControl.this.enableProcessButton();
            }
        });
        Label susceptibleRateLabel = new Label(spinnerComposite, 0);
        susceptibleRateLabel.setText(Messages.getString("PROCESSOR.SUSCEPTIBLERATE"));
        susceptibleRate = new Spinner(spinnerComposite, 0);
        susceptibleRate.setDigits(3);
        susceptibleRate.setMinimum(0);
        susceptibleRate.setMaximum(1000);
        susceptibleRate.setIncrement(1);
        susceptibleRate.setSelection(333);
        susceptibleRate.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessorControl.this.enableProcessButton();
            }
        });
        Label immunityLossRateLabel = new Label(spinnerComposite, 0);
        immunityLossRateLabel.setText(Messages.getString("PROCESSOR.IMMUNITYLOSSRATE"));
        immunityLossRate = new Spinner(spinnerComposite, 0);
        immunityLossRate.setDigits(4);
        immunityLossRate.setMinimum(0);
        immunityLossRate.setMaximum(10000);
        immunityLossRate.setIncrement(1);
        immunityLossRate.setSelection(9);
        immunityLossRate.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessorControl.this.enableProcessButton();
            }
        });
        spinnerComposite.pack();
        Label populationSizeLabel = new Label((Composite)this, 2048);
        populationSizeLabel.setText(Messages.getString("PROCESSOR.POPULATIONSIZE"));
        Composite sizeComposite = new Composite((Composite)this, 2048);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        sizeComposite.setLayout((Layout)gridLayout);
        Label populationSizeStartYearLabel = new Label(sizeComposite, 0);
        populationSizeStartYearLabel.setText(Messages.getString("PROCESSOR.STARTYEAR"));
        populationSizeStartYear = new Spinner(sizeComposite, 0);
        populationSizeStartYear.setDigits(0);
        populationSizeStartYear.setMinimum(0);
        populationSizeStartYear.setMaximum(100000000);
        populationSizeStartYear.setIncrement(1000);
        populationSizeStartYear.setSelection(10000000);
        populationSizeStartYear.setEnabled(false);
        populationSizeStartYear.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessorControl.this.enableProcessButton();
            }
        });
        Label populationSizeEndYearLabel = new Label(sizeComposite, 0);
        populationSizeEndYearLabel.setText(Messages.getString("PROCESSOR.ENDYEAR"));
        populationSizeEndYear = new Spinner(sizeComposite, 0);
        populationSizeEndYear.setDigits(0);
        populationSizeEndYear.setMinimum(0);
        populationSizeEndYear.setMaximum(100000000);
        populationSizeEndYear.setIncrement(1000);
        populationSizeEndYear.setSelection(10000000);
        populationSizeEndYear.setEnabled(false);
        populationSizeEndYear.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessorControl.this.enableProcessButton();
            }
        });
        sizeComposite.pack();
        this.processButton = new Button((Composite)this, 0);
        this.processButton.setText(Messages.getString("PROCESSOR.PROCESS"));
        this.processButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    DataProcessor processor = new DataProcessor();
                    processor.process(sourceFolder.getText(), targetFolder.getText(), startDate, endDate, populationDataFile.getText(), Long.parseLong(populationSizeStartYear.getText()), Long.parseLong(populationSizeEndYear.getText()), Double.parseDouble(recoveryRate.getText()), Double.parseDouble(susceptibleRate.getText()), Double.parseDouble(immunityLossRate.getText()));
                    statusLabel.setText(Messages.getString("COMMON.DONE"));
                }
                catch (LogInitializationException ex) {
                    statusLabel.setText(ex.getMessage());
                }
            }
        });
        this.enableProcessButton();
        this.createFormData(null, this.identifiableTitle, null, null, 0);
        this.createFormData((Control)this.identifiableTitle, sourceFolderLabel, (Control)sourceFolder, selectSourceFolderButton, 5);
        this.createFormData((Control)sourceFolderLabel, targetFolderLabel, (Control)targetFolder, selectTargetFolderButton, 5);
        this.createFormData((Control)targetFolderLabel, populationDataFileLabel, (Control)populationDataFile, selectPopulationDataFileButton, 5);
        this.createFormData((Control)populationDataFileLabel, parametersLabel, (Control)spinnerComposite, null, 20);
        this.createFormData((Control)spinnerComposite, populationSizeLabel, (Control)sizeComposite, null, 5);
        this.createFormData((Control)sizeComposite, null, null, this.processButton, 5);
        this.createFormData((Control)this.processButton, statusLabel, null, null, 100);
    }

    void enableProcessButton() {
        boolean enabled = true;
        if (enabled && (sourceFolder.getText() == null || sourceFolder.getText().length() == 0)) {
            enabled = false;
        }
        if (enabled && (targetFolder.getText() == null || targetFolder.getText().length() == 0)) {
            enabled = false;
        }
        if (enabled && (populationDataFile.getText() == null || populationDataFile.getText().length() == 0)) {
            enabled = false;
        }
        if (enabled && (recoveryRate.getText() == null || recoveryRate.getText().length() == 0)) {
            enabled = false;
        }
        if (enabled && (susceptibleRate.getText() == null || susceptibleRate.getText().length() == 0)) {
            enabled = false;
        }
        if (enabled && (immunityLossRate.getText() == null || immunityLossRate.getText().length() == 0)) {
            enabled = false;
        }
        if (enabled && (populationSizeStartYear.getText() == null || populationSizeStartYear.getText().length() == 0)) {
            enabled = false;
        }
        if (enabled && (populationSizeEndYear.getText() == null || populationSizeEndYear.getText().length() == 0)) {
            enabled = false;
        }
        this.processButton.setEnabled(enabled);
    }

    protected void initializeDates() {
        startDate = null;
        endDate = null;
        File file = new File(sourceFolder.getText());
        File[] allFiles = file.listFiles();
        int i = 0;
        while (i < allFiles.length) {
            BufferedReader fileReader;
            String fileName = allFiles[i].getName();
            if (fileName.indexOf(".txt") >= 0 && (fileReader = DataProcessor.openReader(allFiles[i])) != null) {
                try {
                    String buffer = null;
                    fileReader.readLine();
                    while (!DataProcessor.EOF(buffer = fileReader.readLine())) {
                        StringTokenizer tokenizer = new StringTokenizer(buffer, ",");
                        if (tokenizer.countTokens() != 3) continue;
                        tokenizer.nextToken(",");
                        String time = tokenizer.nextToken(",");
                        tokenizer.nextToken(",");
                        if (time == null) continue;
                        SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
                        Date date = format.parse(time);
                        if (startDate == null || date.before(startDate)) {
                            startDate = date;
                        }
                        if (endDate != null && !date.after(endDate)) continue;
                        endDate = date;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    private void createFormData(Control topControl, Label label, Control text, Button button, int spacer) {
        int numerator;
        if (label != null) {
            FormData labelFormData = new FormData();
            labelFormData.top = topControl != null ? new FormAttachment(topControl, spacer) : new FormAttachment(0, 0);
            labelFormData.left = new FormAttachment(0, 0);
            numerator = 15;
            if (text == null && button == null) {
                numerator = 100;
            }
            labelFormData.right = new FormAttachment(numerator, 0);
            label.setLayoutData((Object)labelFormData);
        }
        if (text != null) {
            FormData textFieldFormData = new FormData();
            textFieldFormData.top = topControl != null ? new FormAttachment(topControl, spacer) : new FormAttachment(0, 0);
            textFieldFormData.left = label != null ? new FormAttachment((Control)label, 5) : new FormAttachment(0, 0);
            numerator = 80;
            if (button == null) {
                numerator = 100;
            }
            textFieldFormData.right = new FormAttachment(numerator, 0);
            text.setLayoutData((Object)textFieldFormData);
        }
        if (button != null) {
            FormData buttonFormData = new FormData();
            buttonFormData.top = topControl != null ? new FormAttachment(topControl, 0) : new FormAttachment(0, 0);
            buttonFormData.left = text != null ? new FormAttachment(text, 5) : (label != null ? new FormAttachment((Control)label, 5) : new FormAttachment(0, 0));
            buttonFormData.right = new FormAttachment(100, 0);
            button.setLayoutData((Object)buttonFormData);
        }
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public void remove() {
    }

    @Override
    protected void initializeHeader(String folderName) {
    }

    @Override
    public double[] getValues(int chartIndex, int trajectory) {
        return null;
    }

    @Override
    public String getProperty(int chartIndex, int state) {
        return null;
    }

    @Override
    public int getNumProperties(int chartIndex) {
        return 0;
    }

    @Override
    public Map<String, Object> getControlParametersMap() {
        return controlParametersMap;
    }
}

