/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.stem.core.common.util.LogInitializationException;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.CSVAnalysisWriter;
import org.eclipse.stem.util.analysis.PhaseSpaceCoordinate;
import org.eclipse.stem.util.analysis.ScenarioAnalysisSuite;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.LyapunovTrajectoryCanvas;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.stem.util.analysis.views.TimeSeriesCanvas;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LyapunovControl
extends AnalysisControl {
    private static final String CONSUMER = "LYAPUNOV_CONTROL";
    private static final String PRIMARY_FOLDER_KEY = "LYAPUNOV_CONTROL_PRIMARY";
    private static final String SECONDARY_FOLDER_KEY = "LYAPUNOV_CONTROL_SECONDARY";
    Label firstScenarioFolderLabel;
    Label secondScenarioFolderLabel;
    Text text1;
    Text text2;
    Label statusLabel;
    Label resultsLabel;
    LyapunovTrajectoryCanvas lyapunovTrajectoryCanvas;
    TimeSeriesCanvas timeSeriesCanvas;
    static final ColorDefinition foreGround = ColorDefinitionImpl.create((int)180, (int)0, (int)0);
    static final ColorDefinition backgroundGround = ColorDefinitionImpl.create((int)255, (int)255, (int)225);
    static final ColorDefinition frameColor = ColorDefinitionImpl.WHITE();
    List<PhaseSpaceCoordinate[]> comparisonValues = new ArrayList<PhaseSpaceCoordinate[]>();
    List<EList<Double>> cumulativeDeviation = new ArrayList<EList<Double>>();
    protected static final String LYAPUNOV_FILE_PREFIX = Messages.getString("LYA.TITLE");
    protected static final String LYAPUNOV_DEVIATION_FILE_PREFIX = Messages.getString("LYA.DEVIATION");
    protected static final String SELECT_FOLDER_DIALOG_TEXT = Messages.getString("LYA.SELECTFOLDERDIALG");
    ScenarioAnalysisSuite analyzer = new ScenarioAnalysisSuite(this);
    Composite parentComposite;

    public LyapunovControl(Composite parent) {
        super(parent, 0);
        this.parentComposite = parent;
        this.createContents();
    }

    private void createContents() {
        this.setLayout((Layout)new FormLayout());
        Display display = this.getDisplay();
        this.identifiableTitle = new Label((Composite)this, 2048);
        this.identifiableTitle.setText(Messages.getString("LYA.TITLE"));
        this.identifiableTitle.setFont(this.getLargerFont(18, display));
        this.statusLabel = new Label((Composite)this, 2048);
        this.statusLabel.setText("");
        this.firstScenarioFolderLabel = new Label((Composite)this, 0);
        this.firstScenarioFolderLabel.setText(Messages.getString("LYA.FOLDER1LABEL"));
        this.text1 = new Text((Composite)this, 2048);
        this.text1.setBounds(10, 10, 100, 20);
        String primaryDir = this.prefs.getRecentFolder(PRIMARY_FOLDER_KEY);
        this.text1.setText(primaryDir);
        this.secondScenarioFolderLabel = new Label((Composite)this, 0);
        this.secondScenarioFolderLabel.setText(Messages.getString("LYA.FOLDER2LABEL"));
        this.text2 = new Text((Composite)this, 2048);
        this.text2.setBounds(10, 10, 100, 20);
        String secondaryDir = this.prefs.getRecentFolder(SECONDARY_FOLDER_KEY);
        this.text2.setText(secondaryDir);
        Composite analyzeButtonComposite = this.getAnalyzeButtonComposite(this, Messages.getString("LYA.COMPARISON"));
        this.resultsLabel = new Label((Composite)this, 8);
        this.resultsLabel.setText("");
        FormData titleFormData = new FormData();
        this.identifiableTitle.setLayoutData((Object)titleFormData);
        titleFormData.top = new FormAttachment(0, 0);
        titleFormData.left = new FormAttachment(0, 0);
        titleFormData.right = new FormAttachment(25, 0);
        FormData resultsFormData = new FormData();
        this.resultsLabel.setLayoutData((Object)resultsFormData);
        resultsFormData.top = new FormAttachment(0, 0);
        resultsFormData.left = new FormAttachment(25, 0);
        resultsFormData.right = new FormAttachment(75, 0);
        int spacer = 10;
        int buttonspacer = 5;
        FormData firstScenarioFolderLabelFormData = new FormData();
        firstScenarioFolderLabelFormData.top = new FormAttachment((Control)this.identifiableTitle, spacer);
        firstScenarioFolderLabelFormData.left = new FormAttachment(0, 0);
        firstScenarioFolderLabelFormData.right = new FormAttachment(15, 0);
        this.firstScenarioFolderLabel.setLayoutData((Object)firstScenarioFolderLabelFormData);
        FormData text1FormData = new FormData();
        text1FormData.top = new FormAttachment((Control)this.identifiableTitle, spacer);
        text1FormData.left = new FormAttachment((Control)this.firstScenarioFolderLabel, 5);
        text1FormData.right = new FormAttachment(85, 0);
        this.text1.setLayoutData((Object)text1FormData);
        Button selectFolder1Button = new Button((Composite)this, 0);
        selectFolder1Button.setText(Messages.getString("LYA.SELECTFOLDER"));
        FormData selectFolder1FormData = new FormData();
        selectFolder1FormData.top = new FormAttachment((Control)this.identifiableTitle, buttonspacer);
        selectFolder1FormData.left = new FormAttachment((Control)this.text1, 5);
        selectFolder1Button.setLayoutData((Object)selectFolder1FormData);
        final Shell shell = this.getShell();
        selectFolder1Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(shell, 4096);
                dd.setText(Messages.getString("LYA.SELECTFOLDERDIALOG"));
                String beginSearch = LyapunovControl.this.text1.getText();
                if (beginSearch == null || beginSearch.length() < 1) {
                    beginSearch = ROOT_PATH;
                }
                dd.setFilterPath(beginSearch);
                String selected = dd.open();
                if (selected != null) {
                    LyapunovControl.this.text1.setText(selected);
                }
            }
        });
        FormData secondScenarioFolderLabelFormData = new FormData();
        secondScenarioFolderLabelFormData.top = new FormAttachment((Control)this.firstScenarioFolderLabel, spacer);
        secondScenarioFolderLabelFormData.left = new FormAttachment(0, 0);
        secondScenarioFolderLabelFormData.right = new FormAttachment(15, 0);
        this.secondScenarioFolderLabel.setLayoutData((Object)secondScenarioFolderLabelFormData);
        FormData text2FormData = new FormData();
        text2FormData.top = new FormAttachment((Control)this.firstScenarioFolderLabel, spacer);
        text2FormData.left = new FormAttachment((Control)this.secondScenarioFolderLabel, 5);
        text2FormData.right = new FormAttachment(85, 0);
        this.text2.setLayoutData((Object)text2FormData);
        Button selectFolder2Button = new Button((Composite)this, 0);
        selectFolder2Button.setText(Messages.getString("LYA.SELECTFOLDER"));
        FormData selectFolder2FormData = new FormData();
        selectFolder2FormData.top = new FormAttachment((Control)this.firstScenarioFolderLabel, buttonspacer);
        selectFolder2FormData.left = new FormAttachment((Control)this.text2, 5);
        selectFolder2Button.setLayoutData((Object)selectFolder2FormData);
        selectFolder2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(shell, 4096);
                dd.setText(SELECT_FOLDER_DIALOG_TEXT);
                String beginSearch = LyapunovControl.this.text2.getText();
                if (beginSearch == null || beginSearch.length() < 1) {
                    beginSearch = ROOT_PATH;
                }
                dd.setFilterPath(beginSearch);
                String selected = dd.open();
                if (selected != null) {
                    LyapunovControl.this.text2.setText(selected);
                }
            }
        });
        FormData analysisButtonFormData = new FormData();
        analysisButtonFormData.top = new FormAttachment((Control)this.secondScenarioFolderLabel, spacer);
        analysisButtonFormData.left = new FormAttachment(0, 0);
        analysisButtonFormData.right = new FormAttachment(100, 0);
        analyzeButtonComposite.setLayoutData((Object)analysisButtonFormData);
        this.lyapunovTrajectoryCanvas = new LyapunovTrajectoryCanvas(this);
        FormData trajectoryChartFormData = new FormData();
        this.lyapunovTrajectoryCanvas.setLayoutData(trajectoryChartFormData);
        trajectoryChartFormData.top = new FormAttachment((Control)analyzeButtonComposite, 0);
        trajectoryChartFormData.bottom = new FormAttachment(100, 0);
        trajectoryChartFormData.left = new FormAttachment(0, 0);
        trajectoryChartFormData.right = new FormAttachment(50, 0);
        this.timeSeriesCanvas = new TimeSeriesCanvas(this, Messages.getString("LYA.DIVERGENCELEGEND"), Messages.getString("LYA.DIVERGENCEYAXIS"), Messages.getString("LYA.DIVERGENCEYAXIS"), foreGround, backgroundGround, frameColor, 0);
        FormData analysisChartFormData = new FormData();
        this.timeSeriesCanvas.setLayoutData(analysisChartFormData);
        analysisChartFormData.top = new FormAttachment((Control)analyzeButtonComposite, 0);
        analysisChartFormData.bottom = new FormAttachment(100, 0);
        analysisChartFormData.left = new FormAttachment(50, 0);
        analysisChartFormData.right = new FormAttachment(100, 0);
        final ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
        this.analyzeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String referenceDirectory = LyapunovControl.this.text1.getText();
                String comparisonDirectory = LyapunovControl.this.text2.getText();
                Display display = LyapunovControl.this.parentComposite.getDisplay();
                LyapunovControl.this.identifiableTitle.setText(Messages.getString("LYA.TITLE"));
                LyapunovControl.this.resultsLabel.setText(Messages.getString("LYA.WORKING"));
                LyapunovControl.this.comparisonValues.clear();
                LyapunovControl.this.cumulativeDeviation.clear();
                LyapunovControl.this.lyapunovTrajectoryCanvas.reset();
                if (!LyapunovControl.this.analyzer.validate(referenceDirectory)) {
                    LyapunovControl.this.identifiableTitle.setText(ScenarioAnalysisSuite.NOT_FOUND_MSG);
                    LyapunovControl.this.text1.setText("");
                }
                if (!LyapunovControl.this.analyzer.validate(comparisonDirectory)) {
                    LyapunovControl.this.identifiableTitle.setText(ScenarioAnalysisSuite.NOT_FOUND_MSG);
                    LyapunovControl.this.text2.setText("");
                }
                if (!LyapunovControl.this.analyzer.validate(referenceDirectory) || !LyapunovControl.this.analyzer.validate(comparisonDirectory)) {
                    return;
                }
                try {
                    List<PhaseSpaceCoordinate[]> data = LyapunovControl.this.analyzer.getLyapunovTrajectory(referenceDirectory, comparisonDirectory, (IRunnableContext)progressDialog);
                    if (data == null) {
                        LyapunovControl.this.resultsLabel.setBackground(display.getSystemColor(3));
                        LyapunovControl.this.resultsLabel.setText(Messages.getString("LYA.ERROR1"));
                    } else {
                        LyapunovControl.this.comparisonValues.addAll(data);
                        LyapunovControl.this.prefs.setRecentFolder(LyapunovControl.PRIMARY_FOLDER_KEY, referenceDirectory);
                        LyapunovControl.this.prefs.setRecentFolder(LyapunovControl.SECONDARY_FOLDER_KEY, comparisonDirectory);
                        LyapunovControl.this.cumulativeDeviation.addAll(ScenarioAnalysisSuite.getCumulativePhaseSpaceDeviation(LyapunovControl.this.comparisonValues));
                        LyapunovControl.this.lyapunovTrajectoryCanvas.draw();
                        String outFileName = String.valueOf(LYAPUNOV_FILE_PREFIX) + "_" + LyapunovControl.getScenarioNameFromDirectoryName(referenceDirectory) + "_" + LyapunovControl.getScenarioNameFromDirectoryName(comparisonDirectory);
                        CSVAnalysisWriter writer = new CSVAnalysisWriter(outFileName);
                        writer.logData(2, LyapunovControl.this.comparisonValues);
                        outFileName = String.valueOf(LYAPUNOV_DEVIATION_FILE_PREFIX) + "_" + LyapunovControl.getScenarioNameFromDirectoryName(referenceDirectory) + "_" + LyapunovControl.getScenarioNameFromDirectoryName(comparisonDirectory);
                        CSVAnalysisWriter writer2 = new CSVAnalysisWriter(outFileName);
                        writer2.logData(LyapunovControl.this.cumulativeDeviation);
                        LyapunovControl.this.timeSeriesCanvas.draw();
                        LyapunovControl.this.resultsLabel.setText(Messages.getString("LYA.COMPLETE"));
                    }
                }
                catch (LogInitializationException sie) {
                    Activator.logError("", sie);
                }
            }
        });
    }

    public static String getScenarioNameFromDirectoryName(String dirName) {
        int last = dirName.lastIndexOf("/");
        int last2 = dirName.lastIndexOf("\\");
        if (last2 > last) {
            last = last2;
        }
        if (last <= 0) {
            last = 0;
        }
        String retVal = dirName.substring(last + 1, dirName.length());
        return retVal;
    }

    public PhaseSpaceCoordinate[] getPointValues(int trajectory) {
        return this.comparisonValues.get(trajectory);
    }

    @Override
    public double[] getValues(int chartIndex, int trajectory) {
        EList<Double> l = this.cumulativeDeviation.get(trajectory);
        double[] res = new double[l.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = (Double)l.get(i);
            ++i;
        }
        return res;
    }

    @Override
    public String getProperty(int chartIndex, int state) {
        return Messages.getString("LYA.DIVERGENCEYAXIS");
    }

    @Override
    public int getNumProperties(int chartIndex) {
        return 1;
    }

    @Override
    public void remove() {
        this.updateStatusLabel();
    }

    protected void updateStatusLabel() {
        this.statusLabel.setText(Messages.getString("COMMON.STATUS"));
    }

    @Override
    protected void initializeHeader(String folderName) {
        this.simulationNameLabel.setText("analyzing " + folderName);
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public Map<String, Object> getControlParametersMap() {
        return controlParametersMap;
    }
}

