/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.Map;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.util.analysis.AggregateDataWriter;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.ParameterEstimatorMethod;
import org.eclipse.stem.util.analysis.ScenarioAnalysisSuite;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.EstimatorCanvas;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.stem.util.analysis.views.ParameterEstimatorWizard;
import org.eclipse.stem.util.analysis.views.TimeSeriesCanvas;
import org.eclipse.stem.util.analysis.views.XYSeriesCanvas;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class EstimatorControl
extends AnalysisControl {
    String recentFolder;
    private static final String CONSUMER = "ESTIMATOR_CONTROL";
    static Label scenarioFolderLabel;
    static Label estimatorFolderLabel;
    public static Text text1;
    public static Text estimatorText;
    static Label statusLabel;
    public static Button[] dataAverageRadioButtons;
    public static Button[] betaModeRadioButtons;
    private static final int SPINNER_RESOLUTION = 1000;
    private static final int SPINNER_INCREMENT = 1;
    protected static Spinner minThresholdSpinnerS;
    protected static Spinner maxThresholdSpinnerS;
    static Label minSpinnerLabelS;
    static Label maxSpinnerLabelS;
    public static final String MIN_S_KEY = "MINS";
    public static final String MIN_E_KEY = "MINE";
    public static final String MIN_I_KEY = "MINI";
    public static final String MIN_R_KEY = "MINR";
    public static final String MAX_S_KEY = "MAXS";
    public static final String MAX_E_KEY = "MAXE";
    public static final String MAX_I_KEY = "MAXI";
    public static final String MAX_R_KEY = "MAXR";
    public static final String SUM_LOCATIONS_KEY = "SUM_LOCATIONS";
    public static final String FREQ_MODE_KEY = "FREQ_MODE";
    protected static Combo displayRegionCombo;
    protected static String regionToDisplay;
    protected static Spinner minThresholdSpinnerE;
    protected static Spinner maxThresholdSpinnerE;
    static Label minSpinnerLabelE;
    static Label maxSpinnerLabelE;
    protected static Spinner minThresholdSpinnerI;
    protected static Spinner maxThresholdSpinnerI;
    static Label minSpinnerLabelI;
    static Label maxSpinnerLabelI;
    protected static Spinner minThresholdSpinnerR;
    protected static Spinner maxThresholdSpinnerR;
    static Label minSpinnerLabelR;
    static Label maxSpinnerLabelR;
    static ModelParameters averageParms;
    static TabFolder tabFolder;
    static EstimatorCanvas estimatorCanvas;
    static final ColorDefinition foreGround;
    static final ColorDefinition backgroundGround;
    static final ColorDefinition frameColor;
    protected static TimeSeriesCanvas[] equationSeries;
    protected static XYSeriesCanvas[] regressionSeries;
    static ParameterEstimatorWizard parameterEstimatorWizard;
    static WizardDialog wizardDialog;
    protected static ScenarioAnalysisSuite analyzer;

    static {
        dataAverageRadioButtons = new Button[2];
        betaModeRadioButtons = new Button[2];
        regionToDisplay = "";
        foreGround = ColorDefinitionImpl.create((int)180, (int)0, (int)0);
        backgroundGround = ColorDefinitionImpl.create((int)255, (int)255, (int)225);
        frameColor = ColorDefinitionImpl.WHITE();
        equationSeries = new TimeSeriesCanvas[4];
        regressionSeries = new XYSeriesCanvas[4];
    }

    public EstimatorControl(Composite parent) {
        super(parent, 0);
        this.createContents();
    }

    void createContents() {
        analyzer = new ScenarioAnalysisSuite(this);
        this.setLayout((Layout)new FormLayout());
        this.identifiableTitle = new Label((Composite)this, 0);
        this.identifiableTitle.setText(Messages.getString("EST.TITLE"));
        this.identifiableTitle.setFont(this.getLargerFont(18, this.getDisplay()));
        statusLabel = new Label((Composite)this, 2048);
        statusLabel.setText("");
        scenarioFolderLabel = new Label((Composite)this, 2048);
        scenarioFolderLabel.setText(Messages.getString("EST.SCFOLDER"));
        estimatorFolderLabel = new Label((Composite)this, 2048);
        estimatorFolderLabel.setText(Messages.getString("EST.PARAMESTIMATOR"));
        text1 = new Text((Composite)this, 2048);
        text1.setBounds(10, 10, 100, 20);
        this.recentFolder = this.prefs.getRecentFolder(CONSUMER);
        if (this.recentFolder == null) {
            this.recentFolder = ScenarioAnalysisSuite.REFERENCE_TESTING_DIRECTORY;
        }
        text1.setText(this.recentFolder);
        String estimatorMethod = this.prefs.getRecentEstimatorMethod();
        estimatorText = new Text((Composite)this, 2048);
        estimatorText.setBounds(10, 10, 100, 20);
        if (estimatorMethod != null) {
            estimatorText.setText(estimatorMethod);
        } else {
            estimatorText.setText("");
        }
        this.selectEstimatorButton = new Button((Composite)this, 0);
        this.selectEstimatorButton.setText(Messages.getString("EST.SELECTESTIMATOR"));
        Composite displayComposite = this.getRegionSelectorComboComposite(this);
        Composite radioComposite = this.getDataAvgRadioButtonsComposite(this);
        Composite spinnerComposite = this.getSpinnerComposite(this);
        Composite betaModeComposite = this.getbetaModeRadioButtonsComposite(this);
        Composite doEstimationComposite = this.getAnalyzeButtonComposite(this, Messages.getString("EST.ESTIMATE"));
        tabFolder = new TabFolder((Composite)this, 0);
        TabItem item0 = new TabItem(tabFolder, 2048);
        item0.setText(Messages.getString("EST.RESULTS"));
        estimatorCanvas = new EstimatorCanvas((Composite)tabFolder);
        item0.setControl((Control)estimatorCanvas);
        TabItem item1 = new TabItem(tabFolder, 0);
        item1.setText(Messages.getString("EST.INPUTDATA"));
        Composite dataComposite = new Composite((Composite)tabFolder, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        dataComposite.setLayout((Layout)new FormLayout());
        item1.setControl((Control)dataComposite);
        this.getEquationSeriesCharts(dataComposite);
        TabItem item2 = new TabItem(tabFolder, 0);
        item2.setText(Messages.getString("EST.REGRESSION"));
        Composite regressionComposite = new Composite((Composite)tabFolder, 2048);
        regressionComposite.setLayout((Layout)new FormLayout());
        item2.setControl((Control)regressionComposite);
        this.getRegressionSeriesCharts(regressionComposite);
        int spacer = 5;
        int buttonspacer = 0;
        FormData titleFormData = new FormData();
        this.identifiableTitle.setLayoutData((Object)titleFormData);
        titleFormData.top = new FormAttachment(0, 0);
        titleFormData.left = new FormAttachment(0, 0);
        titleFormData.right = new FormAttachment(100, 0);
        FormData scenarioFolderLabelFormData = new FormData();
        scenarioFolderLabelFormData.top = new FormAttachment((Control)this.identifiableTitle, spacer);
        scenarioFolderLabelFormData.left = new FormAttachment(0, 0);
        scenarioFolderLabelFormData.right = new FormAttachment(15, 0);
        scenarioFolderLabel.setLayoutData((Object)scenarioFolderLabelFormData);
        FormData text1FormData = new FormData();
        text1FormData.top = new FormAttachment((Control)this.identifiableTitle, spacer);
        text1FormData.left = new FormAttachment((Control)scenarioFolderLabel, 5);
        text1FormData.right = new FormAttachment(85, 0);
        text1.setLayoutData((Object)text1FormData);
        text1.setEditable(false);
        FormData selectEstimatorButtonFormData = new FormData();
        selectEstimatorButtonFormData.top = new FormAttachment((Control)this.identifiableTitle, buttonspacer);
        selectEstimatorButtonFormData.left = new FormAttachment((Control)text1, 5);
        this.selectEstimatorButton.setLayoutData((Object)selectEstimatorButtonFormData);
        FormData estimatorLabelFormData = new FormData();
        estimatorLabelFormData.top = new FormAttachment((Control)scenarioFolderLabel, spacer);
        estimatorLabelFormData.left = new FormAttachment(0, 0);
        estimatorLabelFormData.right = new FormAttachment(15, 0);
        estimatorFolderLabel.setLayoutData((Object)estimatorLabelFormData);
        FormData estimatorTextFormData = new FormData();
        estimatorTextFormData.top = new FormAttachment((Control)scenarioFolderLabel, spacer);
        estimatorTextFormData.left = new FormAttachment((Control)scenarioFolderLabel, 5);
        estimatorTextFormData.right = new FormAttachment(85, 0);
        estimatorText.setLayoutData((Object)estimatorTextFormData);
        estimatorText.setEditable(false);
        FormData displayComboCompositeFormData = new FormData();
        displayComboCompositeFormData.top = new FormAttachment((Control)estimatorText, spacer);
        displayComboCompositeFormData.left = new FormAttachment(0, 0);
        displayComboCompositeFormData.right = new FormAttachment(24, 0);
        displayComposite.setLayoutData((Object)displayComboCompositeFormData);
        FormData betaModeRadioCompositeFormData = new FormData();
        betaModeRadioCompositeFormData.top = new FormAttachment((Control)estimatorText, spacer);
        betaModeRadioCompositeFormData.left = new FormAttachment(25, 0);
        betaModeRadioCompositeFormData.right = new FormAttachment(39, 0);
        betaModeComposite.setLayoutData((Object)betaModeRadioCompositeFormData);
        FormData radioCompositeFormData = new FormData();
        radioCompositeFormData.top = new FormAttachment((Control)estimatorText, spacer);
        radioCompositeFormData.bottom = new FormAttachment((Control)doEstimationComposite, -5);
        radioCompositeFormData.left = new FormAttachment(40, 0);
        radioCompositeFormData.right = new FormAttachment(61, 0);
        radioComposite.setLayoutData((Object)radioCompositeFormData);
        FormData spinnerFormData = new FormData();
        spinnerFormData.top = new FormAttachment((Control)estimatorText, spacer);
        spinnerFormData.bottom = new FormAttachment((Control)doEstimationComposite, -5);
        spinnerFormData.left = new FormAttachment(62, 0);
        spinnerFormData.right = new FormAttachment(100, 0);
        spinnerComposite.setLayoutData((Object)spinnerFormData);
        FormData analysisButtonFormData = new FormData();
        analysisButtonFormData.top = new FormAttachment((Control)estimatorFolderLabel, 18 * spacer);
        analysisButtonFormData.left = new FormAttachment(0, 0);
        analysisButtonFormData.right = new FormAttachment(100, 0);
        doEstimationComposite.setLayoutData((Object)analysisButtonFormData);
        if (this.recentFolder != null && estimatorMethod != null) {
            this.analyzeButton.setEnabled(true);
        } else {
            this.analyzeButton.setEnabled(false);
        }
        FormData tabFormData = new FormData();
        tabFolder.setLayoutData((Object)tabFormData);
        tabFormData.top = new FormAttachment((Control)doEstimationComposite, 0);
        tabFormData.bottom = new FormAttachment(100, 0);
        tabFormData.left = new FormAttachment(0, 0);
        tabFormData.right = new FormAttachment(100, 0);
        final Shell shell = this.getShell();
        final EstimatorControl eControl = this;
        this.selectEstimatorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir = null;
                dir = parameterEstimatorWizard != null ? EstimatorControl.parameterEstimatorWizard.selectFolderPage.getDirName() : EstimatorControl.this.recentFolder;
                if (dir == null || dir.length() < 1) {
                    dir = ROOT_PATH;
                }
                parameterEstimatorWizard = new ParameterEstimatorWizard(eControl, dir);
                wizardDialog = new WizardDialog(shell, (IWizard)parameterEstimatorWizard);
                wizardDialog.create();
                eControl.analyzeButton.setEnabled(false);
                estimatorText.setText("");
                wizardDialog.open();
            }
        });
        final ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
        this.analyzeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterEstimatorMethod method;
                ReferenceScenarioDataMapImpl dataMap;
                EstimatorControl.this.recentFolder = text1.getText();
                String methodtxt = estimatorText.getText();
                EstimatorControl.this.identifiableTitle.setText(Messages.getString("EST.TITLE"));
                if (!analyzer.validate(EstimatorControl.this.recentFolder)) {
                    EstimatorControl.this.identifiableTitle.setText(ScenarioAnalysisSuite.NOT_FOUND_MSG);
                    text1.setText("");
                    return;
                }
                EstimatorControl.this.prefs.setRecentFolder(EstimatorControl.CONSUMER, EstimatorControl.this.recentFolder);
                EstimatorControl.this.prefs.setEstimatorMethod(methodtxt);
                if (parameterEstimatorWizard != null) {
                    dataMap = parameterEstimatorWizard.getReferenceScenarioDataMap();
                    method = parameterEstimatorWizard.getParameterEstimatorMethod();
                } else {
                    try {
                        CSVscenarioLoader loader = new CSVscenarioLoader(EstimatorControl.this.recentFolder);
                        int maxResolution = loader.getMaxResolution("");
                        dataMap = loader.parseAllFiles("", maxResolution);
                        method = ParameterEstimatorMethod.valueOf(methodtxt);
                    }
                    catch (Exception ex) {
                        Activator.logError((String)ex.getMessage(), (Throwable)ex);
                        return;
                    }
                }
                averageParms = analyzer.estimateParameters(dataMap, method, (IRunnableContext)progressDialog);
                String[] displayableRegions = averageParms.getDataLocations();
                displayRegionCombo.setItems(displayableRegions);
                displayRegionCombo.select(0);
                regionToDisplay = displayableRegions[0];
                EstimatorControl.updateCharts();
            }
        });
        maxThresholdSpinnerS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int max = maxThresholdSpinnerS.getSelection();
                int min = minThresholdSpinnerS.getSelection();
                int minThresh = max - 1;
                int maxThresh = min + 1;
                maxThresholdSpinnerS.setMinimum(maxThresh);
                minThresholdSpinnerS.setMaximum(minThresh);
            }
        });
        minThresholdSpinnerS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int max = maxThresholdSpinnerS.getSelection();
                int min = minThresholdSpinnerS.getSelection();
                int minThresh = max - 1;
                int maxThresh = min + 1;
                maxThresholdSpinnerS.setMinimum(maxThresh);
                minThresholdSpinnerS.setMaximum(minThresh);
            }
        });
    }

    Composite getDataAvgRadioButtonsComposite(EstimatorControl control) {
        Composite radioComposite = new Composite((Composite)control, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        radioComposite.setLayout((Layout)fillLayout);
        EstimatorControl.dataAverageRadioButtons[0] = new Button(radioComposite, 16);
        dataAverageRadioButtons[0].setSelection(true);
        dataAverageRadioButtons[0].setText(Messages.getString("EST.CHOICE1"));
        dataAverageRadioButtons[0].setBounds(10, 5, 75, 30);
        EstimatorControl.dataAverageRadioButtons[1] = new Button(radioComposite, 16);
        dataAverageRadioButtons[1].setText(Messages.getString("EST.CHOICE2"));
        dataAverageRadioButtons[1].setBounds(10, 30, 75, 30);
        return radioComposite;
    }

    Composite getbetaModeRadioButtonsComposite(EstimatorControl control) {
        Composite radioComposite = new Composite((Composite)control, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        radioComposite.setLayout((Layout)fillLayout);
        EstimatorControl.betaModeRadioButtons[0] = new Button(radioComposite, 16);
        betaModeRadioButtons[0].setSelection(true);
        betaModeRadioButtons[0].setText(Messages.getString("EST.FREQBETA"));
        betaModeRadioButtons[0].setBounds(10, 5, 75, 30);
        EstimatorControl.betaModeRadioButtons[1] = new Button(radioComposite, 16);
        betaModeRadioButtons[1].setText(Messages.getString("EST.DENSITYBETA"));
        betaModeRadioButtons[1].setBounds(10, 30, 75, 30);
        return radioComposite;
    }

    Composite getRegionSelectorComboComposite(EstimatorControl control) {
        Composite comboComposite = new Composite((Composite)control, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        comboComposite.setLayout((Layout)fillLayout);
        displayRegionCombo = new Combo(comboComposite, 8);
        displayRegionCombo.setItems(new String[]{Messages.getString("EST.AVERAGE")});
        displayRegionCombo.setSize(200, 200);
        displayRegionCombo.pack();
        Label comboLabel = new Label(comboComposite, 0);
        comboLabel.setText(Messages.getString("EST.DISPLAY"));
        displayRegionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                regionToDisplay = displayRegionCombo.getText();
                EstimatorControl.updateCharts();
            }
        });
        return comboComposite;
    }

    protected static void updateCharts() {
        statusLabel.setText(Messages.getString("EST.COMPLETE"));
        estimatorCanvas.draw(averageParms.getParameters());
        int numDataCharts = analyzer.getEstimator().getNumProperties();
        int i = 0;
        while (i < numDataCharts) {
            equationSeries[i].draw();
            regressionSeries[i].draw();
            ++i;
        }
    }

    Composite getSpinnerComposite(EstimatorControl control) {
        Composite spinnerComposite = new Composite((Composite)control, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        spinnerComposite.setLayout((Layout)gridLayout);
        maxThresholdSpinnerS = new Spinner(spinnerComposite, 0);
        maxThresholdSpinnerS.setDigits(3);
        maxThresholdSpinnerS.setMinimum(1);
        maxThresholdSpinnerS.setMaximum(1000);
        maxThresholdSpinnerS.setIncrement(1);
        maxThresholdSpinnerS.setSelection(990);
        maxSpinnerLabelS = new Label(spinnerComposite, 0);
        maxSpinnerLabelS.setText(Messages.getString("EST.MAXTHRESHOLDS"));
        maxThresholdSpinnerE = new Spinner(spinnerComposite, 0);
        maxThresholdSpinnerE.setDigits(3);
        maxThresholdSpinnerE.setMinimum(1);
        maxThresholdSpinnerE.setMaximum(1000);
        maxThresholdSpinnerE.setIncrement(1);
        maxThresholdSpinnerE.setSelection(1000);
        maxSpinnerLabelE = new Label(spinnerComposite, 0);
        maxSpinnerLabelE.setText(Messages.getString("EST.MAXTHRESHOLDE"));
        maxThresholdSpinnerI = new Spinner(spinnerComposite, 0);
        maxThresholdSpinnerI.setDigits(3);
        maxThresholdSpinnerI.setMinimum(1);
        maxThresholdSpinnerI.setMaximum(1000);
        maxThresholdSpinnerI.setIncrement(1);
        maxThresholdSpinnerI.setSelection(1000);
        maxSpinnerLabelI = new Label(spinnerComposite, 0);
        maxSpinnerLabelI.setText(Messages.getString("EST.MAXTHRESHOLDI"));
        maxThresholdSpinnerR = new Spinner(spinnerComposite, 0);
        maxThresholdSpinnerR.setDigits(3);
        maxThresholdSpinnerR.setMinimum(1);
        maxThresholdSpinnerR.setMaximum(1000);
        maxThresholdSpinnerR.setIncrement(1);
        maxThresholdSpinnerR.setSelection(990);
        maxSpinnerLabelR = new Label(spinnerComposite, 0);
        maxSpinnerLabelR.setText(Messages.getString("EST.MAXTHRESHOLDR"));
        minThresholdSpinnerS = new Spinner(spinnerComposite, 0);
        minThresholdSpinnerS.setDigits(3);
        minThresholdSpinnerS.setMinimum(1);
        minThresholdSpinnerS.setMaximum(1000);
        minThresholdSpinnerS.setIncrement(1);
        minThresholdSpinnerS.setSelection(10);
        minSpinnerLabelS = new Label(spinnerComposite, 0);
        minSpinnerLabelS.setText(Messages.getString("EST.MINTHRESHOLDS"));
        minThresholdSpinnerE = new Spinner(spinnerComposite, 0);
        minThresholdSpinnerE.setDigits(3);
        minThresholdSpinnerE.setMinimum(1);
        minThresholdSpinnerE.setMaximum(1000);
        minThresholdSpinnerE.setIncrement(1);
        minThresholdSpinnerE.setSelection(100);
        minSpinnerLabelE = new Label(spinnerComposite, 0);
        minSpinnerLabelE.setText(Messages.getString("EST.MINTHRESHOLDE"));
        minThresholdSpinnerI = new Spinner(spinnerComposite, 0);
        minThresholdSpinnerI.setDigits(3);
        minThresholdSpinnerI.setMinimum(1);
        minThresholdSpinnerI.setMaximum(1000);
        minThresholdSpinnerI.setIncrement(1);
        minThresholdSpinnerI.setSelection(100);
        minSpinnerLabelI = new Label(spinnerComposite, 0);
        minSpinnerLabelI.setText(Messages.getString("EST.MINTHRESHOLDI"));
        minThresholdSpinnerR = new Spinner(spinnerComposite, 0);
        minThresholdSpinnerR.setDigits(3);
        minThresholdSpinnerR.setMinimum(1);
        minThresholdSpinnerR.setMaximum(1000);
        minThresholdSpinnerR.setIncrement(1);
        minThresholdSpinnerR.setSelection(1);
        minSpinnerLabelR = new Label(spinnerComposite, 0);
        minSpinnerLabelR.setText(Messages.getString("EST.MINTHRESHOLDR"));
        spinnerComposite.pack();
        return spinnerComposite;
    }

    private void getEquationSeriesCharts(Composite dataComposite) {
        EstimatorControl.equationSeries[0] = new TimeSeriesCanvas(this, dataComposite, Messages.getString("EST.EQUATION1"), Messages.getString("EST.AXISLABEL1"), AggregateDataWriter.getKeyS(), foreGround, backgroundGround, frameColor, 0, true);
        FormData eqOneFormData = new FormData();
        equationSeries[0].setLayoutData(eqOneFormData);
        eqOneFormData.top = new FormAttachment((Control)dataComposite, 0);
        eqOneFormData.bottom = new FormAttachment(50, 0);
        eqOneFormData.left = new FormAttachment(0, 0);
        eqOneFormData.right = new FormAttachment(50, 0);
        EstimatorControl.equationSeries[1] = new TimeSeriesCanvas(this, dataComposite, Messages.getString("EST.EQUATION3"), Messages.getString("EST.AXISLABEL3"), AggregateDataWriter.getKeyI(), foreGround, backgroundGround, frameColor, 1, true);
        FormData eqThreeFormData = new FormData();
        equationSeries[1].setLayoutData(eqThreeFormData);
        eqThreeFormData.top = new FormAttachment(51, 0);
        eqThreeFormData.bottom = new FormAttachment(100, 0);
        eqThreeFormData.left = new FormAttachment(0, 0);
        eqThreeFormData.right = new FormAttachment(50, 0);
        EstimatorControl.equationSeries[2] = new TimeSeriesCanvas(this, dataComposite, Messages.getString("EST.EQUATION4"), Messages.getString("EST.AXISLABEL4"), AggregateDataWriter.getKeyR(), foreGround, backgroundGround, frameColor, 2, true);
        FormData eqFourFormData = new FormData();
        equationSeries[2].setLayoutData(eqFourFormData);
        eqFourFormData.top = new FormAttachment(51, 0);
        eqFourFormData.bottom = new FormAttachment(100, 0);
        eqFourFormData.left = new FormAttachment(51, 0);
        eqFourFormData.right = new FormAttachment(100, 0);
        EstimatorControl.equationSeries[3] = new TimeSeriesCanvas(this, dataComposite, Messages.getString("EST.EQUATION2"), Messages.getString("EST.AXISLABEL2"), AggregateDataWriter.getKeyE(), foreGround, backgroundGround, frameColor, 3, true);
        FormData eqTwoFormData = new FormData();
        equationSeries[3].setLayoutData(eqTwoFormData);
        eqTwoFormData.top = new FormAttachment((Control)dataComposite, 0);
        eqTwoFormData.bottom = new FormAttachment(50, 0);
        eqTwoFormData.left = new FormAttachment(51, 0);
        eqTwoFormData.right = new FormAttachment(100, 0);
    }

    private void getRegressionSeriesCharts(Composite regressionComposite) {
        EstimatorControl.regressionSeries[0] = new XYSeriesCanvas(this, regressionComposite, Messages.getString("EST.EQUATION1"), Messages.getString("EST.RAXISLABEL1"), foreGround, backgroundGround, frameColor, 0);
        FormData eqOneFormData = new FormData();
        regressionSeries[0].setLayoutData(eqOneFormData);
        eqOneFormData.top = new FormAttachment((Control)regressionComposite, 0);
        eqOneFormData.bottom = new FormAttachment(50, 0);
        eqOneFormData.left = new FormAttachment(0, 0);
        eqOneFormData.right = new FormAttachment(50, 0);
        EstimatorControl.regressionSeries[1] = new XYSeriesCanvas(this, regressionComposite, Messages.getString("EST.EQUATION3"), Messages.getString("EST.RAXISLABEL3"), foreGround, backgroundGround, frameColor, 1);
        FormData eqThreeFormData = new FormData();
        regressionSeries[1].setLayoutData(eqThreeFormData);
        eqThreeFormData.top = new FormAttachment(51, 0);
        eqThreeFormData.bottom = new FormAttachment(100, 0);
        eqThreeFormData.left = new FormAttachment(0, 0);
        eqThreeFormData.right = new FormAttachment(50, 0);
        EstimatorControl.regressionSeries[2] = new XYSeriesCanvas(this, regressionComposite, Messages.getString("EST.EQUATION4"), Messages.getString("EST.RAXISLABEL4"), foreGround, backgroundGround, frameColor, 2);
        FormData eqFourFormData = new FormData();
        regressionSeries[2].setLayoutData(eqFourFormData);
        eqFourFormData.top = new FormAttachment(51, 0);
        eqFourFormData.bottom = new FormAttachment(100, 0);
        eqFourFormData.left = new FormAttachment(51, 0);
        eqFourFormData.right = new FormAttachment(100, 0);
        EstimatorControl.regressionSeries[3] = new XYSeriesCanvas(this, regressionComposite, Messages.getString("EST.EQUATION2"), Messages.getString("EST.RAXISLABEL2"), foreGround, backgroundGround, frameColor, 3);
        FormData eqTwoFormData = new FormData();
        regressionSeries[3].setLayoutData(eqTwoFormData);
        eqTwoFormData.top = new FormAttachment((Control)regressionComposite, 0);
        eqTwoFormData.bottom = new FormAttachment(50, 0);
        eqTwoFormData.left = new FormAttachment(51, 0);
        eqTwoFormData.right = new FormAttachment(100, 0);
    }

    public void enableAnalysis(boolean b) {
        if (b) {
            this.analyzeButton.setEnabled(true);
        } else {
            this.analyzeButton.setEnabled(false);
        }
    }

    @Override
    public void remove() {
        this.updateStatusLabel();
    }

    protected void updateStatusLabel() {
        statusLabel.setText(Messages.getString("COMMON.STATUS"));
    }

    @Override
    protected void initializeHeader(String folderName) {
        this.simulationNameLabel.setText("analyzing " + folderName);
    }

    public void dispose() {
        super.dispose();
    }

    public Identifiable getIdentifiable() {
        return null;
    }

    @Override
    public double[] getValues(int chartIndex, int state) {
        if (state <= 1) {
            return averageParms.getDataValues(regionToDisplay, chartIndex, state);
        }
        if (state <= 3) {
            return averageParms.getRegressionValues(regionToDisplay, chartIndex, state - 2);
        }
        return averageParms.getFittedValues(regionToDisplay, chartIndex, state - 4);
    }

    @Override
    public String getProperty(int chartIndex, int state) {
        return analyzer.getEstimator().getProperty(chartIndex, state);
    }

    public double getMaxThresholdS() {
        double selection = maxThresholdSpinnerS.getSelection();
        double res = 1000.0;
        return selection / res;
    }

    public double getMinThresholdS() {
        double selection = minThresholdSpinnerS.getSelection();
        double res = 1000.0;
        return selection / res;
    }

    public double getMaxThresholdE() {
        double selection = maxThresholdSpinnerE.getSelection();
        double res = 1000.0;
        return selection / res;
    }

    public double getMinThresholdE() {
        double selection = minThresholdSpinnerE.getSelection();
        double res = 1000.0;
        return selection / res;
    }

    public double getMaxThresholdI() {
        double selection = maxThresholdSpinnerI.getSelection();
        double res = 1000.0;
        return selection / res;
    }

    public double getMinThresholdI() {
        double selection = minThresholdSpinnerI.getSelection();
        double res = 1000.0;
        return selection / res;
    }

    public double getMaxThresholdR() {
        double selection = maxThresholdSpinnerR.getSelection();
        double res = 1000.0;
        return selection / res;
    }

    public double getMinThresholdR() {
        double selection = minThresholdSpinnerR.getSelection();
        double res = 1000.0;
        return selection / res;
    }

    @Override
    public int getNumProperties(int chartIndex) {
        if (analyzer != null) {
            return 2;
        }
        return 0;
    }

    @Override
    public Map<String, Object> getControlParametersMap() {
        controlParametersMap.put(MIN_S_KEY, this.getMinThresholdS());
        controlParametersMap.put(MIN_E_KEY, this.getMinThresholdE());
        controlParametersMap.put(MIN_I_KEY, this.getMinThresholdI());
        controlParametersMap.put(MIN_R_KEY, this.getMinThresholdR());
        controlParametersMap.put(MAX_S_KEY, this.getMaxThresholdS());
        controlParametersMap.put(MAX_E_KEY, this.getMaxThresholdE());
        controlParametersMap.put(MAX_I_KEY, this.getMaxThresholdI());
        controlParametersMap.put(MAX_R_KEY, this.getMaxThresholdR());
        boolean sumAllLocations = dataAverageRadioButtons[1].getSelection();
        boolean freqDependantBetaMode = betaModeRadioButtons[0].getSelection();
        controlParametersMap.put(SUM_LOCATIONS_KEY, sumAllLocations);
        controlParametersMap.put(FREQ_MODE_KEY, freqDependantBetaMode);
        return controlParametersMap;
    }
}

