/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.Activator;

public class CycleCompressor {
    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data;
    static final int WINDOW = 365;
    static final int INITIAL_PHASE_SHIFT = 30;
    public static List<Integer> peakPositions = new ArrayList<Integer>();
    static List<Double> compressedCycles = new ArrayList<Double>();
    protected static final int[] DAY_OF_CHANNUKA = new int[]{347, 702, 1086, 1430, 1794, 2179, 2533, 2916, 3271, 3625, 4008};

    public CycleCompressor(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataInstance) {
        this.data = dataInstance;
        String key = "Incidence";
        peakPositions = this.getDelayAfterChannuka(this.data, key);
        int i = 0;
        while (i < peakPositions.size()) {
            int peak = peakPositions.get(i);
            System.out.print(peak + ",");
            ++i;
        }
        Activator.logInformation("-1");
        compressedCycles = this.compressData(this.data, peakPositions, key);
    }

    public List<Integer> getPeakPositions(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance instance, String key) {
        int istop;
        int istart;
        ArrayList<Integer> peaks = new ArrayList<Integer>();
        List vector = (List)instance.getData().get(key);
        List<Double> smoothedOnce = CycleCompressor.smooth3(vector);
        List<Double> smoothed = CycleCompressor.smooth3(smoothedOnce);
        int peakPos = CycleCompressor.findPeak(smoothed, istart = 0, istop = 30);
        if (peakPos != istart) {
            peaks.add(peakPos);
        }
        int maxStartIndex = smoothed.size() - 182;
        while (peakPos < maxStartIndex) {
            istart = peakPos + 182;
            istop = istart + 365;
            peakPos = CycleCompressor.findPeak(smoothed, istart, istop);
            peaks.add(peakPos);
        }
        return peaks;
    }

    public List<Integer> getDelayAfterChannuka(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance instance, String key) {
        ArrayList<Integer> peaks = new ArrayList<Integer>();
        List vector = (List)instance.getData().get(key);
        List<Double> smoothedOnce = CycleCompressor.smooth3(vector);
        List<Double> smoothed = CycleCompressor.smooth3(smoothedOnce);
        int i = 0;
        while (i < DAY_OF_CHANNUKA.length) {
            int istart = DAY_OF_CHANNUKA[i] - 30;
            int istop = istart + 90;
            int peakPos = CycleCompressor.findPeak(smoothed, istart, istop);
            peaks.add(peakPos);
            ++i;
        }
        return peaks;
    }

    public List<Double> compressData(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance instance, List<Integer> peaks, String key) {
        List data = (List)instance.getData().get(key);
        double[] sum = new double[365];
        double[] denom = new double[365];
        int i = 0;
        while (i < 365) {
            sum[i] = 0.0;
            denom[i] = 0.0;
            ++i;
        }
        int iPeak = 0;
        while (iPeak < peaks.size()) {
            int istart;
            int nextPeak = peaks.get(iPeak);
            int index = istart = nextPeak - 182;
            int i2 = 0;
            while (i2 < 365) {
                if (index >= 0 && index < data.size()) {
                    double val = (Double)data.get(index);
                    int n = i2;
                    sum[n] = sum[n] + val;
                    int n2 = i2;
                    denom[n2] = denom[n2] + 1.0;
                }
                ++index;
                ++i2;
            }
            ++iPeak;
        }
        ArrayList<Double> compressed = new ArrayList<Double>();
        int i3 = 0;
        while (i3 < 365) {
            if (denom[i3] <= 0.0) {
                denom[i3] = 1.0;
            }
            double val = sum[i3] / denom[i3];
            compressed.add(i3, val);
            ++i3;
        }
        return compressed;
    }

    public static int findPeak(List<Double> dataList, int istart, int istop) {
        int peakIndex = istart;
        double peakVal = 0.0;
        int i = istart;
        while (i < istop) {
            double val;
            if (i < dataList.size() && (val = dataList.get(i).doubleValue()) > peakVal) {
                peakVal = val;
                peakIndex = i;
            }
            ++i;
        }
        return peakIndex;
    }

    public static int findFirstPeak(List<Double> dataList, int istart, int istop) {
        int peakIndex = istart;
        double peakVal = 0.0;
        int i = istart;
        while (i < istop) {
            if (i < dataList.size()) {
                double val = dataList.get(i);
                if (val >= peakVal) {
                    peakVal = val;
                    peakIndex = i;
                } else {
                    return peakIndex;
                }
            }
            ++i;
        }
        return peakIndex;
    }

    public static List<Double> smooth3(List<Double> dataList) {
        ArrayList<Double> smooth = new ArrayList<Double>();
        double v0 = dataList.get(0);
        double v1 = dataList.get(1);
        smooth.add((v0 + v1) / 2.0);
        int i = 1;
        while (i < dataList.size() - 1) {
            double d1 = dataList.get(i - 1);
            double d2 = dataList.get(i);
            double d3 = dataList.get(i + 1);
            smooth.add(i, (d1 + d2 + d3) / 3.0);
            ++i;
        }
        int iLast = dataList.size() - 1;
        v0 = dataList.get(iLast);
        v1 = dataList.get(iLast - 1);
        smooth.add((v0 + v1) / 2.0);
        return smooth;
    }

    public double[] getCompressedData() {
        double[] values = new double[compressedCycles.size()];
        int i = 0;
        while (i < compressedCycles.size()) {
            values[i] = compressedCycles.get(i);
            ++i;
        }
        return values;
    }
}

