/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.NodeDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.LocationUtility;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.InfectorInoculatorCollection;
import org.eclipse.stem.diseasemodels.standard.SIRInoculator;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.Messages;
import org.eclipse.stem.diseasemodels.standard.impl.SIInfectorImpl;

public class SIRInoculatorImpl
extends SIInfectorImpl
implements SIRInoculator {
    protected static final double INOCULATED_PERCENTAGE_EDEFAULT = 1.0;
    protected double inoculatedPercentage = 1.0;
    protected static final boolean INOCULATE_PERCENTAGE_EDEFAULT = true;
    protected boolean inoculatePercentage = true;
    protected static final double INFECTIOUS_COUNT_EDEFAULT = 0.0;

    @Override
    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        if (this.isGraphDecorated()) {
            return;
        }
        Graph graph = this.getGraph();
        if (graph == null && this.eContainer() instanceof InfectorInoculatorCollection) {
            graph = ((NodeDecorator)this.eContainer()).getGraph();
        }
        if (this.getDiseaseModel() == null) {
            for (Decorator decorator : graph.getDecorators()) {
                StandardDiseaseModel diseaseModel;
                if (!(decorator instanceof StandardDiseaseModel) || !(diseaseModel = (StandardDiseaseModel)decorator).getDiseaseName().equalsIgnoreCase(this.getDiseaseName())) continue;
                this.setDiseaseModel(diseaseModel);
                break;
            }
        }
        if (this.getDiseaseModel() != null) {
            Node parent = graph.getNode(this.getTargetURI());
            HashSet<Node> allNodes = null;
            if (this.isInoculatePercentage()) {
                allNodes = LocationUtility.getAllChildren((Node)parent);
                allNodes.add(parent);
            } else {
                allNodes = new HashSet<Node>();
                allNodes.add(parent);
            }
            Iterator iter = allNodes.iterator();
            block1: while (iter != null && iter.hasNext()) {
                Node node = (Node)iter.next();
                if (node != null) {
                    for (NodeLabel nodeLabel : node.getLabels()) {
                        DiseaseModelLabel diseaseModelLabel;
                        if (!(nodeLabel instanceof DiseaseModelLabel) || (diseaseModelLabel = (DiseaseModelLabel)nodeLabel).getDecorator() != this.getDiseaseModel() || !diseaseModelLabel.getPopulationModelLabel().getPopulationIdentifier().equals(this.getPopulationIdentifier())) continue;
                        this.doInitialization(diseaseModelLabel);
                        this.getLabelsToInfect().add((Object)diseaseModelLabel);
                        continue block1;
                    }
                    continue;
                }
                throw new ScenarioInitializationException(NLS.bind((String)Messages.INF_NODE_NOT_FOUND, (Object[])new Object[]{this.getTargetURI(), this.getURI().toString()}), (Identifiable)this, new Exception());
            }
        } else {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.DISEASE_NOT_FOUND, (Object[])new Object[]{this.getDiseaseName(), this.getURI().toString()}), (Identifiable)this, new Exception());
        }
        this.setProgress(1.0);
    }

    @Override
    protected void doInitialization(DiseaseModelLabel diseaseModelLabel) throws ScenarioInitializationException {
        EStructuralFeature recoveredFeature;
        String inoculateFeature = this.getTargetFeature();
        if (inoculateFeature.equals("i")) {
            inoculateFeature = "r";
        }
        if ((recoveredFeature = this.findFeature(inoculateFeature, diseaseModelLabel.getCurrentValue())) != null) {
            double newSValue;
            StandardDiseaseModelLabelValue value = null;
            DiseaseModelLabel iLabel = diseaseModelLabel;
            value = (StandardDiseaseModelLabelValue)iLabel.getCurrentValue();
            double currentSValue = value.getS();
            double currentPop = value.getPopulationCount();
            double treated = this.getInoculatedPercentage();
            if (this.isInoculatePercentage() && treated > 100.0) {
                Activator.logError(Messages.WRONG_PERCENT, null);
                treated = 100.0;
            }
            double inoculatedNumber = 0.0;
            inoculatedNumber = this.isInoculatePercentage() ? currentPop * (treated / 100.0) : treated;
            if (inoculatedNumber > currentSValue) {
                inoculatedNumber = currentSValue;
            }
            newSValue = (newSValue = currentSValue - inoculatedNumber) < 0.0 ? 0.0 : newSValue;
            inoculatedNumber = inoculatedNumber < 0.0 ? 0.0 : inoculatedNumber;
            double newRValue = (Double)value.eGet(recoveredFeature) + inoculatedNumber;
            ((StandardDiseaseModelLabelValue)iLabel.getCurrentValue()).setS(newSValue);
            ((StandardDiseaseModelLabelValue)iLabel.getNextValue()).setS(newSValue);
            ((StandardDiseaseModelLabelValue)iLabel.getCurrentValue()).eSetDouble(recoveredFeature.getFeatureID(), newRValue);
            ((StandardDiseaseModelLabelValue)iLabel.getNextValue()).eSetDouble(recoveredFeature.getFeatureID(), newRValue);
        } else {
            Activator.logError(Messages.CANNOT_INOCULATE, null);
        }
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.SIR_INOCULATOR;
    }

    @Override
    public double getInoculatedPercentage() {
        return this.inoculatedPercentage;
    }

    @Override
    public void setInoculatedPercentage(double newInoculatedPercentage) {
        this.inoculatedPercentage = newInoculatedPercentage;
    }

    @Override
    public boolean isInoculatePercentage() {
        return this.inoculatePercentage;
    }

    @Override
    public void setInoculatePercentage(boolean newInoculatePercentage) {
        this.inoculatePercentage = newInoculatePercentage;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 17: {
                return this.getInoculatedPercentage();
            }
            case 18: {
                return this.isInoculatePercentage();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 17: {
                this.setInoculatedPercentage((Double)newValue);
                return;
            }
            case 18: {
                this.setInoculatePercentage((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 17: {
                this.setInoculatedPercentage(1.0);
                return;
            }
            case 18: {
                this.setInoculatePercentage(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 17: {
                return this.inoculatedPercentage != 1.0;
            }
            case 18: {
                return !this.inoculatePercentage;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (inoculatedPercentage: ");
        result.append(this.inoculatedPercentage);
        result.append(", inoculatePercentage: ");
        result.append(this.inoculatePercentage);
        result.append(')');
        return result.toString();
    }
}

