/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.graph.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Node;

public class EdgeImpl
extends IdentifiableImpl
implements Edge {
    protected Node a;
    protected static final URI NODE_AURI_EDEFAULT = null;
    protected URI nodeAURI = NODE_AURI_EDEFAULT;
    protected Node b;
    protected static final URI NODE_BURI_EDEFAULT = null;
    protected URI nodeBURI = NODE_BURI_EDEFAULT;
    protected EdgeLabel label;
    protected static final boolean DIRECTED_EDEFAULT = false;
    protected boolean directed = false;

    protected EdgeImpl() {
        this.setTypeURI(STEMURI.EDGE_TYPE_URI);
    }

    public static Edge createEdge(Node nodeA, Node nodeB) {
        return EdgeImpl.createEdge(nodeA, nodeB, false, null);
    }

    public static Edge createEdge(Node nodeA, Node nodeB, URI edgeURI) {
        return EdgeImpl.createEdge(nodeA, nodeB, false, edgeURI);
    }

    public static Edge createEdge(Node nodeA, Node nodeB, boolean directed) {
        return EdgeImpl.createEdge(nodeA, nodeB, directed, null);
    }

    public static Edge createEdge(Node nodeA, Node nodeB, boolean directed, URI edgeURI) {
        Edge retValue = EdgeImpl.createEdge(nodeA.getURI(), nodeB.getURI(), directed, edgeURI);
        retValue.setA(nodeA);
        retValue.setB(nodeB);
        nodeA.getEdges().add((Object)retValue);
        nodeB.getEdges().add((Object)retValue);
        return retValue;
    }

    public static Edge createEdge(URI nodeAURI, URI nodeBURI) {
        return EdgeImpl.createEdge(nodeAURI, nodeBURI, false, null);
    }

    public static Edge createEdge(URI nodeAURI, URI nodeBURI, URI edgeURI) {
        return EdgeImpl.createEdge(nodeAURI, nodeBURI, false, edgeURI);
    }

    public static Edge createEdge(URI nodeAURI, URI nodeBURI, boolean directed) {
        return EdgeImpl.createEdge(nodeAURI, nodeBURI, directed, null);
    }

    public static Edge createEdge(URI nodeAURI, URI nodeBURI, boolean directed, URI edgeURI) {
        Edge retValue = GraphFactory.eINSTANCE.createEdge();
        retValue.setNodeAURI(nodeAURI);
        retValue.setNodeBURI(nodeBURI);
        retValue.setDirected(directed);
        if (edgeURI != null) {
            retValue.setURI(edgeURI);
        } else {
            retValue.setURI(STEMURI.createURI("edge/" + STEMURI.generateUniquePart()));
        }
        return retValue;
    }

    @Override
    protected EClass eStaticClass() {
        return GraphPackage.Literals.EDGE;
    }

    @Override
    public Node getA() {
        if (this.a != null && this.a.eIsProxy()) {
            InternalEObject oldA = (InternalEObject)this.a;
            this.a = (Node)this.eResolveProxy(oldA);
            if (this.a != oldA && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldA, (Object)this.a));
            }
        }
        return this.a;
    }

    public Node basicGetA() {
        return this.a;
    }

    @Override
    public void setA(Node newA) {
        Node oldA = this.a;
        this.a = newA;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldA, (Object)this.a));
        }
    }

    @Override
    public URI getNodeAURI() {
        return this.nodeAURI;
    }

    @Override
    public void setNodeAURI(URI newNodeAURI) {
        URI oldNodeAURI = this.nodeAURI;
        this.nodeAURI = newNodeAURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldNodeAURI, (Object)this.nodeAURI));
        }
    }

    @Override
    public Node getB() {
        if (this.b != null && this.b.eIsProxy()) {
            InternalEObject oldB = (InternalEObject)this.b;
            this.b = (Node)this.eResolveProxy(oldB);
            if (this.b != oldB && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldB, (Object)this.b));
            }
        }
        return this.b;
    }

    public Node basicGetB() {
        return this.b;
    }

    @Override
    public void setB(Node newB) {
        Node oldB = this.b;
        this.b = newB;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldB, (Object)this.b));
        }
    }

    @Override
    public URI getNodeBURI() {
        return this.nodeBURI;
    }

    @Override
    public void setNodeBURI(URI newNodeBURI) {
        URI oldNodeBURI = this.nodeBURI;
        this.nodeBURI = newNodeBURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldNodeBURI, (Object)this.nodeBURI));
        }
    }

    @Override
    public EdgeLabel getLabel() {
        return this.label;
    }

    public NotificationChain basicSetLabel(EdgeLabel newLabel, NotificationChain msgs) {
        EdgeLabel oldLabel = this.label;
        this.label = newLabel;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldLabel, (Object)newLabel);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLabel(EdgeLabel newLabel) {
        if (newLabel != this.label) {
            NotificationChain msgs = null;
            if (this.label != null) {
                msgs = ((InternalEObject)this.label).eInverseRemove((InternalEObject)this, 6, EdgeLabel.class, msgs);
            }
            if (newLabel != null) {
                msgs = ((InternalEObject)newLabel).eInverseAdd((InternalEObject)this, 6, EdgeLabel.class, msgs);
            }
            if ((msgs = this.basicSetLabel(newLabel, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newLabel, (Object)newLabel));
        }
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public void setDirected(boolean newDirected) {
        boolean oldDirected = this.directed;
        this.directed = newDirected;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldDirected, this.directed));
        }
    }

    @Override
    public Node getOtherNode(Node node) {
        assert (this.getA().equals(node) || this.getB().equals(node));
        return this.getA().equals(node) ? this.getB() : this.getA();
    }

    @Override
    public boolean isDirectedAt(Node node) {
        return this.isDirected() && (this.getB() != null && this.getB().equals(node) || this.getB() == null && this.getNodeBURI().equals(node.getURI()));
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                if (this.label != null) {
                    msgs = ((InternalEObject)this.label).eInverseRemove((InternalEObject)this, -8, null, msgs);
                }
                return this.basicSetLabel((EdgeLabel)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return this.basicSetLabel(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                if (resolve) {
                    return this.getA();
                }
                return this.basicGetA();
            }
            case 4: {
                return this.getNodeAURI();
            }
            case 5: {
                if (resolve) {
                    return this.getB();
                }
                return this.basicGetB();
            }
            case 6: {
                return this.getNodeBURI();
            }
            case 7: {
                return this.getLabel();
            }
            case 8: {
                return this.isDirected();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setA((Node)newValue);
                return;
            }
            case 4: {
                this.setNodeAURI((URI)newValue);
                return;
            }
            case 5: {
                this.setB((Node)newValue);
                return;
            }
            case 6: {
                this.setNodeBURI((URI)newValue);
                return;
            }
            case 7: {
                this.setLabel((EdgeLabel)newValue);
                return;
            }
            case 8: {
                this.setDirected((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setA(null);
                return;
            }
            case 4: {
                this.setNodeAURI(NODE_AURI_EDEFAULT);
                return;
            }
            case 5: {
                this.setB(null);
                return;
            }
            case 6: {
                this.setNodeBURI(NODE_BURI_EDEFAULT);
                return;
            }
            case 7: {
                this.setLabel(null);
                return;
            }
            case 8: {
                this.setDirected(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.a != null;
            }
            case 4: {
                return NODE_AURI_EDEFAULT == null ? this.nodeAURI != null : !NODE_AURI_EDEFAULT.equals(this.nodeAURI);
            }
            case 5: {
                return this.b != null;
            }
            case 6: {
                return NODE_BURI_EDEFAULT == null ? this.nodeBURI != null : !NODE_BURI_EDEFAULT.equals(this.nodeBURI);
            }
            case 7: {
                return this.label != null;
            }
            case 8: {
                return this.directed;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer("");
        result.append(this.getA() != null ? this.getA() : (this.getNodeAURI() != null ? this.getNodeAURI().toString() : "null"));
        result.append(this.isDirected() ? " -> " : " -- ");
        result.append(this.getB() != null ? this.getB() : (this.getNodeBURI() != null ? this.getNodeBURI().toString() : "null"));
        return result.toString();
    }

    @Override
    public boolean sane() {
        boolean retValue = super.sane();
        boolean bl = retValue = retValue && this.getNodeAURI() != null;
        assert (retValue);
        boolean bl2 = retValue = retValue && this.getNodeBURI() != null;
        assert (retValue);
        boolean bl3 = retValue = retValue && this.getLabel() != null;
        assert (retValue);
        if (this.getA() != null) {
            boolean bl4 = retValue = retValue && this.getA().getEdges().contains((Object)this);
            assert (retValue);
            boolean bl5 = retValue = retValue && this.getNodeAURI().equals(this.getA().getURI());
            assert (retValue);
        }
        if (this.getB() != null) {
            boolean bl6 = retValue = retValue && this.getB().getEdges().contains((Object)this);
            assert (retValue);
            boolean bl7 = retValue = retValue && this.getNodeBURI().equals(this.getB().getURI());
            assert (retValue);
        }
        boolean bl8 = retValue = retValue && (this.getA() == null && this.getB() == null || this.getA() != null && this.getB() != null);
        assert (retValue);
        boolean bl9 = retValue = retValue && this.getLabel().getURIOfIdentifiableToBeLabeled() != null;
        assert (retValue);
        boolean bl10 = retValue = retValue && this.getLabel().getURIOfIdentifiableToBeLabeled().equals(this.getURI());
        assert (retValue);
        boolean bl11 = retValue = retValue && this.getLabel().sane();
        assert (retValue);
        return retValue;
    }
}

