/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.rk.presentation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.core.solver.SolverPropertyEditor;
import org.eclipse.stem.solvers.rk.DormandPrince54;
import org.eclipse.stem.solvers.rk.DormandPrince853;
import org.eclipse.stem.solvers.rk.FastRungeKutta;
import org.eclipse.stem.solvers.rk.GraggBulirschStoer;
import org.eclipse.stem.solvers.rk.HighamHall54;
import org.eclipse.stem.solvers.rk.RkFactory;
import org.eclipse.stem.solvers.rk.RkPackage;
import org.eclipse.stem.solvers.rk.RungeKutta;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProvider;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapter;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapterFactory;
import org.eclipse.stem.ui.solvers.rk.SolverMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RkSolverPropertyEditor
extends SolverPropertyEditor {
    public RkSolverPropertyEditor(Composite parent, int style, Solver solver, ModifyListener projectValidator) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        PropertyStringProviderAdapter pspa = (PropertyStringProviderAdapter)PropertyStringProviderAdapterFactory.INSTANCE.adapt((Notifier)solver, PropertyStringProvider.class);
        ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)solver, IItemPropertySource.class);
        List properties = propertySource.getPropertyDescriptors((Object)solver);
        for (IItemPropertyDescriptor descriptor : properties) {
            EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
            if (!RkSolverPropertyEditor.isUserSpecifiedSolverProperty(feature)) continue;
            Label label = new Label((Composite)this, 0);
            label.setText(pspa.getPropertyName(descriptor));
            GridData labelGD = new GridData(1);
            labelGD.grabExcessHorizontalSpace = true;
            labelGD.horizontalAlignment = 4;
            labelGD.horizontalIndent = 0;
            label.setLayoutData((Object)labelGD);
            String defaultValueString = this.getPropertyDefaultValueString(descriptor);
            Text text = new Text((Composite)this, 133120);
            text.setText(defaultValueString);
            text.setToolTipText(pspa.getPropertyToolTip(descriptor));
            this.map.put(feature, text);
            GridData textGD = new GridData(3);
            textGD.grabExcessHorizontalSpace = true;
            textGD.horizontalAlignment = 4;
            text.setLayoutData((Object)textGD);
            text.addModifyListener(projectValidator);
            Label unitLabel = new Label((Composite)this, 0);
            unitLabel.setText(pspa.getPropertyUnits(descriptor));
            GridData unitLabelGD = new GridData(3);
            unitLabelGD.verticalAlignment = 2;
            unitLabel.setLayoutData((Object)unitLabelGD);
        }
    }

    public static boolean isUserSpecifiedSolverProperty(EStructuralFeature feature) {
        boolean retValue = false;
        EClass containingClass = feature.getEContainingClass();
        if (containingClass.equals(RkPackage.eINSTANCE.getRungeKutta()) || containingClass.equals(RkPackage.eINSTANCE.getDormandPrince853()) || containingClass.equals(RkPackage.eINSTANCE.getDormandPrince54()) || containingClass.equals(RkPackage.eINSTANCE.getFastRungeKutta()) || containingClass.equals(RkPackage.eINSTANCE.getGraggBulirschStoer()) || containingClass.equals(RkPackage.eINSTANCE.getHighamHall54())) {
            retValue = true;
        }
        return retValue;
    }

    public RkSolverPropertyEditor(Composite parent, int style) {
        super(parent, style);
    }

    public void populate(Solver solver) {
        super.populate(solver);
        for (Map.Entry entry : this.map.entrySet()) {
            double dVal = 0.0;
            if (solver instanceof RungeKutta) {
                switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                    case 5: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((RungeKutta)solver).setRelativeTolerance(dVal);
                        break;
                    }
                    case 6: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((RungeKutta)solver).setMinStep(dVal);
                        break;
                    }
                }
                continue;
            }
            if (solver instanceof DormandPrince853) {
                switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                    case 5: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((DormandPrince853)solver).setRelativeTolerance(dVal);
                        break;
                    }
                    case 6: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((DormandPrince853)solver).setAbsoluteTolerance(dVal);
                        break;
                    }
                    case 8: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((DormandPrince853)solver).setMaxStep(dVal);
                        break;
                    }
                    case 7: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((DormandPrince853)solver).setMinStep(dVal);
                        break;
                    }
                }
                continue;
            }
            if (solver instanceof DormandPrince54) {
                switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                    case 5: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((DormandPrince54)solver).setRelativeTolerance(dVal);
                        break;
                    }
                    case 6: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((DormandPrince54)solver).setAbsoluteTolerance(dVal);
                        break;
                    }
                    case 8: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((DormandPrince54)solver).setMaxStep(dVal);
                        break;
                    }
                    case 7: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((DormandPrince54)solver).setMinStep(dVal);
                        break;
                    }
                }
                continue;
            }
            if (solver instanceof FastRungeKutta) {
                switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                    case 5: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((FastRungeKutta)solver).setRelativeTolerance(dVal);
                        break;
                    }
                    case 6: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((FastRungeKutta)solver).setMinStep(dVal);
                        break;
                    }
                }
                continue;
            }
            if (solver instanceof GraggBulirschStoer) {
                switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                    case 5: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((GraggBulirschStoer)solver).setRelativeTolerance(dVal);
                        break;
                    }
                    case 6: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((GraggBulirschStoer)solver).setAbsoluteTolerance(dVal);
                        break;
                    }
                    case 8: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((GraggBulirschStoer)solver).setMaxStep(dVal);
                        break;
                    }
                    case 7: {
                        dVal = new Double(((Text)entry.getValue()).getText());
                        ((GraggBulirschStoer)solver).setMinStep(dVal);
                        break;
                    }
                }
                continue;
            }
            if (!(solver instanceof HighamHall54)) continue;
            switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                case 5: {
                    dVal = new Double(((Text)entry.getValue()).getText());
                    ((HighamHall54)solver).setRelativeTolerance(dVal);
                    break;
                }
                case 6: {
                    dVal = new Double(((Text)entry.getValue()).getText());
                    ((HighamHall54)solver).setAbsoluteTolerance(dVal);
                    break;
                }
                case 8: {
                    dVal = new Double(((Text)entry.getValue()).getText());
                    ((HighamHall54)solver).setMaxStep(dVal);
                    break;
                }
                case 7: {
                    dVal = new Double(((Text)entry.getValue()).getText());
                    ((HighamHall54)solver).setMinStep(dVal);
                    break;
                }
            }
        }
    }

    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        Text text = (Text)this.map.get(RkPackage.Literals.RUNGE_KUTTA__RELATIVE_TOLERANCE);
        if (text != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_RK_INVALID_REL_TOL");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_RK_INVALID_REL_TOL");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.RUNGE_KUTTA__MIN_STEP)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_RK_INVALID_MIN_STEP");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_RK_INVALID_MIN_STEP");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.FAST_RUNGE_KUTTA__RELATIVE_TOLERANCE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_RK_INVALID_REL_TOL");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_RK_INVALID_REL_TOL");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.FAST_RUNGE_KUTTA__MIN_STEP)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_RK_INVALID_MIN_STEP");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_RK_INVALID_MIN_STEP");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.DORMAND_PRINCE853__ABSOLUTE_TOLERANCE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_ABS_TOLERANCE");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_ABS_TOLERANCE");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.DORMAND_PRINCE853__RELATIVE_TOLERANCE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_REL_TOLERANCE");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_REL_TOLERANCE");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.DORMAND_PRINCE853__MIN_STEP)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MIN_STEP");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MIN_STEP");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.DORMAND_PRINCE853__MAX_STEP)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MAX_STEP");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MAX_STEP");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.DORMAND_PRINCE54__ABSOLUTE_TOLERANCE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_ABS_TOLERANCE");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_ABS_TOLERANCE");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.DORMAND_PRINCE54__RELATIVE_TOLERANCE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_REL_TOLERANCE");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_REL_TOLERANCE");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.DORMAND_PRINCE54__MIN_STEP)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MIN_STEP");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MIN_STEP");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.DORMAND_PRINCE54__MAX_STEP)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MAX_STEP");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MAX_STEP");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.GRAGG_BULIRSCH_STOER__ABSOLUTE_TOLERANCE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_ABS_TOLERANCE");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_ABS_TOLERANCE");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.GRAGG_BULIRSCH_STOER__RELATIVE_TOLERANCE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_REL_TOLERANCE");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_REL_TOLERANCE");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.GRAGG_BULIRSCH_STOER__MIN_STEP)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MIN_STEP");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MIN_STEP");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.GRAGG_BULIRSCH_STOER__MAX_STEP)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MAX_STEP");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MAX_STEP");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.HIGHAM_HALL54__ABSOLUTE_TOLERANCE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_ABS_TOLERANCE");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_ABS_TOLERANCE");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.HIGHAM_HALL54__RELATIVE_TOLERANCE)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_REL_TOLERANCE");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_REL_TOLERANCE");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.HIGHAM_HALL54__MIN_STEP)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MIN_STEP");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MIN_STEP");
                return false;
            }
        }
        if ((text = (Text)this.map.get(RkPackage.Literals.HIGHAM_HALL54__MAX_STEP)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MAX_STEP");
                return false;
            }
            if (!this.isValidValue(text.getText(), 0.0)) {
                this.errorMessage = SolverMessages.getString("SOLV_DP_INVALID_MAX_STEP");
                return false;
            }
        }
        return true;
    }

    private boolean isValidValue(String s, double minValue) {
        boolean ret = true;
        try {
            double d = Double.parseDouble(s);
            if (d < minValue) {
                ret = false;
            }
        }
        catch (Exception exception) {
            ret = false;
        }
        return ret;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public Solver createAndPopulateSolver() {
        Set keys = this.map.keySet();
        EStructuralFeature feature = (EStructuralFeature)keys.iterator().next();
        EClass containingClass = feature.getEContainingClass();
        RungeKutta retValue = null;
        if (containingClass.equals(RkPackage.eINSTANCE.getRungeKutta())) {
            retValue = RkFactory.eINSTANCE.createRungeKutta();
        } else if (containingClass.equals(RkPackage.eINSTANCE.getDormandPrince853())) {
            retValue = RkFactory.eINSTANCE.createDormandPrince853();
        } else if (containingClass.equals(RkPackage.eINSTANCE.getDormandPrince54())) {
            retValue = RkFactory.eINSTANCE.createDormandPrince54();
        } else if (containingClass.equals(RkPackage.eINSTANCE.getFastRungeKutta())) {
            retValue = RkFactory.eINSTANCE.createFastRungeKutta();
        } else if (containingClass.equals(RkPackage.eINSTANCE.getGraggBulirschStoer())) {
            retValue = RkFactory.eINSTANCE.createGraggBulirschStoer();
        } else if (containingClass.equals(RkPackage.eINSTANCE.getHighamHall54())) {
            retValue = RkFactory.eINSTANCE.createHighamHall54();
        }
        retValue.setURI(STEMURI.createURI((String)("RungeKuttaSolver/" + STEMURI.generateUniquePart())));
        this.populate((Solver)retValue);
        return retValue;
    }
}

