/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActualTypeArgumentCollector
extends AbstractTypeReferencePairWalker {
    private final ListMultimap<JvmTypeParameter, BoundTypeArgument> typeParameterMapping;
    private final List<JvmTypeParameter> parametersToBeMapped;

    public ActualTypeArgumentCollector(List<JvmTypeParameter> parametersToBeMapped, CommonTypeComputationServices services) {
        super(services);
        this.parametersToBeMapped = parametersToBeMapped;
        this.typeParameterMapping = ArrayListMultimap.create((int)parametersToBeMapped.size(), (int)3);
    }

    public void populateTypeParameterMapping(JvmTypeReference declaredType, JvmTypeReference actualType) {
        this.processPairedReferences(declaredType, actualType);
    }

    protected BoundTypeArgument createBoundTypeArgument(JvmTypeReference reference, BoundTypeArgumentSource source, Object origin, VarianceInfo declaredVariance, VarianceInfo actualVariance) {
        return new BoundTypeArgument(reference, source, origin, declaredVariance, actualVariance);
    }

    protected BoundTypeArgument boundByConstraint(JvmTypeReference reference, Object origin) {
        return new BoundTypeArgument(reference, BoundTypeArgumentSource.CONSTRAINT, origin, VarianceInfo.OUT, VarianceInfo.OUT);
    }

    protected BoundTypeArgument boundByInferrence(JvmTypeReference reference) {
        return new BoundTypeArgument(reference, BoundTypeArgumentSource.INFERRED, this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
    }

    @Override
    protected void processTypeParameter(JvmTypeParameter typeParameter, JvmTypeReference reference) {
        this.typeParameterMapping.put((Object)typeParameter, (Object)this.boundByInferrence(reference));
    }

    public ListMultimap<JvmTypeParameter, BoundTypeArgument> rawGetTypeParameterMapping() {
        return this.typeParameterMapping;
    }

    protected List<JvmTypeParameter> getParametersToProcess() {
        return this.parametersToBeMapped;
    }

    @Override
    protected boolean shouldProcess(JvmTypeParameter type) {
        return this.parametersToBeMapped.contains(type);
    }

    @Override
    public void processPairedReferences(JvmTypeReference declaredType, JvmTypeReference actualType) {
        if (this.parametersToBeMapped.isEmpty()) {
            return;
        }
        super.processPairedReferences(declaredType, actualType);
    }

    public ListMultimap<JvmTypeParameter, BoundTypeArgument> getTypeParameterMapping() {
        if (this.typeParameterMapping.keySet().containsAll(this.getParametersToProcess())) {
            return this.typeParameterMapping;
        }
        ArrayListMultimap result = ArrayListMultimap.create(this.typeParameterMapping);
        for (JvmTypeParameter pendingParameter : this.getParametersToProcess()) {
            if (result.containsKey((Object)pendingParameter)) continue;
            for (JvmTypeConstraint constraint : pendingParameter.getConstraints()) {
                if (!(constraint instanceof JvmUpperBound)) {
                    throw new IllegalStateException("Type parameters may not be declared with a lower bound");
                }
                JvmTypeReference constraintReference = constraint.getTypeReference();
                if (constraintReference == null) continue;
                JvmType constraintType = constraintReference.getType();
                if (!result.containsKey((Object)constraintType)) {
                    if (!this.getParametersToProcess().contains(constraintType)) {
                        Map<JvmTypeParameter, JvmTypeReference> constraintParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(constraintReference);
                        JvmTypeReference resolvedConstraint = (JvmTypeReference)new TypeParameterByConstraintSubstitutor(constraintParameterMapping, this.getServices()).visit(constraintReference, Sets.newHashSet((Object[])new JvmTypeParameter[]{pendingParameter}));
                        result.put((Object)pendingParameter, (Object)this.boundByConstraint(resolvedConstraint, pendingParameter));
                        continue;
                    }
                    result.put((Object)pendingParameter, (Object)this.boundByConstraint(this.getServices().getTypeReferences().getTypeForName(Object.class, (Notifier)pendingParameter, new JvmTypeReference[0]), pendingParameter));
                    continue;
                }
                result.putAll((Object)pendingParameter, (Iterable)result.get((Object)((JvmTypeParameter)constraintType)));
            }
        }
        return result;
    }
}

