/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.analysis.AnalysisFactory;
import org.eclipse.stem.analysis.AnalysisPackage;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.analysis.ReferenceScenarioDataMap;
import org.eclipse.stem.analysis.SimpleErrorFunction;
import org.eclipse.stem.analysis.impl.AnalysisFactoryImpl;
import org.eclipse.stem.analysis.impl.ErrorFunctionImpl;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;

public class SimpleErrorFunctionImpl
extends ErrorFunctionImpl
implements SimpleErrorFunction {
    Map<String, List<Double>> commonInfectiousLocationsA = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonInfectiousLocationsB = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonPopulationLocationsA = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonPopulationLocationsB = new HashMap<String, List<Double>>();
    Map<String, Double> commonAvgPopulationLocationsA = new HashMap<String, Double>();
    Map<String, Double> commonAvgPopulationLocationsB = new HashMap<String, Double>();
    Map<String, Double> commonMaxLocationsA = new HashMap<String, Double>();
    public double[] locationCount;
    public double[] meanSqDiff;
    public double[] time;
    protected AnalysisFactory aFactory = new AnalysisFactoryImpl();
    private static boolean AGGREGATE_NRMSE = true;
    private static boolean WEIGHTED_AVERAGE = true;
    private static boolean USE_THRESHOLD = false;
    private static double THRESHOLD = 0.05;
    int validationYear = -1;

    @Override
    protected EClass eStaticClass() {
        return AnalysisPackage.Literals.SIMPLE_ERROR_FUNCTION;
    }

    @Override
    public ErrorResult calculateError(ReferenceScenarioDataMap reference, ReferenceScenarioDataMap data) {
        double sum;
        List<Double> ld;
        ReferenceScenarioDataMapImpl _ref = (ReferenceScenarioDataMapImpl)reference;
        ReferenceScenarioDataMapImpl _data = (ReferenceScenarioDataMapImpl)data;
        this.time = null;
        Iterator<String> iteratorA = _ref.getLocations().iterator();
        int maxTime = -1;
        while (iteratorA.hasNext()) {
            String id = iteratorA.next();
            if (!_data.containsLocation(id)) continue;
            ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMapA = _ref.getLocation(id);
            List<Double> dataAI = null;
            dataAI = this.getData(this.referenceDataCompartment, dataMapA);
            List<Double> dataAP = this.getPopulation(dataMapA);
            this.commonInfectiousLocationsA.put(id, dataAI);
            this.commonPopulationLocationsA.put(id, dataAP);
            ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMapB = _data.getLocation(id);
            List<Double> dataBI = null;
            dataBI = this.getData(this.comparisonCompartment, dataMapB);
            List<Double> dataBP = this.getPopulation(dataMapB);
            this.commonInfectiousLocationsB.put(id, dataBI);
            this.commonPopulationLocationsB.put(id, dataBP);
            if (maxTime == -1) {
                maxTime = dataAI.size();
            }
            if (maxTime >= dataBI.size()) {
                maxTime = dataBI.size();
            }
            if (maxTime < dataAI.size()) continue;
            maxTime = dataAI.size();
        }
        if (maxTime <= 0) {
            maxTime = 0;
        }
        if (this.time == null) {
            this.time = new double[maxTime];
            this.meanSqDiff = new double[maxTime];
            this.locationCount = new double[maxTime];
            int i = 0;
            while (i < maxTime) {
                this.time[i] = i;
                this.meanSqDiff[i] = 0.0;
                this.locationCount[i] = 0.0;
                ++i;
            }
        }
        double[] Xref = new double[this.time.length];
        double[] Xdata = new double[this.time.length];
        double finalerror = 0.0;
        double verror = 0.0;
        BasicEList list = new BasicEList();
        int i = 0;
        while (i < this.time.length) {
            list.add((Object)0.0);
            ++i;
        }
        for (String loc : this.commonPopulationLocationsA.keySet()) {
            ld = this.commonPopulationLocationsA.get(loc);
            sum = 0.0;
            for (double d : ld) {
                sum += d;
            }
            this.commonAvgPopulationLocationsA.put(loc, sum /= (double)ld.size());
        }
        for (String loc : this.commonPopulationLocationsB.keySet()) {
            ld = this.commonPopulationLocationsB.get(loc);
            sum = 0.0;
            for (double d : ld) {
                sum += d;
            }
            this.commonAvgPopulationLocationsB.put(loc, sum /= (double)ld.size());
        }
        for (String loc : this.commonPopulationLocationsA.keySet()) {
            ld = this.commonInfectiousLocationsA.get(loc);
            double max = Double.MIN_VALUE;
            for (double d : ld) {
                if (!(d > max)) continue;
                max = d;
            }
            this.commonMaxLocationsA.put(loc, max);
        }
        double weighted_denom = 0.0;
        if (!AGGREGATE_NRMSE) {
            for (String loc : this.commonInfectiousLocationsA.keySet()) {
                double maxRef = 0.0;
                double minRef = Double.MAX_VALUE;
                int icount = 0;
                while (icount < this.time.length) {
                    List<Double> dataAI = this.commonInfectiousLocationsA.get(loc);
                    List<Double> dataBI = this.commonInfectiousLocationsB.get(loc);
                    double iA = dataAI.get(icount);
                    double iB = dataBI.get(icount);
                    Xref[icount] = iA;
                    Xdata[icount] = iB;
                    ++icount;
                }
                double nominator = 0.0;
                double timesteps = 0.0;
                int icount2 = 0;
                while (icount2 < this.time.length) {
                    if (Xref[icount2] > maxRef) {
                        maxRef = Xref[icount2];
                    }
                    if (Xref[icount2] < minRef) {
                        minRef = Xref[icount2];
                    }
                    if (!(USE_THRESHOLD && Xref[icount2] <= THRESHOLD * this.commonMaxLocationsA.get(loc) && Xdata[icount2] <= THRESHOLD * this.commonMaxLocationsA.get(loc))) {
                        nominator += Math.pow(Xref[icount2] - Xdata[icount2], 2.0);
                        list.set(icount2, (Object)((Double)list.get(icount2) + Math.abs(Xref[icount2] - Xdata[icount2])));
                        timesteps += 1.0;
                    }
                    ++icount2;
                }
                double error = Double.MAX_VALUE;
                if (!(timesteps > 0.0) || !(maxRef - minRef > 0.0)) continue;
                error = Math.sqrt(nominator / timesteps);
                finalerror = WEIGHTED_AVERAGE ? (finalerror += this.commonAvgPopulationLocationsA.get(loc) * error) : (finalerror += (error /= maxRef - minRef));
                if (WEIGHTED_AVERAGE) {
                    weighted_denom += this.commonAvgPopulationLocationsA.get(loc).doubleValue();
                    continue;
                }
                weighted_denom += 1.0;
            }
            finalerror /= weighted_denom;
        } else {
            int icount = 0;
            while (icount < this.time.length) {
                for (String loc : this.commonInfectiousLocationsA.keySet()) {
                    List<Double> dataAI = this.commonInfectiousLocationsA.get(loc);
                    List<Double> dataBI = this.commonInfectiousLocationsB.get(loc);
                    double iA = dataAI.get(icount);
                    double iB = dataBI.get(icount);
                    int n = icount;
                    Xref[n] = Xref[n] + iA;
                    int n2 = icount;
                    Xdata[n2] = Xdata[n2] + iB;
                }
                ++icount;
            }
            double maxRef = Double.MIN_VALUE;
            double minRef = Double.MAX_VALUE;
            double maxValidationRef = Double.MIN_VALUE;
            double minValidationRef = Double.MAX_VALUE;
            int icount3 = 0;
            while (icount3 < this.time.length) {
                if ((double)icount3 >= (double)this.validationYear * 365.25 && (double)icount3 <= (double)(this.validationYear + 1) * 365.25) {
                    if (Xref[icount3] > maxValidationRef) {
                        maxValidationRef = Xref[icount3];
                    }
                    if (Xref[icount3] < minValidationRef) {
                        minValidationRef = Xref[icount3];
                    }
                } else {
                    if (Xref[icount3] > maxRef) {
                        maxRef = Xref[icount3];
                    }
                    if (Xref[icount3] < minRef) {
                        minRef = Xref[icount3];
                    }
                }
                ++icount3;
            }
            double nominator = 0.0;
            double vnominator = 0.0;
            double timesteps = 0.0;
            double vtimesteps = 0.0;
            int icount4 = 0;
            while (icount4 < this.time.length) {
                if ((double)icount4 >= (double)this.validationYear * 365.25 && (double)icount4 <= (double)(this.validationYear + 1) * 365.25) {
                    if (!(USE_THRESHOLD && Xref[icount4] <= THRESHOLD * maxValidationRef && Xdata[icount4] <= THRESHOLD * maxValidationRef)) {
                        vnominator += Math.pow(Xref[icount4] - Xdata[icount4], 2.0);
                        list.set(icount4, (Object)new Double(0.0));
                        vtimesteps += 1.0;
                    }
                } else if (!(USE_THRESHOLD && Xref[icount4] <= THRESHOLD * maxRef && Xdata[icount4] <= THRESHOLD * maxRef)) {
                    nominator += Math.pow(Xref[icount4] - Xdata[icount4], 2.0);
                    list.set(icount4, (Object)Math.abs(Xref[icount4] - Xdata[icount4]));
                    timesteps += 1.0;
                }
                ++icount4;
            }
            double error = Double.MAX_VALUE;
            if (timesteps > 0.0 && maxRef - minRef > 0.0) {
                error = Math.sqrt(nominator / timesteps);
                finalerror = error / (maxRef - minRef);
            }
            error = Double.MAX_VALUE;
            if (vtimesteps > 0.0 && maxValidationRef - minValidationRef > 0.0) {
                error = Math.sqrt(vnominator / vtimesteps);
                verror = error / (maxValidationRef - minValidationRef);
            }
        }
        ErrorResult resultobj = this.aFactory.createErrorResult();
        resultobj.setErrorByTimeStep((EList<Double>)list);
        resultobj.setError(finalerror);
        resultobj.setValidationError(verror);
        BasicEList refByTime = new BasicEList();
        BasicEList dataByTime = new BasicEList();
        int icount = 0;
        while (icount < this.time.length) {
            refByTime.add((Object)0.0);
            dataByTime.add((Object)0.0);
            ++icount;
        }
        for (String loc : this.commonInfectiousLocationsA.keySet()) {
            int icount5 = 0;
            while (icount5 < this.time.length) {
                List<Double> dataAI = this.commonInfectiousLocationsA.get(loc);
                List<Double> dataBI = this.commonInfectiousLocationsB.get(loc);
                double iA = dataAI.get(icount5);
                double iB = dataBI.get(icount5);
                refByTime.set(icount5, (Object)((Double)refByTime.get(icount5) + iA));
                dataByTime.set(icount5, (Object)((Double)dataByTime.get(icount5) + iB));
                ++icount5;
            }
        }
        resultobj.setReferenceByTime((EList<Double>)refByTime);
        resultobj.setModelByTime((EList<Double>)dataByTime);
        return resultobj;
    }
}

