/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.veterinary.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.diseasemodels.functions.CTDLFunctions;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.veterinary.SimpleVeterinaryDisease;
import org.eclipse.stem.diseasemodels.veterinary.SimpleVeterinaryDiseaseLabel;
import org.eclipse.stem.diseasemodels.veterinary.SimpleVeterinaryDiseaseLabelValue;
import org.eclipse.stem.diseasemodels.veterinary.impl.ContaminatedUnitsLabelImpl;
import org.eclipse.stem.diseasemodels.veterinary.impl.ContaminatedUnitsLabelValueImpl;

public class SimpleVeterinaryDiseaseExpressions {
    public void calculate(double t, long timeDelta, STEMTime time, SimpleVeterinaryDisease model, SimpleVeterinaryDiseaseLabel label, SimpleVeterinaryDiseaseLabelValue labelValue, Node node, SimpleVeterinaryDiseaseLabelValue deltaValue) {
        double deltaS = 0.0;
        double deltaI = 0.0;
        ContaminatedUnitsLabelImpl contaminatedUnits = null;
        EList labelList = node.getLabels();
        for (NodeLabel n : labelList) {
            if (!(n instanceof ContaminatedUnitsLabelImpl)) continue;
            contaminatedUnits = (ContaminatedUnitsLabelImpl)n;
            break;
        }
        if (contaminatedUnits != null) {
            ContaminatedUnitsLabelValueImpl feces = (ContaminatedUnitsLabelValueImpl)contaminatedUnits.getCurrentValue();
            double effectiveInfections = CTDLFunctions.computeEffective((EAttribute)StandardPackage.eINSTANCE.getSILabelValue_I(), (IntegrationDecorator)model, (Node)node, (Label)label);
            deltaI += model.getTransmissionRate() * labelValue.getS() * effectiveInfections;
            deltaS -= (deltaI += model.getEnvironmentalTransmissionRate() * labelValue.getS() * Math.pow(feces.getCount(), model.getNonLinearityCoefficient()) / labelValue.getPopulationCount());
        } else {
            Activator.logInformation((String)"Scenario Configuration Error: Need to create label and label initializer for Contaminated Units");
        }
        Exchange exchange_s_i = (Exchange)ExchangePool.POOL.get();
        exchange_s_i.setType(ExchangeType.COMPARTMENT_TRANSITION);
        exchange_s_i.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
        exchange_s_i.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
        exchange_s_i.setCount(deltaI);
        exchange_s_i.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
        deltaValue.setS(deltaS);
        deltaValue.setI(deltaI);
    }
}

