/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.ui.EvaluationContextManager;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaWordFinder;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.StepIntoSelectionActionDelegate;
import org.eclipse.jdt.internal.debug.ui.actions.StepIntoSelectionUtils;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class StepIntoSelectionHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor editor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (editor != null && EvaluationContextManager.getEvaluationContext(JDIDebugUIPlugin.getActiveWorkbenchWindow()) != null) {
            IAdaptable debugContext = DebugUITools.getDebugContext();
            if (!(debugContext instanceof IJavaStackFrame)) {
                return null;
            }
            IEditorInput input = editor.getEditorInput();
            IJavaElement element = StepIntoSelectionUtils.getJavaElement(input);
            int offset = region.getOffset();
            if (element != null) {
                try {
                    IMethod method;
                    IRegion wregion;
                    IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    if (document != null && (wregion = JavaWordFinder.findWord(document, offset)) != null && (method = StepIntoSelectionUtils.getMethod((ITextSelection)new TextSelection(document, wregion.getOffset(), wregion.getLength()), element)) != null) {
                        return new IHyperlink[]{new StepIntoSelectionHyperlink(wregion)};
                    }
                }
                catch (JavaModelException jme) {
                    JDIDebugUIPlugin.log(jme);
                }
            }
        }
        return null;
    }

    class StepIntoSelectionHyperlink
    implements IHyperlink {
        private IRegion fRegion = null;

        public StepIntoSelectionHyperlink(IRegion region) {
            this.fRegion = region;
        }

        public IRegion getHyperlinkRegion() {
            return this.fRegion;
        }

        public String getHyperlinkText() {
            return ActionMessages.StepIntoSelectionHyperlinkDetector_0;
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            StepIntoSelectionActionDelegate delegate = new StepIntoSelectionActionDelegate(this.fRegion);
            delegate.init(JDIDebugUIPlugin.getActiveWorkbenchWindow());
            delegate.run(null);
        }
    }
}

