/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.headless;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.stem.jobs.DisplaySafeExecutor;
import org.eclipse.stem.model.common.Activator;
import org.eclipse.stem.ui.headless.HeadlessSimulationRunner;
import org.eclipse.stem.ui.launcher.Launcher;
import org.osgi.framework.Bundle;

public class HeadlessLauncher
extends Launcher {
    private static final String DISTRIBUTED_CONTROLLER_PLUGIN_NAME = "org.eclipse.stem.graphsynchronizer";

    protected void checkDistributed() {
        if (this.args.containsKey("distributed")) {
            try {
                System.out.println("Enabling STEM distributed mode.");
                Bundle distBundle = Platform.getBundle((String)DISTRIBUTED_CONTROLLER_PLUGIN_NAME);
                if (distBundle != null) {
                    distBundle.start(1);
                } else {
                    System.err.println("Distributed STEM plugin not found.  Distributed mode not enabled.");
                }
            }
            catch (Exception e) {
                System.err.println("Error launching distributed STEM plugin.  Will continue in standalone.");
                e.printStackTrace(System.err);
            }
        }
    }

    protected void setStreams() {
        if (this.args.containsKey("quiet")) {
            System.setOut(new PrintStream(new NullOutputStream()));
        }
    }

    public Object launch() {
        this.context.applicationRunning();
        DisplaySafeExecutor.forceHeadless();
        if (this.args.containsKey("loadWorkspacePlugins")) {
            System.out.println("Loading workspace plugins");
            Activator.getPlugin();
        }
        this.setStreams();
        this.checkDistributed();
        boolean log = this.args.containsKey("log");
        String logDir = null;
        if (log && ((List)this.args.get("log")).size() > 0) {
            logDir = (String)((List)this.args.get("log")).get(0);
        }
        HeadlessSimulationRunner runner = new HeadlessSimulationRunner(log, logDir);
        runner.run(this.args);
        return IApplication.EXIT_OK;
    }

    private class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(int b) {
        }
    }
}

