/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.preferences;

import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.xtext.builder.internal.Activator;
import org.eclipse.xtext.builder.preferences.IStatusChangeListener;
import org.eclipse.xtext.builder.preferences.ScrolledPageContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptionsConfigurationBlock {
    public static final String IS_PROJECT_SPECIFIC = "is_project_specific";
    private static final String SETTINGS_EXPANDED = "expanded";
    private static final String REBUILD_COUNT_KEY = "preferences_build_requested";
    protected final List<Button> checkBoxes = Lists.newArrayList();
    protected final List<Text> textBoxes = Lists.newArrayList();
    protected final Map<Control, Label> labels = Maps.newHashMap();
    protected final List<ExpandableComposite> expandedComposites = Lists.newArrayList();
    private SelectionListener selectionListener;
    private ModifyListener textModifyListener;
    protected IStatusChangeListener statusChangeListener;
    protected final IProject project;
    protected final String[] keys;
    private Shell shell;
    private Map<String, String> disabledProjectSettings;
    private Map<String, String> originalSettings;
    private int rebuildCount;
    private IPreferenceStore preferenceStore;
    private IWorkbenchPreferenceContainer workbenchPreferenceContainer;

    public IProject getProject() {
        return this.project;
    }

    public void setStatusChangeListener(IStatusChangeListener fContext) {
        this.statusChangeListener = fContext;
    }

    public OptionsConfigurationBlock(IProject project, String[] allKeys, IPreferenceStore preferenceStore, IWorkbenchPreferenceContainer container) {
        this.project = project;
        this.keys = allKeys;
        this.preferenceStore = preferenceStore;
        this.rebuildCount = this.getRebuildCount();
        this.workbenchPreferenceContainer = container;
        if (project == null || this.hasProjectSpecificOptions(project)) {
            this.disabledProjectSettings = null;
        } else {
            this.disabledProjectSettings = Maps.newHashMap();
            String[] stringArray = allKeys;
            int n = allKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                this.disabledProjectSettings.put(key, preferenceStore.getString(key));
                ++n2;
            }
        }
        this.captureOriginalSettings();
    }

    public boolean hasProjectSpecificOptions(IProject project) {
        return this.preferenceStore.getBoolean(IS_PROJECT_SPECIFIC);
    }

    protected void setShell(Shell shell) {
        this.shell = shell;
    }

    protected abstract Control createContents(Composite var1);

    protected Button addCheckBox(Composite parent, String label, String key, String[] values, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Button checkBox = new Button(parent, 32);
        checkBox.setFont(JFaceResources.getDialogFont());
        checkBox.setText(label);
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.getSelectionListener());
        this.makeScrollableCompositeAware((Control)checkBox);
        this.updateCheckBox(checkBox);
        this.checkBoxes.add(checkBox);
        return checkBox;
    }

    protected Text addTextField(Composite parent, String label, String key, int indent, int widthHint) {
        Label labelControl = new Label(parent, 64);
        labelControl.setText(label);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setLayoutData((Object)new GridData());
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        textBox.setLayoutData((Object)new GridData());
        this.makeScrollableCompositeAware((Control)textBox);
        this.labels.put((Control)textBox, labelControl);
        this.updateText(textBox);
        textBox.addModifyListener(this.getTextModifyListener());
        GridData data = new GridData(256);
        if (widthHint != 0) {
            data.widthHint = widthHint;
        }
        data.horizontalIndent = indent;
        data.horizontalSpan = 2;
        textBox.setLayoutData((Object)data);
        this.textBoxes.add(textBox);
        return textBox;
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    protected ExpandableComposite createStyleSection(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                OptionsConfigurationBlock.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.expandedComposites.add(excomposite);
        this.makeScrollableCompositeAware((Control)excomposite);
        return excomposite;
    }

    protected final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    protected void restoreSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.expandedComposites.size()) {
            ExpandableComposite excomposite = this.expandedComposites.get(i);
            if (settings == null) {
                excomposite.setExpanded(i == 0);
            } else {
                excomposite.setExpanded(settings.getBoolean(SETTINGS_EXPANDED + String.valueOf(i)));
            }
            ++i;
        }
    }

    protected void storeSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.expandedComposites.size()) {
            ExpandableComposite curr = this.expandedComposites.get(i);
            settings.put(SETTINGS_EXPANDED + String.valueOf(i), curr.isExpanded());
            ++i;
        }
    }

    protected SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    OptionsConfigurationBlock.this.controlChanged(e.widget);
                }
            };
        }
        return this.selectionListener;
    }

    protected ModifyListener getTextModifyListener() {
        if (this.textModifyListener == null) {
            this.textModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OptionsConfigurationBlock.this.textChanged((Text)e.widget);
                }
            };
        }
        return this.textModifyListener;
    }

    protected void controlChanged(Widget widget) {
        ControlData data = (ControlData)widget.getData();
        String newValue = null;
        if (widget instanceof Button) {
            newValue = data.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            newValue = data.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        String oldValue = this.setValue(data.getKey(), newValue);
        this.validateSettings(data.getKey(), oldValue, newValue);
    }

    protected void textChanged(Text textControl) {
        String key = (String)textControl.getData();
        String number = textControl.getText();
        String oldValue = this.setValue(key, number);
        this.validateSettings(key, oldValue, number);
    }

    protected String getValue(String key) {
        if (this.disabledProjectSettings != null) {
            return this.disabledProjectSettings.get(key);
        }
        return this.preferenceStore.getString(key);
    }

    protected String setValue(String key, String value) {
        if (this.disabledProjectSettings != null) {
            return this.disabledProjectSettings.put(key, value);
        }
        String oldValue = this.getValue(key);
        this.preferenceStore.setValue(key, value);
        return oldValue;
    }

    public void useProjectSpecificSettings(boolean enable) {
        boolean hasProjectSpecificOption;
        boolean bl = hasProjectSpecificOption = this.disabledProjectSettings == null;
        if (enable != hasProjectSpecificOption && this.project != null) {
            if (enable) {
                int i = 0;
                while (i < this.keys.length) {
                    String curr = this.keys[i];
                    String val = this.disabledProjectSettings.get(curr);
                    this.preferenceStore.putValue(curr, val);
                    ++i;
                }
                this.disabledProjectSettings = null;
                this.updateControls();
                this.validateSettings(null, null, null);
                this.preferenceStore.setValue(IS_PROJECT_SPECIFIC, true);
            } else {
                this.disabledProjectSettings = Maps.newHashMap();
                int i = 0;
                while (i < this.keys.length) {
                    String curr = this.keys[i];
                    String oldSetting = this.preferenceStore.getString(curr);
                    this.disabledProjectSettings.put(curr, oldSetting);
                    this.preferenceStore.setToDefault(curr);
                    ++i;
                }
                this.preferenceStore.setToDefault(IS_PROJECT_SPECIFIC);
            }
        }
    }

    public boolean performOk() {
        return this.processChanges(this.workbenchPreferenceContainer);
    }

    public boolean performApply() {
        return this.processChanges(this.workbenchPreferenceContainer);
    }

    private int getRebuildCount() {
        return this.preferenceStore.getDefaultInt(REBUILD_COUNT_KEY);
    }

    private void incrementRebuildCount() {
        this.preferenceStore.setDefault(REBUILD_COUNT_KEY, this.getRebuildCount() + 1);
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        String[] strings;
        int count;
        boolean needsBuild = !this.getPreferenceChanges().isEmpty();
        boolean doBuild = false;
        if (needsBuild && (count = this.getRebuildCount()) > this.rebuildCount) {
            needsBuild = false;
            this.rebuildCount = count;
        }
        if (needsBuild && (strings = this.getFullBuildDialogStrings(this.project == null)) != null) {
            MessageDialog dialog = new MessageDialog(this.shell, strings[0], null, strings[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int res = dialog.open();
            if (res == 0) {
                doBuild = true;
            } else if (res != 1) {
                return false;
            }
        }
        this.savePreferences();
        if (container != null) {
            if (doBuild) {
                this.incrementRebuildCount();
                container.registerUpdateJob(this.getBuildJob(this.getProject()));
            }
        } else if (doBuild) {
            this.getBuildJob(this.getProject()).schedule();
        }
        this.captureOriginalSettings();
        return true;
    }

    protected void savePreferences() {
        try {
            if (this.preferenceStore instanceof IPersistentPreferenceStore) {
                ((IPersistentPreferenceStore)this.preferenceStore).save();
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    public Map<String, MapDifference.ValueDifference<String>> getPreferenceChanges() {
        HashMap currentSettings = Maps.newHashMapWithExpectedSize((int)this.keys.length);
        String[] stringArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            currentSettings.put(key, this.preferenceStore.getString(key));
            ++n2;
        }
        MapDifference mapDifference = Maps.difference((Map)currentSettings, this.originalSettings);
        Map entriesDiffering = mapDifference.entriesDiffering();
        return entriesDiffering;
    }

    protected abstract Job getBuildJob(IProject var1);

    protected abstract String[] getFullBuildDialogStrings(boolean var1);

    public void performDefaults() {
        int i = 0;
        while (i < this.keys.length) {
            String curr = this.keys[i];
            String defValue = this.preferenceStore.getDefaultString(curr);
            this.setValue(curr, defValue);
            ++i;
        }
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    public void dispose() {
    }

    protected void updateControls() {
        int i = this.checkBoxes.size() - 1;
        while (i >= 0) {
            this.updateCheckBox(this.checkBoxes.get(i));
            --i;
        }
        i = this.textBoxes.size() - 1;
        while (i >= 0) {
            this.updateText(this.textBoxes.get(i));
            --i;
        }
    }

    protected void updateCheckBox(Button curr) {
        String currValue;
        ControlData data = (ControlData)curr.getData();
        curr.setSelection(data.getSelection(currValue = this.getValue(data.getKey())) == 0);
    }

    protected void updateText(Text curr) {
        String key = (String)curr.getData();
        String currValue = this.getValue(key);
        if (currValue != null) {
            curr.setText(currValue);
        }
    }

    protected abstract void validateSettings(String var1, String var2, String var3);

    private void captureOriginalSettings() {
        this.originalSettings = Maps.newHashMapWithExpectedSize((int)this.keys.length);
        String[] stringArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.originalSettings.put(key, this.preferenceStore.getString(key));
            ++n2;
        }
    }

    protected static class ControlData {
        private String key;
        private String[] values;

        public ControlData(String key, String[] values) {
            this.key = key;
            this.values = values;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.values[index];
        }

        public String getValue(int index) {
            return this.values[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.values.length) {
                    if (value.equals(this.values[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.values.length - 1;
        }
    }
}

