/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.IPreferenceAndPropertyConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractConfigurationBlockPreferenceAndPropertyPage
extends PropertyAndPreferencePage {
    private IPreferenceAndPropertyConfigurationBlock fConfigurationBlock;
    private PreferencesAccess fAccess;

    protected abstract IPreferenceAndPropertyConfigurationBlock createConfigurationBlock(IScopeContext var1);

    protected abstract String getHelpId();

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpId());
    }

    protected Control createPreferenceContent(Composite parent) {
        IPreferencePageContainer container = this.getContainer();
        Object manager = container instanceof IWorkbenchPreferenceContainer ? ((IWorkbenchPreferenceContainer)container).getWorkingCopyManager() : new WorkingCopyManager();
        this.fAccess = PreferencesAccess.getWorkingCopyPreferences(manager);
        IProject project = this.getProject();
        IScopeContext context = project != null ? this.fAccess.getProjectScope(project) : this.fAccess.getInstanceScope();
        this.fConfigurationBlock = this.createConfigurationBlock(context);
        Control content = this.fConfigurationBlock.createControl(parent);
        this.fConfigurationBlock.initialize();
        Dialog.applyDialogFont((Control)content);
        return content;
    }

    public boolean performOk() {
        this.fConfigurationBlock.performOk();
        try {
            this.fAccess.applyChanges();
        }
        catch (BackingStoreException e) {
            JavaPlugin.log(e);
        }
        return true;
    }

    public void performDefaults() {
        this.fConfigurationBlock.performDefaults();
        super.performDefaults();
    }

    public void dispose() {
        this.fConfigurationBlock.dispose();
        super.dispose();
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
        if (useProjectSpecificSettings) {
            this.fConfigurationBlock.enableProjectSettings();
        } else {
            this.fConfigurationBlock.disableProjectSettings();
        }
    }
}

