/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.grapheditor;

import java.io.File;
import java.io.FileWriter;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.ui.grapheditor.Activator;
import org.eclipse.stem.ui.grapheditor.Polygon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SpatialGmlExporter {
    private static final String MAP = "Map";
    private static final String TITLE = "title";
    private static final String SUBTITLE = "subTitle";
    private static final String UPDATED = "updated";
    private static final String ENTRY = "entry";
    private static final String WHERE = "georss:where";
    private static final String POLYGON = "gml:Polygon";
    private static final String ID = "gml:id";
    private static final String BOUNDARY = "gml:outerBoundaryIs";
    private static final String RING = "gml:LinearRing";
    private static final String POSLIST = "gml:posList";
    private static final String ISO_CODE = "ISO-8859-1";
    private static final String INDENT = "yes";

    public static void writeGML(String fileName, URI graphURI, Map<URI, Set<Polygon>> polygonMap) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (Exception e) {
            Activator.logInformation("Error parsing file " + e.getMessage());
        }
        Element root = document.createElement(MAP);
        document.appendChild(root);
        root.setAttribute("xmlns:gml", "http://www.opengis.net/gml");
        root.setAttribute("xmlns:georss", "http://www.georss.org/georss");
        Element titleElt = document.createElement(TITLE);
        titleElt.setTextContent(String.valueOf(graphURI.lastSegment()) + "  map");
        root.appendChild(titleElt);
        Element subTitleElt = document.createElement(SUBTITLE);
        subTitleElt.setTextContent("Administrative Boundaries");
        root.appendChild(subTitleElt);
        Element updatedElt = document.createElement(UPDATED);
        Calendar cal = Calendar.getInstance();
        String date = cal.getTime().toLocaleString();
        updatedElt.setTextContent(date);
        root.appendChild(updatedElt);
        Element entryElt = document.createElement(ENTRY);
        root.appendChild(entryElt);
        Element whereElt = document.createElement(WHERE);
        entryElt.appendChild(whereElt);
        for (URI uri : polygonMap.keySet()) {
            Set<Polygon> polySet = polygonMap.get(uri);
            Element polyElt = document.createElement(POLYGON);
            polyElt.setAttribute(ID, uri.lastSegment());
            whereElt.appendChild(polyElt);
            Element boundaryElt = document.createElement(BOUNDARY);
            polyElt.appendChild(boundaryElt);
            if (polySet == null) continue;
            Iterator<Polygon> rings = polySet.iterator();
            while (rings != null && rings.hasNext()) {
                Polygon p = rings.next();
                Element ringElt = document.createElement(RING);
                boundaryElt.appendChild(ringElt);
                Element posListElt = document.createElement(POSLIST);
                String data = p.getData();
                posListElt.setTextContent(data);
                ringElt.appendChild(posListElt);
            }
        }
        SpatialGmlExporter.write(document, fileName);
    }

    private static synchronized void write(Document document, String fileName) {
        try {
            File file = new File(fileName);
            file.delete();
            FileWriter fw = new FileWriter(fileName);
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(fw);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", ISO_CODE);
            serializer.setOutputProperty("indent", INDENT);
            serializer.transform(domSource, streamResult);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

