/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.codegen;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.stem.model.codegen.CodeGenConstants;
import org.eclipse.stem.model.codegen.GeneratorUtils;
import org.eclipse.stem.model.metamodel.CompartmentType;

public class STEMGenFeature {
    private GenFeature genFeature;
    private GenClass genClassContext;
    private STEMGenFeatureConstraint constraint;

    public STEMGenFeature(GenFeature genFeature, GenClass context) {
        this.genFeature = genFeature;
        this.genClassContext = context;
    }

    public static STEMGenFeature get(GenFeature genFeature) {
        return new STEMGenFeature(genFeature, null);
    }

    public static STEMGenFeature get(GenFeature genFeature, GenClass context) {
        return new STEMGenFeature(genFeature, context);
    }

    public GenClass getContextGenClass() {
        return this.genClassContext;
    }

    public GenFeature getGenFeature() {
        return this.genFeature;
    }

    public static List<String> getPrimitiveAccessorTypes() {
        return Arrays.asList(CodeGenConstants.PRIMITIVE_TYPES);
    }

    public CompartmentType getCompartmentType() {
        EAnnotation typeAnnotation = this.genFeature.getEcoreFeature().getEAnnotation("http:///org/eclipse/stem/modelgen/compartment/type");
        CompartmentType type = null;
        if (typeAnnotation != null) {
            type = CompartmentType.get((String)((String)typeAnnotation.getDetails().get((Object)"type")));
        }
        if (type == null) {
            type = CompartmentType.STANDARD;
        }
        return type;
    }

    public boolean isIncidenceFeature() {
        return this.getCompartmentType() == CompartmentType.INCIDENCE || this.genFeature.getName().toLowerCase().contains("incidence");
    }

    public boolean isDiseaseDeathsFeature() {
        return this.getCompartmentType() == CompartmentType.DEATHS || this.genFeature.getName().toLowerCase().contains("diseasedeath");
    }

    public String getBaseType() {
        return this.genFeature.getImportedType(this.genClassContext);
    }

    public boolean hasPrimitiveAccessor() {
        return STEMGenFeature.getPrimitiveAccessorTypes().contains(this.getBaseType());
    }

    public String getFullPrimitiveGetterName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPrimitiveGetterName());
        sb.append("(");
        sb.append(this.genClassContext.getQualifiedFeatureID(this.genFeature));
        sb.append(")");
        return sb.toString();
    }

    public String getFullPrimitiveSetterName(String parameterName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPrimitiveSetterName());
        sb.append("(");
        sb.append(this.genClassContext.getQualifiedFeatureID(this.genFeature));
        sb.append(", ");
        sb.append(parameterName);
        sb.append(")");
        return sb.toString();
    }

    public String getGetterName() {
        return this.genFeature.getGetAccessor();
    }

    public String getSetterName() {
        return "set" + this.genFeature.getAccessorName();
    }

    public String getFullGetterName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetterName());
        sb.append("()");
        return sb.toString();
    }

    public String getFullSetterName(String parameterName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSetterName());
        sb.append("(");
        sb.append(parameterName);
        sb.append(")");
        return sb.toString();
    }

    public String getPrimitiveGetterName() {
        String type = this.getBaseType();
        List<String> types = STEMGenFeature.getPrimitiveAccessorTypes();
        if (types.contains(type)) {
            return STEMGenFeature.getPrimitiveGetterName(type);
        }
        return null;
    }

    public String getPrimitiveSetterName() {
        String type = this.getBaseType();
        List<String> types = STEMGenFeature.getPrimitiveAccessorTypes();
        if (types.contains(type)) {
            return STEMGenFeature.getPrimitiveSetterName(type);
        }
        return null;
    }

    public static String getPrimitiveAccessorName(String prefix, String primitiveName) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(primitiveName.substring(0, 1).toUpperCase());
        sb.append(primitiveName.substring(1).toLowerCase());
        return sb.toString();
    }

    public static String getPrimitiveGetterName(String primitive) {
        return STEMGenFeature.getPrimitiveAccessorName("eGet", primitive);
    }

    public static String getPrimitiveSetterName(String primitive) {
        return STEMGenFeature.getPrimitiveAccessorName("eSet", primitive);
    }

    public STEMGenFeatureConstraint getConstraint() {
        EAnnotation annotation;
        if (this.constraint == null && (annotation = this.genFeature.getEcoreFeature().getEAnnotation("http:///org/eclipse/stem/modelgen/modelparam/constraints")) != null) {
            this.constraint = new STEMGenFeatureConstraint(annotation, this);
        }
        return this.constraint;
    }

    public static String getValueForAnnotationKey(EAnnotation annotation, String key) {
        if (annotation != null) {
            return (String)annotation.getDetails().get((Object)key);
        }
        return null;
    }

    private EAnnotation getMessagesAnnotation() {
        return this.genFeature.getEcoreFeature().getEAnnotation("http:///org/eclipse/stem/modelgen/modelparam/messages");
    }

    private String getMessageForKey(String key, String defaultMessage) {
        String retVal = STEMGenFeature.getValueForAnnotationKey(this.getMessagesAnnotation(), key);
        if (GeneratorUtils.isNullOrEmpty(retVal)) {
            retVal = defaultMessage;
        }
        return retVal;
    }

    public String getUnitMessage() {
        return this.getMessageForKey("unit", "");
    }

    public String getInvalidMessage() {
        return this.getMessageForKey("invalid", this.getDefaultInvalidMessage());
    }

    public String getMissingMessage() {
        return this.getMessageForKey("missing", this.getDefaultMissingMessage());
    }

    public String getToolTipMessage() {
        return this.getMessageForKey("tooltip", this.getDefaultToolTipMessage());
    }

    public String getNameMessage() {
        return this.getMessageForKey("name", this.getDefaultNameMessage());
    }

    public String getDefaultToolTipMessage() {
        return this.getNameMessage();
    }

    public String getDefaultMissingMessage() {
        return "A value for " + this.getNameMessage() + " is required";
    }

    public String getDefaultInvalidMessage() {
        return "The value for " + this.getNameMessage() + " is invalid";
    }

    public String getDefaultNameMessage() {
        return this.genFeature.getFormattedName();
    }

    public boolean isRequired() {
        return this.genFeature.getEcoreFeature().getLowerBound() > 0;
    }

    public static class STEMGenFeatureConstraint {
        public STEMGenFeature stemGenFeature;
        public EAnnotation annotation;
        public boolean hasMin = false;
        public boolean hasMax = false;
        public double minValue = Double.NEGATIVE_INFINITY;
        public double maxValue = Double.POSITIVE_INFINITY;
        public String regexPattern;
        public static final String MIN_VALUE_KEY = "min";
        public static final String MAX_VALUE_KEY = "max";
        public static final String REGEX_KEY = "regex";

        public STEMGenFeatureConstraint(EAnnotation annotation, STEMGenFeature stemGenFeature) {
            this.stemGenFeature = stemGenFeature;
            this.annotation = annotation;
            this.populate();
        }

        public void populate() {
            String max;
            EMap details = this.annotation.getDetails();
            String min = (String)details.get((Object)MIN_VALUE_KEY);
            if (min != null) {
                try {
                    this.minValue = Double.parseDouble(min);
                    this.hasMin = true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((max = (String)details.get((Object)MAX_VALUE_KEY)) != null) {
                try {
                    this.maxValue = Double.parseDouble(max);
                    this.hasMax = true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.regexPattern = (String)details.get((Object)REGEX_KEY);
        }

        public boolean hasMin() {
            return this.hasMin;
        }

        public boolean hasMax() {
            return this.hasMax;
        }

        public double getMin() {
            return this.minValue;
        }

        public double getMax() {
            return this.maxValue;
        }

        public boolean isRequired() {
            return this.stemGenFeature.isRequired();
        }
    }
}

