/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.contextlaunching.ContextRunner;
import org.eclipse.debug.internal.ui.contextlaunching.LaunchingResourceManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public abstract class RelaunchLastAction
implements IWorkbenchWindowActionDelegate {
    private Listener fListener = new Listener();
    private IWorkbenchWindow fWorkbenchWindow;
    private IAction fAction;
    static /* synthetic */ Class class$0;

    public void dispose() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(DebugUIPlugin.getUniqueIdentifier());
        if (prefs != null) {
            prefs.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.fListener);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbenchWindow = window;
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(DebugUIPlugin.getUniqueIdentifier());
        if (prefs != null) {
            prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.fListener);
        }
    }

    public void run(IAction action) {
        if (LaunchingResourceManager.isContextLaunchEnabled()) {
            LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(this.getLaunchGroupId());
            ContextRunner.getDefault().launch(group);
            return;
        }
        try {
            ILaunchConfiguration configuration = this.getLastLaunch();
            if (configuration != null) {
                if (configuration.supportsMode(this.getMode())) {
                    DebugUITools.launch(configuration, this.getMode());
                } else {
                    String configName = configuration.getName();
                    String title = ActionMessages.RelaunchLastAction_Cannot_relaunch_1;
                    String message = MessageFormat.format((String)ActionMessages.RelaunchLastAction_Cannot_relaunch___0___because_it_does_not_support__2__mode_2, (Object[])new String[]{configName, this.getMode()});
                    MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                }
            } else {
                this.openLaunchConfigurationDialog();
            }
        }
        catch (CoreException ce) {
            DebugUIPlugin.errorDialog(this.getShell(), ActionMessages.RelaunchLastAction_Error_relaunching_3, ActionMessages.RelaunchLastAction_Error_encountered_attempting_to_relaunch_4, ce);
        }
    }

    private void openLaunchConfigurationDialog() {
        IWorkbenchWindow dwindow = DebugUIPlugin.getActiveWorkbenchWindow();
        if (dwindow == null) {
            return;
        }
        LaunchConfigurationsDialog dialog = new LaunchConfigurationsDialog(DebugUIPlugin.getShell(), DebugUIPlugin.getDefault().getLaunchConfigurationManager().getDefaultLaunchGroup(this.getMode()));
        dialog.setOpenMode(2);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fAction == null) {
            this.initialize(action);
        }
    }

    private void initialize(IAction action) {
        this.fAction = action;
        if (this.fAction != null) {
            ICommandService service;
            this.fAction.setEnabled(this.existsConfigTypesForMode());
            this.fAction.setText(this.getText());
            this.fAction.setToolTipText(this.getTooltipText());
            String commandId = this.getCommandId();
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((service = (ICommandService)iWorkbench.getService((Class)clazz)) != null) {
                Command command = service.getCommand(commandId);
                command.undefine();
                command = service.getCommand(commandId);
                command.define(DebugUIPlugin.removeAccelerators(this.getText()), this.getDescription(), service.getCategory("org.eclipse.debug.ui.category.run"));
            }
        }
    }

    private boolean existsConfigTypesForMode() {
        ILaunchConfigurationType[] configTypes = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int i = 0;
        while (i < configTypes.length) {
            ILaunchConfigurationType configType = configTypes[i];
            if (configType.supportsMode(this.getMode())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ILaunchConfiguration getLastLaunch() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getFilteredLastLaunch(this.getLaunchGroupId());
    }

    protected Shell getShell() {
        return this.fWorkbenchWindow.getShell();
    }

    protected abstract String getMode();

    protected abstract String getLaunchGroupId();

    protected abstract String getText();

    protected abstract String getTooltipText();

    protected abstract String getCommandId();

    protected abstract String getDescription();

    private class Listener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private Listener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("org.eclipse.debug.ui.UseContextualLaunch")) {
                RelaunchLastAction.this.initialize(RelaunchLastAction.this.fAction);
            }
        }
    }
}

