/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.LabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class TreeModelLabelProvider
extends ColumnLabelProvider
implements ITreeModelLabelProvider,
IModelChangedListener {
    private IInternalTreeModelViewer fViewer;
    private List fComplete;
    private Map fImageCache = new HashMap();
    private Map fFontCache = new HashMap();
    private Map fColorCache = new HashMap();
    private ListenerList fLabelListeners = new ListenerList();
    private Map fPendingUpdates = new HashMap();
    private Runnable fPendingUpdatesRunnable;
    private List fUpdatesInProgress = new ArrayList();
    private CancelPendingUpdatesVisitor fCancelPendingUpdatesVisitor = new CancelPendingUpdatesVisitor();

    public TreeModelLabelProvider(IInternalTreeModelViewer viewer) {
        this.fViewer = viewer;
        this.fViewer.addModelChangedListener(this);
    }

    public Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = (Image)this.fImageCache.get(descriptor);
        if (image == null) {
            image = new Image((Device)this.getDisplay(), descriptor.getImageData());
            this.fImageCache.put(descriptor, image);
        }
        return image;
    }

    private Display getDisplay() {
        return this.fViewer.getDisplay();
    }

    public Font getFont(FontData fontData) {
        if (fontData == null) {
            return null;
        }
        Font font = (Font)this.fFontCache.get(fontData);
        if (font == null) {
            font = new Font((Device)this.getDisplay(), fontData);
            this.fFontCache.put(fontData, font);
        }
        return font;
    }

    public Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        Color color = (Color)this.fColorCache.get(rgb);
        if (color == null) {
            color = new Color((Device)this.getDisplay(), rgb);
            this.fColorCache.put(rgb, color);
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Assert.isTrue((this.fViewer.getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.fViewer.removeModelChangedListener(this);
        this.fViewer = null;
        List complete = null;
        TreeModelLabelProvider treeModelLabelProvider = this;
        synchronized (treeModelLabelProvider) {
            complete = this.fComplete;
            this.fComplete = null;
        }
        if (complete != null) {
            Iterator itr = complete.iterator();
            while (itr.hasNext()) {
                ((ILabelUpdate)itr.next()).cancel();
            }
        }
        Iterator updatesInProgress = this.fUpdatesInProgress.iterator();
        while (updatesInProgress.hasNext()) {
            ILabelUpdate currentUpdate = (ILabelUpdate)updatesInProgress.next();
            currentUpdate.cancel();
        }
        if (this.fPendingUpdatesRunnable != null) {
            this.fPendingUpdatesRunnable = null;
        }
        Iterator itr = this.fPendingUpdates.values().iterator();
        while (itr.hasNext()) {
            List updateList = (List)itr.next();
            Iterator listItr = updateList.iterator();
            while (listItr.hasNext()) {
                ((LabelUpdate)listItr.next()).cancel();
            }
        }
        this.fPendingUpdates.clear();
        Iterator images = this.fImageCache.values().iterator();
        while (images.hasNext()) {
            Image image = (Image)images.next();
            image.dispose();
        }
        this.fImageCache.clear();
        Iterator fonts = this.fFontCache.values().iterator();
        while (fonts.hasNext()) {
            Font font = (Font)fonts.next();
            font.dispose();
        }
        this.fFontCache.clear();
        Iterator colors = this.fColorCache.values().iterator();
        while (colors.hasNext()) {
            Color color = (Color)colors.next();
            color.dispose();
        }
        this.fColorCache.clear();
        super.dispose();
    }

    private boolean isDisposed() {
        return this.fViewer == null;
    }

    public void update(ViewerCell cell) {
    }

    public boolean update(TreePath elementPath) {
        Assert.isTrue((this.fViewer.getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.cancelPathUpdates(elementPath);
        String[] visibleColumns = this.fViewer.getVisibleColumns();
        Object element = elementPath.getLastSegment();
        IElementLabelProvider presentation = ViewerAdapterService.getLabelProvider(element);
        if (presentation != null) {
            LinkedList<LabelUpdate> updates = (LinkedList<LabelUpdate>)this.fPendingUpdates.get(presentation);
            if (updates == null) {
                updates = new LinkedList<LabelUpdate>();
                this.fPendingUpdates.put(presentation, updates);
            }
            updates.add(new LabelUpdate(this.fViewer.getInput(), elementPath, this, visibleColumns, this.fViewer.getPresentationContext()));
            this.fPendingUpdatesRunnable = new Runnable(){

                public void run() {
                    if (TreeModelLabelProvider.this.isDisposed()) {
                        return;
                    }
                    TreeModelLabelProvider.this.startRequests(this);
                }
            };
            this.fViewer.getDisplay().asyncExec(this.fPendingUpdatesRunnable);
            return true;
        }
        return false;
    }

    private void cancelPathUpdates(TreePath elementPath) {
        Assert.isTrue((this.fViewer.getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        Iterator updatesInProgress = this.fUpdatesInProgress.iterator();
        while (updatesInProgress.hasNext()) {
            ILabelUpdate currentUpdate = (ILabelUpdate)updatesInProgress.next();
            if (!elementPath.equals((Object)currentUpdate.getElementPath())) continue;
            currentUpdate.cancel();
        }
    }

    void setElementData(TreePath path, int numColumns, String[] labels, ImageDescriptor[] images, FontData[] fontDatas, RGB[] foregrounds, RGB[] backgrounds, boolean checked, boolean grayed) {
        this.fViewer.setElementData(path, numColumns, labels, images, fontDatas, foregrounds, backgrounds);
        this.fViewer.setElementChecked(path, checked, grayed);
    }

    private void startRequests(Runnable runnable) {
        if (runnable != this.fPendingUpdatesRunnable) {
            return;
        }
        if (!this.fPendingUpdates.isEmpty()) {
            Iterator itr = this.fPendingUpdates.keySet().iterator();
            while (itr.hasNext()) {
                IElementLabelProvider provider = (IElementLabelProvider)itr.next();
                List list = (List)this.fPendingUpdates.get(provider);
                Iterator listItr = list.iterator();
                while (listItr.hasNext()) {
                    this.updateStarted((ILabelUpdate)listItr.next());
                }
                provider.update(list.toArray(new ILabelUpdate[list.size()]));
            }
        }
        this.fPendingUpdates.clear();
        this.fPendingUpdatesRunnable = null;
    }

    private void cancelElementUpdates(Object element, boolean searchFullPath) {
        Iterator updatesInProgress = this.fUpdatesInProgress.iterator();
        block0: while (updatesInProgress.hasNext()) {
            ILabelUpdate currentUpdate = (ILabelUpdate)updatesInProgress.next();
            if (searchFullPath) {
                if (element.equals(this.fViewer.getInput())) {
                    currentUpdate.cancel();
                    continue;
                }
                TreePath updatePath = currentUpdate.getElementPath();
                int i = 0;
                while (i < updatePath.getSegmentCount()) {
                    if (element.equals(updatePath.getSegment(i))) {
                        currentUpdate.cancel();
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (!element.equals(currentUpdate.getElement())) continue;
            currentUpdate.cancel();
        }
    }

    private IPresentationContext getPresentationContext() {
        return this.fViewer.getPresentationContext();
    }

    synchronized void complete(ILabelUpdate update) {
        if (this.fViewer == null) {
            return;
        }
        if (this.fComplete == null) {
            this.fComplete = new LinkedList();
            this.fViewer.getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (TreeModelLabelProvider.this.isDisposed()) {
                        return;
                    }
                    List updates = null;
                    TreeModelLabelProvider treeModelLabelProvider = TreeModelLabelProvider.this;
                    synchronized (treeModelLabelProvider) {
                        updates = TreeModelLabelProvider.this.fComplete;
                        TreeModelLabelProvider.this.fComplete = null;
                    }
                    Iterator itr = updates.iterator();
                    while (itr.hasNext()) {
                        LabelUpdate itrUpdate = (LabelUpdate)itr.next();
                        if (itrUpdate.isCanceled()) {
                            TreeModelLabelProvider.this.updateComplete(itrUpdate);
                            continue;
                        }
                        itrUpdate.performUpdate();
                    }
                }
            });
        }
        this.fComplete.add(update);
    }

    public void addLabelUpdateListener(ILabelUpdateListener listener) {
        this.fLabelListeners.add((Object)listener);
    }

    public void removeLabelUpdateListener(ILabelUpdateListener listener) {
        this.fLabelListeners.remove((Object)listener);
    }

    void updateStarted(ILabelUpdate update) {
        Assert.isTrue((this.fViewer.getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        boolean begin = this.fUpdatesInProgress.isEmpty();
        this.fUpdatesInProgress.add(update);
        if (begin) {
            if (DebugUIPlugin.DEBUG_UPDATE_SEQUENCE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("LABEL SEQUENCE BEGINS");
            }
            this.notifyUpdate(0, null);
        }
        if (DebugUIPlugin.DEBUG_UPDATE_SEQUENCE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            DebugUIPlugin.trace("\tBEGIN - " + update);
        }
        this.notifyUpdate(2, update);
    }

    void updateComplete(ILabelUpdate update) {
        this.fUpdatesInProgress.remove(update);
        if (DebugUIPlugin.DEBUG_UPDATE_SEQUENCE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            DebugUIPlugin.trace("\tEND - " + update);
        }
        this.notifyUpdate(3, update);
        if (this.fUpdatesInProgress.isEmpty()) {
            if (DebugUIPlugin.DEBUG_UPDATE_SEQUENCE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("LABEL SEQUENCE ENDS");
            }
            this.notifyUpdate(1, null);
        }
    }

    private void notifyUpdate(final int type, final ILabelUpdate update) {
        if (!this.fLabelListeners.isEmpty()) {
            Object[] listeners = this.fLabelListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final ILabelUpdateListener listener = (ILabelUpdateListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        switch (type) {
                            case 0: {
                                listener.labelUpdatesBegin();
                                break;
                            }
                            case 1: {
                                listener.labelUpdatesComplete();
                                break;
                            }
                            case 2: {
                                listener.labelUpdateStarted(update);
                                break;
                            }
                            case 3: {
                                listener.labelUpdateComplete(update);
                            }
                        }
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
                ++i;
            }
        }
    }

    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
        delta.accept(this.fCancelPendingUpdatesVisitor);
    }

    class CancelPendingUpdatesVisitor
    implements IModelDeltaVisitor {
        CancelPendingUpdatesVisitor() {
        }

        public boolean visit(IModelDelta delta, int depth) {
            if ((delta.getFlags() & 0x400) > 0) {
                TreeModelLabelProvider.this.cancelElementUpdates(delta.getElement(), true);
                return false;
            }
            if ((delta.getFlags() & 0x800) > 0) {
                TreeModelLabelProvider.this.cancelElementUpdates(delta.getElement(), false);
                return true;
            }
            return true;
        }
    }
}

